/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4019;
import net.minecraft.class_638;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private AXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private ArrayList<class_1297> players;
    private ArrayList<class_1297> living;
    private ArrayList<class_1297> livingTamed;
    private ArrayList<class_1297> hostile;
    private ArrayList<class_1297> items;
    private ArrayList<class_1297> entities;
    private ArrayList<class_1297> playersOtherTeams;
    public class_2940<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    public class_2940<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;

    public MinimapRadar(AXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.players = new ArrayList();
        this.living = new ArrayList();
        this.livingTamed = new ArrayList();
        this.hostile = new ArrayList();
        this.items = new ArrayList();
        this.entities = new ArrayList();
        this.playersOtherTeams = new ArrayList();
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = class_4019.class.getDeclaredField("field_17951");
        }
        catch (Exception e) {
            try {
                foxTrustSecondaryField = class_4019.class.getDeclaredField("OWNER");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        try {
            foxTrustMainField = class_4019.class.getDeclaredField("field_17952");
        }
        catch (Exception e) {
            try {
                foxTrustMainField = class_4019.class.getDeclaredField("OTHER_TRUSTED");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (foxTrustSecondaryField != null) {
            try {
                boolean accessibleBU = foxTrustSecondaryField.isAccessible();
                foxTrustSecondaryField.setAccessible(true);
                this.FOX_TRUSTED_UUID_SECONDARY = (class_2940)foxTrustSecondaryField.get(null);
                foxTrustSecondaryField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (foxTrustMainField != null) {
            try {
                boolean accessibleBU = foxTrustMainField.isAccessible();
                foxTrustMainField.setAccessible(true);
                this.FOX_TRUSTED_UUID_MAIN = (class_2940)foxTrustMainField.get(null);
                foxTrustMainField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getType(class_1297 e, class_1657 p, boolean ignoreTamed) {
        if (e instanceof class_1657) {
            if (p.method_5781() != ((class_1657)e).method_5781()) {
                return 6;
            }
            return 1;
        }
        if (!ignoreTamed && this.isTamed(e, p)) {
            return 7;
        }
        if (class_310.method_1551().field_1687.method_8407() != class_1267.field_5801 && !this.hostileException(e) && (e instanceof class_1588 || e instanceof class_1569 || e.method_5634() == class_3419.field_15251)) {
            return 2;
        }
        if (e instanceof class_1309) {
            return 3;
        }
        if (e instanceof class_1542) {
            return 4;
        }
        return 0;
    }

    public void updateRadar(class_638 world, class_1657 p, class_1297 renderEntity, MinimapProcessor minimap) {
        this.players.clear();
        this.hostile.clear();
        this.living.clear();
        this.items.clear();
        this.entities.clear();
        this.playersOtherTeams.clear();
        this.livingTamed.clear();
        if (world == null || p == null || renderEntity == null || p.method_6059(Effects.NO_RADAR) || p.method_6059(Effects.NO_RADAR_BENEFICIAL) || p.method_6059(Effects.NO_RADAR_HARMFUL)) {
            return;
        }
        Iterable worldEntities = world.method_18112();
        ModSettings settings = this.modMain.getSettings();
        int cullingSize = minimap.getMinimapSize() / 2 + 48;
        double maxDistance = (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
        for (class_1297 e : worldEntities) {
            try {
                int type = this.getType(e, p, false);
                if (type == 1 ? e != p && !settings.getShowPlayers() : (type == 2 ? !settings.getShowHostile() : (type == 3 ? !settings.getShowMobs() : (type == 4 ? !settings.getShowItems() : (type == 6 ? !settings.getShowOtherTeam() : (type == 7 ? !settings.getShowTamedMobs() : !settings.getShowOther() || e instanceof class_1533 && !settings.itemFramesOnRadar)))))) continue;
                double offx = e.method_23317() - renderEntity.method_23317();
                double offy = e.method_23321() - renderEntity.method_23321();
                double offh = renderEntity.method_23318() - e.method_23318();
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(settings.heightLimit * settings.heightLimit)) continue;
                ArrayList<class_1297> typeList = this.entities;
                switch (type) {
                    case 1: {
                        typeList = this.players;
                        break;
                    }
                    case 2: {
                        typeList = this.hostile;
                        break;
                    }
                    case 3: {
                        typeList = this.living;
                        break;
                    }
                    case 4: {
                        typeList = this.items;
                        break;
                    }
                    case 6: {
                        typeList = this.playersOtherTeams;
                        break;
                    }
                    case 7: {
                        typeList = this.livingTamed;
                    }
                }
                if (settings.entityAmount != 0 && typeList.size() >= 100 * settings.entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    private boolean hostileException(class_1297 e) {
        return false;
    }

    public double getEntityX(class_1297 e, float partial) {
        return e.field_6038 + (e.method_23317() - e.field_6038) * (double)partial;
    }

    public double getEntityZ(class_1297 e, float partial) {
        return e.field_5989 + (e.method_23321() - e.field_5989) * (double)partial;
    }

    public boolean shouldRenderEntity(class_1297 e, class_1297 renderEntity) {
        return e == renderEntity || !e.method_5715() && !e.method_5767();
    }

    public int getPlayerTeamColour(class_1657 p) {
        Integer teamColour = null;
        class_270 team = p.method_5781();
        if (team != null) {
            teamColour = team.method_1202().method_532();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(class_1657 p, class_1297 e, float offh, boolean cave, ModSettings settings) {
        int entityTeamColour;
        int type = this.getType(e, p, settings.tamedMobsColor == -1);
        if (type == 6 && settings.otherTeamColor == -1) {
            type = 1;
        }
        int color = type == 1 ? (settings.playersColor != -1 ? ModSettings.COLORS[settings.playersColor] : ((entityTeamColour = this.getPlayerTeamColour((class_1657)e)) != -1 ? entityTeamColour : -1)) : (type == 2 ? ModSettings.COLORS[settings.hostileColor] : (type == 3 ? ModSettings.COLORS[settings.mobsColor] : (type == 4 ? ModSettings.COLORS[settings.itemsColor] : (type == 6 ? ModSettings.COLORS[settings.otherTeamColor] : (type == 7 ? ModSettings.COLORS[settings.tamedMobsColor] : ModSettings.COLORS[settings.otherColor])))));
        float brightness = this.getEntityBrightness(offh, settings);
        if (brightness < 1.0f) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = 255;
            if (cave) {
                a = (int)((float)a * brightness);
            } else {
                r = (int)((float)r * brightness);
                g = (int)((float)g * brightness);
                b = (int)((float)b * brightness);
            }
            color = a << 24 | r << 16 | g << 8 | b;
        }
        return color;
    }

    public float getEntityBrightness(float offh, ModSettings settings) {
        float level = (float)settings.heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        if (level <= (float)(settings.heightLimit / 2) && settings.showEntityHeight) {
            brightness = 0.25f + 0.5f * level / (float)settings.heightLimit;
        }
        return brightness;
    }

    public Iterator<class_1297> getEntitiesIterator() {
        return this.entities.iterator();
    }

    public Iterator<class_1297> getItemsIterator() {
        return this.items.iterator();
    }

    public Iterator<class_1297> getLivingIterator() {
        return this.living.iterator();
    }

    public Iterator<class_1297> getLivingTamedIterator() {
        return this.livingTamed.iterator();
    }

    public Iterator<class_1297> getHostileIterator() {
        return this.hostile.iterator();
    }

    public Iterator<class_1297> getPlayersIterator() {
        return this.players.iterator();
    }

    public Iterator<class_1297> getPlayersOtherTeamsIterator() {
        return this.playersOtherTeams.iterator();
    }

    private boolean isTamed(class_1297 e, class_1657 p) {
        if (e instanceof class_1321) {
            class_1321 tameable = (class_1321)e;
            if (tameable.method_6181() && p.method_5667().equals(tameable.method_6139())) {
                return true;
            }
        } else if (e instanceof class_1496) {
            class_1496 horse = (class_1496)e;
            if (horse.method_6727() && p.method_5667().equals(horse.method_6768())) {
                return true;
            }
        } else if (e instanceof class_4019) {
            class_4019 fox = (class_4019)e;
            if (this.FOX_TRUSTED_UUID_SECONDARY != null && p.method_5667().equals(((Optional)fox.method_5841().method_12789(this.FOX_TRUSTED_UUID_SECONDARY)).orElse(null))) {
                return true;
            }
            if (this.FOX_TRUSTED_UUID_MAIN != null && p.method_5667().equals(((Optional)fox.method_5841().method_12789(this.FOX_TRUSTED_UUID_MAIN)).orElse(null))) {
                return true;
            }
        }
        return false;
    }
}

