/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4493;
import net.minecraft.class_4597;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsGuiRenderer {
    private AXaeroMinimap modMain;
    private class_310 mc;

    public WaypointsGuiRenderer(AXaeroMinimap modMain, class_310 mc) {
        this.modMain = modMain;
        this.mc = mc;
    }

    public void render(XaeroMinimapSession minimapSession, MinimapRendererHelper rendererHelper, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double zoom, boolean circle, float minimapScale, class_4597.class_4598 textRenderTypeBuffer, boolean safeMode) {
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        RenderSystem.disableDepthTest();
        if (this.modMain.getSettings().compassOverWaypoints) {
            this.drawWaypoints(waypointsManager, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale, textRenderTypeBuffer);
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false, textRenderTypeBuffer);
            }
        } else {
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false, textRenderTypeBuffer);
            }
            this.drawWaypoints(waypointsManager, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale, textRenderTypeBuffer);
        }
    }

    private void drawWaypoints(WaypointsManager waypointsManager, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double dimDiv, double zoom, boolean circle, float minimapScale, class_4597.class_4598 textRenderTypeBuffer) {
        if (this.mc.field_1724.method_6059(Effects.NO_WAYPOINTS) || this.mc.field_1724.method_6059(Effects.NO_WAYPOINTS_BENEFICIAL) || this.mc.field_1724.method_6059(Effects.NO_WAYPOINTS_HARMFUL)) {
            return;
        }
        if (this.modMain.getSettings().getShowWaypoints() && waypointsManager.getWaypoints() != null) {
            if (this.modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    this.renderWaypointsList(setEntry.getValue().getList(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale, textRenderTypeBuffer);
                }
            } else {
                this.renderWaypointsList(waypointsManager.getWaypoints().getList(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale, textRenderTypeBuffer);
            }
        }
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = WaypointsManager.customWaypoints;
        if (this.modMain.getSettings().getShowWaypoints() && !customWaypoints.isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                this.renderWaypointsList(modCustomWaypoints.values(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale, textRenderTypeBuffer);
            }
        }
    }

    private void renderWaypointsList(Collection<Waypoint> list, double playerX, double playerZ, int specW, int specH, double ps, double pc, double dimDiv, double zoom, boolean circle, float minimapScale, class_4597.class_4598 textRenderTypeBuffer) {
        for (Waypoint w : list) {
            if (w == null || w.isDisabled() || w.getType() == 1 && !this.modMain.getSettings().getDeathpoints()) continue;
            double offx = (double)w.getX(dimDiv) + 0.5 - playerX;
            double offz = (double)w.getZ(dimDiv) + 0.5 - playerZ;
            double distance = Math.sqrt(offx * offx + offz * offz);
            double waypointsDistance = this.modMain.getSettings().getMaxWaypointsDistance();
            if (w.getType() == 0 && !w.isGlobal() && waypointsDistance != 0.0 && distance > waypointsDistance) continue;
            this.translatePosition(specW, specH, ps, pc, offx, offz, zoom, circle);
            RenderSystem.scalef((float)minimapScale, (float)minimapScale, (float)1.0f);
            this.drawIconOnGUI(w, this.modMain.getSettings(), 0, 0, textRenderTypeBuffer);
            GL11.glPopMatrix();
        }
    }

    public void drawCompass(MinimapRendererHelper rendererHelper, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background, class_4597.class_4598 textRenderTypeBuffer) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        String[] nesw = new String[]{class_1074.method_4662((String)"gui.xaero_compass_north", (Object[])new Object[0]), class_1074.method_4662((String)"gui.xaero_compass_east", (Object[])new Object[0]), class_1074.method_4662((String)"gui.xaero_compass_south", (Object[])new Object[0]), class_1074.method_4662((String)"gui.xaero_compass_west", (Object[])new Object[0])};
        int color = ModSettings.COLORS[this.modMain.getSettings().compassColor];
        class_4493.method_21912();
        for (int i = 0; i < 4; ++i) {
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            this.translatePosition(specW, specH, ps, pc, offx, offy, zoom, circle);
            RenderSystem.scalef((float)minimapScale, (float)minimapScale, (float)1.0f);
            int halfW = this.mc.field_1772.method_1727(nesw[i]) / 2 - 1;
            if (background) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.SRC_ALPHA, (class_4493.class_4534)class_4493.class_4534.ONE_MINUS_SRC_ALPHA, (class_4493.class_4535)class_4493.class_4535.ZERO, (class_4493.class_4534)class_4493.class_4534.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                rendererHelper.drawMyColoredRect(-4 - addedFrame, -4 - addedFrame, 5 + addedFrame, 5 + addedFrame, 0x90000000 | color & 0xFFFFFF);
                RenderSystem.defaultBlendFunc();
            }
            Misc.drawPiercingText(nesw[i], -halfW + 1, -2.0f, color, false, textRenderTypeBuffer);
            Misc.drawPiercingText(nesw[i], -halfW, -3.0f, -1, false, textRenderTypeBuffer);
            GL11.glPopMatrix();
        }
    }

    public void translatePosition(int specW, int specH, double ps, double pc, double offx, double offy, double zoom, boolean circle) {
        double X;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
            }
        }
        GL11.glPushMatrix();
        RenderSystem.translated((double)(Math.round(borderedX) - 1L), (double)(Math.round(borderedY) - 1L), (double)0.0);
    }

    public void drawIconOnGUI(Waypoint w, ModSettings settings, int drawX, int drawY, class_4597.class_4598 textRenderTypeBuffer) {
        int c = ModSettings.COLORS[w.getColor()];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        c = a << 24 | r << 16 | g << 8 | b;
        int j = w.getType() == 1 ? 4 : class_310.method_1551().field_1772.method_1727(w.getSymbol()) / 2;
        int addedFrame = j > 4 ? j - 4 : 0;
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4 - addedFrame;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5 + addedFrame;
        class_332.fill((int)rectX1, (int)rectY1, (int)rectX2, (int)rectY2, (int)c);
        if (w.getType() == 0) {
            Misc.drawPiercingText(w.getSymbol(), drawX + 1 - j, drawY - 3, -1, true, textRenderTypeBuffer);
        } else if (w.getType() == 1) {
            class_310.method_1551().method_1531().method_22813(InterfaceRenderer.guiTextures);
            RenderSystem.color4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            class_310.method_1551().field_1705.blit(rectX1 + 1, rectY1 + 1, 0, 78, 9, 9);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            class_310.method_1551().field_1705.blit(rectX1, rectY1, 0, 78, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, class_1041 res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                Misc.drawCenteredPiercingText(class_1074.method_4662((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), res.method_4486() / 2, res.method_4502() / 2 + 50, c, true, class_4597.method_22991((class_287)class_289.method_1348().method_1349()));
                RenderSystem.enableAlphaTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }
}

