/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    public static final float DEFAULT_SCALE = 0.8f;
    public static final float MINECRAFT_SCALE = 0.02666667f;
    private AXaeroMinimap modMain;

    public WaypointsIngameRenderer(AXaeroMinimap modMain, class_310 mc) {
        this.modMain = modMain;
    }

    public void render(XaeroMinimapSession minimapSession, float partial) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            class_310 mc = class_310.method_1551();
            if (mc.field_1724.method_6059(Effects.NO_WAYPOINTS) || mc.field_1724.method_6059(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.field_1724.method_6059(Effects.NO_WAYPOINTS_HARMFUL)) {
                return;
            }
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            class_1297 entity = mc.method_1560();
            class_4184 activeRender = class_310.method_1551().field_1773.method_19418();
            double actualEntityX = entity.method_23317();
            double actualEntityY = entity.method_23318();
            double actualEntityZ = entity.method_23321();
            class_243 cameraPos = activeRender.method_19326();
            double d3 = cameraPos.method_10216();
            double d4 = cameraPos.method_10214();
            double d5 = cameraPos.method_10215();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            RenderSystem.disableCull();
            RenderSystem.pushMatrix();
            boolean lookingBack = mc.field_1690.field_1850 == 2;
            float yaw = (float)(lookingBack ? 0 : 180) + entity.method_5705(partial);
            float pitch = (float)(lookingBack ? -1 : 1) * entity.method_5695(partial);
            RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            double fov = class_310.method_1551().field_1690.field_1826;
            int screenHeight = class_310.method_1551().method_22683().method_4506();
            float cameraAngleYaw = class_3532.method_15393((float)(yaw - 180.0f));
            float cameraAnglePitch = class_3532.method_15393((float)pitch);
            class_243 lookVector = entity.method_5720();
            if (lookingBack) {
                lookVector = lookVector.method_22882();
            }
            double clampDepth = this.modMain.getSettings().getWaypointsClampDepth(fov, screenHeight);
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
            class_4597.class_4598 textRenderTypeBuffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        this.renderWaypointsList(setEntry.getValue().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, textRenderTypeBuffer);
                    }
                } else {
                    this.renderWaypointsList(waypointsManager.getWaypoints().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, textRenderTypeBuffer);
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    this.renderWaypointsList(modCustomWaypoints.values(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, textRenderTypeBuffer);
                }
            }
            class_308.method_1450();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.popMatrix();
        }
    }

    private void renderWaypointsList(Collection<Waypoint> list, double d3, double d4, double d5, class_1297 entity, class_287 bufferbuilder, class_289 tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, float yaw, float pitch, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, class_243 lookVector, double clampDepth, class_4597.class_4598 textRenderTypeBuffer) {
        for (Waypoint w : list) {
            this.renderWaypointIngame(cameraAngleYaw, cameraAnglePitch, lookVector, w, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, textRenderTypeBuffer);
        }
    }

    private void renderWaypointIngame(float cameraAngleYaw, float cameraAnglePitch, class_243 lookVector, Waypoint w, AXaeroMinimap modMain, double depthClamp, double d3, double d4, double d5, class_1297 entity, class_287 bufferBuilder, class_289 tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, float yaw, float pitch, class_4597.class_4598 textRenderTypeBuffer) {
        float offZ;
        float offY;
        if (w.isDisabled() || w.getType() == 1 && !modMain.getSettings().getDeathpoints()) {
            return;
        }
        float offX = (float)((double)w.getX(dimDiv) - d3) + 0.5f;
        double depth = (double)offX * lookVector.field_1352 + (double)(offY = (float)((double)w.getY() - d4) + 1.0f) * lookVector.field_1351 + (double)(offZ = (float)((double)w.getZ(dimDiv) - d5) + 0.5f) * lookVector.field_1350;
        if (depth < 0.0) {
            return;
        }
        double correctOffX = actualEntityX - (double)w.getX() - 0.5;
        double correctOffY = actualEntityY - (double)w.getY();
        double correctOffZ = actualEntityZ - (double)w.getZ() - 0.5;
        double correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + correctOffZ * correctOffZ);
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        float originalOffY = offY;
        double waypointsDistance = modMain.getSettings().getMaxWaypointsDistance();
        if (w.getType() == 0 && !w.isGlobal() && waypointsDistance != 0.0 && distance2D > waypointsDistance || modMain.getSettings().waypointsDistanceMin != 0.0 && distance2D < modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        class_898 renderManager = class_310.method_1551().method_1561();
        class_327 fontrenderer = renderManager.method_3949();
        if (fontrenderer == null) {
            return;
        }
        RenderSystem.pushMatrix();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (depth > depthClamp) {
            double maxDistance = (double)class_310.method_1551().field_1690.field_1870 * 16.0;
            if (depth > maxDistance) {
                zoomer2 = (float)(maxDistance / depthClamp);
                float zoomer = (float)(maxDistance / depth);
                offX *= zoomer;
                offY *= zoomer;
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(depth / depthClamp);
            }
        }
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = showDistance = Math.abs(offset = class_3532.method_15393((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float verticalAngle = (float)Math.toDegrees(Math.atan((double)(-originalOffY) / (distance2D == 0.0 ? 1.0E-5 : distance2D)));
                    showDistance = showDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        RenderSystem.translatef((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)-0.02666667f, (float)-0.02666667f, (float)1.0f);
        RenderSystem.scalef((float)zoomer2, (float)zoomer2, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.scalef((float)0.8f, (float)0.8f, (float)1.0f);
        this.drawIconInWorld(w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, distanceText, textSize, showDistance, textRenderTypeBuffer);
        RenderSystem.enableLighting();
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, class_287 vertexBuffer, class_289 tessellator, class_327 fontrenderer, String name, String distance, float textSize, boolean showDistance, class_4597.class_4598 textRenderTypeBuffer) {
        int t;
        double ingameScale = settings.waypointsIngameScale;
        double distanceScale = settings.waypointsDistanceScale;
        double nameScale = settings.waypointsNameScale;
        int ingameOpacity = settings.waypointOpacityIngame;
        RenderSystem.scaled((double)ingameScale, (double)ingameScale, (double)1.0);
        int addedFrame = 0;
        if (class_310.method_1551().method_1573()) {
            textSize *= 1.5f;
        }
        int c = ModSettings.COLORS[w.getColor()];
        float l = (float)(c >> 16 & 0xFF) / 255.0f;
        float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
        float j1 = (float)(c & 0xFF) / 255.0f;
        if (w.getType() == 0) {
            RenderSystem.scalef((float)textSize, (float)textSize, (float)textSize);
            int s = fontrenderer.method_1727(w.getSymbol()) / 2;
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)ingameOpacity / 100.0f) / 255.0f));
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, s);
            RenderSystem.enableTexture();
            Misc.drawPiercingText(w.getSymbol(), -s, -8.0f, -1, false, textRenderTypeBuffer);
        } else if (w.getType() == 1) {
            RenderSystem.color4f((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)ingameOpacity / 100.0f) / 255.0f));
            RenderSystem.disableTexture();
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, 4);
            RenderSystem.enableTexture();
            class_310.method_1551().method_1531().method_22813(InterfaceRenderer.guiTextures);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            this.renderTexturedIcon(vertexBuffer, tessellator, addedFrame, 0, 78);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!showDistance) {
                name = w.getLocalizedName();
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        boolean showingName = name.length() > 0;
        RenderSystem.translatef((float)0.0f, (float)(1 + addedFrame), (float)0.0f);
        if (w.getType() != 0) {
            RenderSystem.scalef((float)textSize, (float)textSize, (float)1.0f);
        }
        if (showingName) {
            RenderSystem.scaled((double)nameScale, (double)nameScale, (double)1.0);
            t = fontrenderer.method_1727(name) / 2;
            Misc.drawPiercingText(name, -t, 0.0f, -1, false, textRenderTypeBuffer);
            RenderSystem.translatef((float)0.0f, (float)10.0f, (float)0.0f);
            RenderSystem.scaled((double)(1.0 / nameScale), (double)(1.0 / nameScale), (double)1.0);
            RenderSystem.enableBlend();
        }
        if (distance.length() > 0) {
            RenderSystem.scaled((double)distanceScale, (double)distanceScale, (double)1.0);
            t = fontrenderer.method_1727(distance) / 2;
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.method_1328(7, class_290.field_1592);
            vertexBuffer.method_22912((double)(-t) - 1.0, 0.0, 0.0).method_1344();
            vertexBuffer.method_22912((double)(-t) - 1.0, 9.0, 0.0).method_1344();
            vertexBuffer.method_22912((double)t, 9.0, 0.0).method_1344();
            vertexBuffer.method_22912((double)t, 0.0, 0.0).method_1344();
            tessellator.method_1350();
            RenderSystem.enableTexture();
            Misc.drawPiercingText(distance, -t, 1.0f, -1, false, textRenderTypeBuffer);
        }
    }

    private int renderColorBackground(class_287 vertexBuffer, class_289 tessellator, int addedFrame, int s) {
        vertexBuffer.method_1328(7, class_290.field_1592);
        if (s > 4) {
            addedFrame = s - 4;
        }
        vertexBuffer.method_22912(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).method_1344();
        vertexBuffer.method_22912(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).method_1344();
        vertexBuffer.method_22912(4.0 + (double)addedFrame, (double)addedFrame, 0.0).method_1344();
        vertexBuffer.method_22912(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).method_1344();
        tessellator.method_1350();
        return addedFrame;
    }

    private void renderTexturedIcon(class_287 vertexBuffer, class_289 tessellator, int addedFrame, int textureX, int textureY) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        vertexBuffer.method_1328(7, class_290.field_1585);
        vertexBuffer.method_22912(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).method_22913((float)textureX * f, (float)textureY * f1).method_1344();
        vertexBuffer.method_22912(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).method_22913((float)textureX * f, (float)(textureY + 9 + addedFrame * 2) * f1).method_1344();
        vertexBuffer.method_22912(4.0 + (double)addedFrame, (double)addedFrame, 0.0).method_22913((float)(textureX + 9 + addedFrame * 2) * f, (float)(textureY + 9 + addedFrame * 2) * f1).method_1344();
        vertexBuffer.method_22912(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).method_22913((float)(textureX + 9 + addedFrame * 2) * f, (float)textureY * f1).method_1344();
        tessellator.method_1350();
    }
}

