/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.write;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2286;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2368;
import net.minecraft.class_2386;
import net.minecraft.class_2404;
import net.minecraft.class_2431;
import net.minecraft.class_2462;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4696;
import net.minecraft.class_638;
import net.minecraft.class_773;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.effect.Effects;
import xaero.common.exception.SilentException;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.write.MinimapWriterHelper;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.mixin.MixinBakedQuad;
import xaero.common.settings.ModSettings;

public class MinimapWriter {
    private static final float DEFAULT_AMBIENT_LIGHT = 0.7f;
    private static final float DEFAULT_AMBIENT_LIGHT_COLORED = 0.2f;
    private static final float DEFAULT_AMBIENT_LIGHT_WHITE = 0.5f;
    private static final float DEFAULT_MAX_DIRECT_LIGHT = 0.6666667f;
    private static final float GLOWING_MAX_DIRECT_LIGHT = 0.22222224f;
    private static final String[] dimensionsToIgnore = new String[]{"FZHammer"};
    private static final int UPDATE_EVERY_RUNS = 5;
    private static final int MAXIMUM_OVERLAYS = 5;
    private static final int SUN_MINIMUM = 9;
    private AXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private MinimapWriterHelper helper;
    private MinimapInterface minimapInterface;
    private Random usedRandom = new Random(0L);
    private int loadingSideInChunks;
    private int updateRadius;
    private MinimapChunk[][] loadingBlocks;
    private int loadingMapChunkX;
    private int loadingMapChunkZ;
    private int loadingStartX;
    private int loadingStartZ;
    private int loadingEndX;
    private int loadingEndZ;
    private int loadingCaving;
    private int loadingLevels;
    private int loadingTerrainSlopes;
    private boolean loadingTerrainDepth;
    private boolean loadingRedstone;
    private int loadingColours;
    private boolean loadingTransparency;
    private boolean loadingBiomesVanillaMode;
    private int loadingDimension;
    private boolean loadingIgnoreHeightmaps;
    private int loadingCaveMapsDepth;
    public int loadingLightOverlayType;
    public int loadingLightOverlayMaxLight;
    public int loadingLightOverlayMinLight;
    public int loadingLightOverlayColor;
    private boolean loadingFlowers;
    private MinimapChunk[][] loadedBlocks;
    private int loadedMapChunkX;
    private int loadedMapChunkZ;
    private int loadedCaving;
    private int prevLoadedCaving;
    private int loadedLevels;
    private int loadedTerrainSlopes;
    private boolean loadedTerrainDepth;
    private boolean loadedRedstone;
    private int loadedColours;
    private boolean loadedTransparency;
    private boolean loadedBiomesVanillaMode;
    private int loadedDimension;
    private boolean loadedIgnoreHeightmaps;
    private int loadedCaveMapsDepth;
    public int loadedLightOverlayType;
    public int loadedLightOverlayMaxLight;
    public int loadedLightOverlayMinLight;
    public int loadedLightOverlayColor;
    private boolean loadedFlowers;
    private long loadedTime;
    private boolean settingsChanged;
    private ArrayList<Long> detectedChunkChanges;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private int updateChunkX;
    private int updateChunkZ;
    private int tileInsideX;
    private int tileInsideZ;
    private int runNumber;
    private boolean previousShouldLoad;
    private int lastCaving;
    private boolean clearBlockColours;
    private final HashMap<String, Integer> textureColours;
    private final HashMap<Integer, Integer> blockColours;
    private final HashMap<class_2680, Boolean> transparentCache;
    private final HashMap<class_2680, Boolean> glowingCache;
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private boolean forcedRefresh;
    private MinimapChunk oldChunk;
    private int updates;
    private int loads;
    private long before;
    private int processingTime;
    public boolean debugTotalTime = false;
    public long minTime = -1L;
    public long maxTime = -1L;
    public long totalTime;
    public long totalRuns;
    public long lastDebugTime = -1L;
    public long minTimeDebug;
    public long maxTimeDebug;
    public long averageTimeDebug;
    private long currentComparisonCode;
    private final List<Integer> pixelTransparentSizes;
    private final List<class_2680> pixelBlockStates;
    private final List<Integer> pixelBlockLights;
    private int firstBlockY;
    boolean isglowing;
    private final int[] underRed;
    private final int[] underGreen;
    private final int[] underBlue;
    private int sun;
    private float currentTransparencyMultiplier;
    private int blockY;
    private int blockColor;
    private final int[] red;
    private final int[] green;
    private final int[] blue;
    private final float[] brightness;
    private final float[] postBrightness;
    private final int[] tempColor;
    private boolean underair;
    private class_2680 previousTransparentState;
    private final class_2338.class_2339 mutableBlockPos;
    private final class_2338.class_2339 mutableBlockPos2;
    private final int[][] intUpdateArrayBuffers;
    private Long seedForLoading;
    private ArrayList<class_2680> buggedStates;
    private final class_310 mc;

    public MinimapWriter(AXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.loadingSideInChunks = 9;
        this.updateRadius = 16;
        this.loadingCaving = -1;
        this.loadedCaving = -1;
        this.prevLoadedCaving = -1;
        this.lastCaving = -1;
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.loadedCaving = -1;
        this.red = new int[5];
        this.green = new int[5];
        this.blue = new int[5];
        this.underRed = new int[5];
        this.underGreen = new int[5];
        this.underBlue = new int[5];
        this.brightness = new float[5];
        this.postBrightness = new float[5];
        this.tempColor = new int[3];
        this.helper = new MinimapWriterHelper();
        this.mutableBlockPos = new class_2338.class_2339();
        this.mutableBlockPos2 = new class_2338.class_2339();
        this.intUpdateArrayBuffers = new int[5][4096];
        this.pixelBlockStates = new ArrayList<class_2680>();
        this.pixelTransparentSizes = new ArrayList<Integer>();
        this.pixelBlockLights = new ArrayList<Integer>();
        this.transparentCache = new HashMap();
        this.glowingCache = new HashMap();
        this.minimapInterface = modMain.getInterfaces().getMinimapInterface();
        this.buggedStates = new ArrayList();
        this.detectedChunkChanges = new ArrayList();
        this.mc = class_310.method_1551();
    }

    private void updateTimeDebug(long before) {
        if (this.debugTotalTime) {
            long debugPassed = System.nanoTime() - before;
            this.totalTime += debugPassed;
            ++this.totalRuns;
            if (debugPassed > this.maxTime) {
                this.maxTime = debugPassed;
            }
            if (this.minTime == -1L || debugPassed < this.minTime) {
                this.minTime = debugPassed;
            }
            long time = System.currentTimeMillis();
            if (this.lastDebugTime == -1L) {
                this.lastDebugTime = time;
            } else if (time - this.lastDebugTime > 1000L) {
                this.maxTimeDebug = this.maxTime;
                this.minTimeDebug = this.minTime;
                this.averageTimeDebug = this.totalTime / this.totalRuns;
                this.maxTime = -1L;
                this.minTime = -1L;
                this.totalTime = 0L;
                this.totalRuns = 0L;
                this.lastDebugTime = time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender() {
        long before = System.nanoTime();
        MinimapProcessor minimapProcessor = this.minimapSession.getMinimapProcessor();
        try {
            long passed;
            boolean shouldLoad;
            class_1937 world = null;
            double playerX = 0.0;
            double playerY = 0.0;
            double playerZ = 0.0;
            Object object = minimapProcessor.mainStuffSync;
            synchronized (object) {
                world = minimapProcessor.mainWorld;
                playerX = minimapProcessor.mainPlayerX;
                playerY = minimapProcessor.mainPlayerY;
                playerZ = minimapProcessor.mainPlayerZ;
            }
            if (this.modMain.getSettings() == null || !this.modMain.getSettings().getMinimap() || world == null) {
                this.updateTimeDebug(before);
                return;
            }
            int currentCaving = this.getCaving(playerX, playerY, playerZ, world);
            boolean attemptUsingWorldMapChunks = this.modMain.getSupportMods().shouldUseWorldMapChunks() && currentCaving == -1 && this.modMain.getSettings().lightOverlayType <= 0;
            boolean bl = shouldLoad = !this.ignoreWorld(world) && (!attemptUsingWorldMapChunks || this.loadingCaving != -1 || this.loadedCaving != -1 || this.loadingLightOverlayType > 0 || this.loadedLightOverlayType > 0);
            if (shouldLoad != this.previousShouldLoad) {
                this.updateChunkZ = 0;
                this.updateChunkX = 0;
                this.tileInsideZ = 0;
                this.tileInsideX = 0;
                this.previousShouldLoad = shouldLoad;
            }
            if (!shouldLoad) {
                this.updateTimeDebug(before);
                return;
            }
            XaeroMinimapCore.ensureField();
            int lengthX = Math.min(this.loadingSideInChunks, this.loadingEndX - this.loadingStartX + 1);
            int lengthZ = Math.min(this.loadingSideInChunks, this.loadingEndZ - this.loadingStartZ + 1);
            if (this.lastWriteTry == -1L) {
                lengthX = 3;
                lengthZ = 3;
            } else {
                if (lengthX > this.loadingSideInChunks) {
                    lengthX = this.loadingSideInChunks;
                }
                if (lengthZ > this.loadingSideInChunks) {
                    lengthZ = this.loadingSideInChunks;
                }
            }
            int sizeTileChunks = lengthX * lengthZ;
            int sizeTiles = sizeTileChunks * 4 * 4;
            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
            long time = System.currentTimeMillis();
            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                this.framesFreedTime = time;
                this.writeFreeSizeTiles = sizeTiles;
                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                this.workingFrameCount = 0;
            }
            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
            if (this.framesFreedTime != -1L) {
                sinceLastWrite = time - this.framesFreedTime;
            }
            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                this.lastWrite = time;
            }
            int flickeringTimer = 1000;
            if (tilesToUpdate != 0L) {
                if (this.framesFreedTime == -1L) {
                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                    long writeStartNano = System.nanoTime();
                    if (currentCaving == -1 != (this.loadingCaving == -1)) {
                        this.updateChunkZ = 0;
                        this.updateChunkX = 0;
                        this.tileInsideZ = 0;
                        this.tileInsideX = 0;
                        this.loadedTime = time;
                    }
                    int i = 0;
                    while ((long)i < tilesToUpdate && !this.beforeWriting(attemptUsingWorldMapChunks, flickeringTimer, time)) {
                        if (this.writeChunk(minimapProcessor, playerX, playerY, playerZ, world, currentCaving, attemptUsingWorldMapChunks)) {
                            --i;
                        }
                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                        ++i;
                    }
                    ++this.workingFrameCount;
                } else {
                    this.writeFreeSinceLastWrite = sinceLastWrite;
                    this.framesFreedTime = -1L;
                }
            }
            this.lastWriteTry = time;
        }
        catch (Throwable e) {
            this.minimapInterface.setCrashedWith(e);
        }
        this.updateTimeDebug(before);
    }

    private boolean beforeWriting(boolean attemptUsingWorldMapChunks, int flickeringTimer, long time) {
        if (this.tileInsideX == 0 && this.tileInsideZ == 0 && this.updateChunkX == 0 && this.updateChunkZ == 0 && attemptUsingWorldMapChunks) {
            this.loadingCaving = -1;
            this.loadingLightOverlayType = 0;
            if (this.loadedTime == 0L || time - this.loadedTime >= (long)flickeringTimer) {
                this.loadedCaving = -1;
                this.loadedLightOverlayType = 0;
                this.loadedTime = time;
            }
            if (this.loadedCaving == -1 && this.loadedLightOverlayType <= 0) {
                this.detectedChunkChanges.clear();
            }
            return true;
        }
        return this.tileInsideX == 3 && this.tileInsideZ == 3 && this.updateChunkX == this.loadingSideInChunks - 1 && this.updateChunkZ == this.loadingSideInChunks - 1 && this.loadingCaving == -1 != (this.loadedCaving == -1) && this.loadedTime != 0L && time - this.loadedTime < (long)flickeringTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeChunk(MinimapProcessor minimapProcessor, double playerX, double playerY, double playerZ, class_1937 world, int currentCaving, boolean attemptUsingWorldMapChunks) {
        MinimapChunk mchunk;
        long processStart = System.nanoTime();
        if (this.tileInsideX == 0 && this.tileInsideZ == 0) {
            if (this.updateChunkX == 0 && this.updateChunkZ == 0) {
                this.settingsChanged = false;
                if (this.clearBlockColours) {
                    this.settingsChanged = true;
                    this.clearBlockColours = false;
                    if (!this.blockColours.isEmpty()) {
                        this.blockColours.clear();
                        this.textureColours.clear();
                        System.out.println("Minimap block colour cache cleaned.");
                    }
                }
                this.loadingSideInChunks = this.getLoadSide();
                this.updateRadius = this.getUpdateRadiusInChunks();
                int playerXInt = OptimizedMath.myFloor(playerX);
                int playerZInt = OptimizedMath.myFloor(playerZ);
                this.loadingMapChunkX = this.getMapCoord(this.loadingSideInChunks, playerXInt);
                this.loadingMapChunkZ = this.getMapCoord(this.loadingSideInChunks, playerZInt);
                int loadDistance = class_310.method_1551().field_1690.field_1870;
                int playerTileX = playerXInt >> 4;
                int playerTileZ = playerZInt >> 4;
                int globalStartX = playerTileX - loadDistance >> 2;
                int globalStartZ = playerTileZ - loadDistance >> 2;
                int globalEndX = playerTileX + loadDistance >> 2;
                int globalEndZ = playerTileZ + loadDistance >> 2;
                this.loadingStartX = globalStartX - this.loadingMapChunkX;
                this.loadingStartZ = globalStartZ - this.loadingMapChunkZ;
                this.loadingEndX = globalEndX - this.loadingMapChunkX;
                this.loadingEndZ = globalEndZ - this.loadingMapChunkZ;
                this.loadingCaving = currentCaving;
                if (this.loadingCaving != -1 || this.loadedCaving != -1) {
                    int maxDistance = 2;
                    if (this.loadingCaving != -1 && this.loadedCaving == -1) {
                        maxDistance = 1;
                    }
                    this.loadingStartX = Math.max(this.loadingStartX, this.loadingSideInChunks / 2 - maxDistance);
                    this.loadingStartZ = Math.max(this.loadingStartZ, this.loadingSideInChunks / 2 - maxDistance);
                    this.loadingEndX = Math.min(this.loadingEndX, this.loadingSideInChunks / 2 + maxDistance);
                    this.loadingEndZ = Math.min(this.loadingEndZ, this.loadingSideInChunks / 2 + maxDistance);
                }
                if (this.loadingCaving != this.loadedCaving || this.loadingCaving != -1 && this.prevLoadedCaving == -1) {
                    this.runNumber = 0;
                }
                this.loadingLevels = this.modMain.getSettings().getLighting() ? 5 : 1;
                this.loadingTerrainSlopes = this.modMain.getSettings().getTerrainSlopes();
                this.loadingTerrainDepth = this.modMain.getSettings().getTerrainDepth();
                this.loadingRedstone = this.modMain.getSettings().getDisplayRedstone();
                this.loadingColours = this.modMain.getSettings().getBlockColours();
                this.loadingTransparency = this.modMain.getSettings().blockTransparency;
                this.loadingBiomesVanillaMode = this.modMain.getSettings().getBiomeColorsVanillaMode();
                this.loadingDimension = world.method_8597().method_12460().method_12484();
                this.loadingCaveMapsDepth = this.modMain.getSettings().caveMapsDepth;
                this.loadingIgnoreHeightmaps = this.modMain.getSettings().isIgnoreHeightmaps();
                this.loadingLightOverlayColor = this.modMain.getSettings().lightOverlayColor;
                this.loadingLightOverlayMaxLight = this.modMain.getSettings().lightOverlayMaxLight;
                this.loadingLightOverlayMinLight = this.modMain.getSettings().lightOverlayMinLight;
                this.loadingLightOverlayType = this.modMain.getSettings().lightOverlayType;
                this.loadingFlowers = this.modMain.getSettings().getShowFlowers();
                this.settingsChanged = this.settingsChanged || this.loadedDimension != this.loadingDimension;
                this.settingsChanged = this.settingsChanged || this.loadedTerrainSlopes != this.loadingTerrainSlopes;
                this.settingsChanged = this.settingsChanged || this.loadedTerrainDepth != this.loadingTerrainDepth;
                this.settingsChanged = this.settingsChanged || this.loadedRedstone != this.loadingRedstone;
                this.settingsChanged = this.settingsChanged || this.loadedColours != this.loadingColours;
                this.settingsChanged = this.settingsChanged || this.loadedTransparency != this.loadingTransparency;
                this.settingsChanged = this.settingsChanged || this.loadingBiomesVanillaMode != this.loadedBiomesVanillaMode;
                this.settingsChanged = this.settingsChanged || this.loadingCaveMapsDepth != this.loadedCaveMapsDepth;
                this.settingsChanged = this.settingsChanged || this.loadingIgnoreHeightmaps != this.loadedIgnoreHeightmaps;
                this.settingsChanged = this.settingsChanged || this.loadingLightOverlayColor != this.loadedLightOverlayColor;
                this.settingsChanged = this.settingsChanged || this.loadingLightOverlayMaxLight != this.loadedLightOverlayMaxLight;
                this.settingsChanged = this.settingsChanged || this.loadingLightOverlayMinLight != this.loadedLightOverlayMinLight;
                this.settingsChanged = this.settingsChanged || this.loadingLightOverlayType != this.loadedLightOverlayType;
                this.settingsChanged = this.settingsChanged || this.loadingFlowers != this.loadedFlowers;
                boolean bl = this.settingsChanged = this.settingsChanged || this.loadingCaving != -1 && this.loadedCaving == -1;
                if (this.loadingBlocks == null || this.loadingBlocks.length != this.loadingSideInChunks) {
                    this.loadingBlocks = new MinimapChunk[this.loadingSideInChunks][this.loadingSideInChunks];
                }
                if (this.minimapInterface.usingFBO() && minimapProcessor.isToResetImage()) {
                    this.forcedRefresh = true;
                    minimapProcessor.setToResetImage(false);
                }
            }
            this.oldChunk = null;
            if (this.loadedBlocks != null) {
                int updateChunkXOld = this.loadingMapChunkX + this.updateChunkX - this.loadedMapChunkX;
                int updateChunkZOld = this.loadingMapChunkZ + this.updateChunkZ - this.loadedMapChunkZ;
                if (updateChunkXOld > -1 && updateChunkXOld < this.loadedBlocks.length && updateChunkZOld > -1 && updateChunkZOld < this.loadedBlocks.length) {
                    this.oldChunk = this.loadedBlocks[updateChunkXOld][updateChunkZOld];
                }
            }
        }
        if ((mchunk = this.loadingBlocks[this.updateChunkX][this.updateChunkZ]) == null) {
            MinimapChunk minimapChunk = new MinimapChunk(this.loadingMapChunkX + this.updateChunkX, this.loadingMapChunkZ + this.updateChunkZ);
            this.loadingBlocks[this.updateChunkX][this.updateChunkZ] = minimapChunk;
            mchunk = minimapChunk;
        } else if (this.tileInsideX == 0 && this.tileInsideZ == 0) {
            mchunk.reset(this.loadingMapChunkX + this.updateChunkX, this.loadingMapChunkZ + this.updateChunkZ);
        }
        boolean onlyLoad = this.runNumber % 5 != 0 && this.loadingLightOverlayType <= 0;
        boolean outsideRender = this.updateChunkX < this.loadingStartX || this.updateChunkX > this.loadingEndX || this.updateChunkZ < this.loadingStartZ || this.updateChunkZ > this.loadingEndZ;
        MinimapChunk topChunk = this.updateChunkZ > 0 ? this.loadingBlocks[this.updateChunkX][this.updateChunkZ - 1] : null;
        MinimapChunk topLeftChunk = this.updateChunkX > 0 && this.updateChunkZ > 0 ? this.loadingBlocks[this.updateChunkX - 1][this.updateChunkZ - 1] : null;
        MinimapChunk leftChunk = this.updateChunkX > 0 ? this.loadingBlocks[this.updateChunkX - 1][this.updateChunkZ] : null;
        this.writeTile(minimapProcessor, playerX, playerY, playerZ, world, mchunk, this.oldChunk, topChunk, topLeftChunk, leftChunk, this.updateChunkX, this.updateChunkZ, this.tileInsideX, this.tileInsideZ, onlyLoad, outsideRender);
        if (this.loadingLightOverlayType > 0 && this.loadedLightOverlayType > 0) {
            onlyLoad = true;
        }
        ++this.tileInsideZ;
        if (this.tileInsideZ >= 4) {
            this.tileInsideZ = 0;
            ++this.tileInsideX;
            if (this.tileInsideX >= 4) {
                this.tileInsideX = 0;
                mchunk = this.loadingBlocks[this.updateChunkX][this.updateChunkZ];
                if (this.minimapInterface.usingFBO() && mchunk.isHasSomething() && mchunk.isChanged()) {
                    mchunk.updateBuffers(this.loadingLevels, this.intUpdateArrayBuffers);
                    mchunk.setChanged(false);
                }
                mchunk.setLevelsBuffered(this.loadingLevels);
                if (this.updateChunkX == this.loadingSideInChunks - 1 && this.updateChunkZ == this.loadingSideInChunks - 1) {
                    if (this.runNumber % 5 == 0 && !MinimapTile.recycled.isEmpty()) {
                        MinimapTile.recycled.subList(0, MinimapTile.recycled.size() / 2).clear();
                    }
                    if (this.loadedBlocks != null) {
                        for (int i = 0; i < this.loadedBlocks.length; ++i) {
                            for (int j = 0; j < this.loadedBlocks.length; ++j) {
                                boolean shouldTransfer;
                                MinimapChunk m = this.loadedBlocks[i][j];
                                MinimapChunk lm = null;
                                if (m == null) continue;
                                m.recycleTiles();
                                int loadingX = this.loadedMapChunkX + i - this.loadingMapChunkX;
                                int loadingZ = this.loadedMapChunkZ + j - this.loadingMapChunkZ;
                                if (loadingX > -1 && loadingZ > -1 && loadingX < this.loadingSideInChunks && loadingZ < this.loadingSideInChunks) {
                                    lm = this.loadingBlocks[loadingX][loadingZ];
                                }
                                boolean bl = shouldTransfer = m.getLevelsBuffered() == this.loadingLevels && lm != null;
                                if (shouldTransfer) {
                                    MinimapChunk minimapChunk = m;
                                    synchronized (minimapChunk) {
                                        m.setBlockTextureUpload(true);
                                    }
                                }
                                for (int l = 0; l < m.getLevelsBuffered(); ++l) {
                                    if (m.getGlTexture(l) != 0) {
                                        if (shouldTransfer) {
                                            lm.setGlTexture(l, m.getGlTexture(l));
                                        } else {
                                            GL11.glDeleteTextures((int)m.getGlTexture(l));
                                        }
                                    }
                                    if (!shouldTransfer || lm.isRefreshRequired(l) || !m.isRefreshRequired(l)) continue;
                                    lm.copyBuffer(l, m.getBuffer(l));
                                    lm.setRefreshRequired(l, true);
                                    m.setRefreshRequired(l, false);
                                }
                            }
                        }
                    }
                    MinimapWriter i = this;
                    synchronized (i) {
                        MinimapChunk[][] bu = this.loadedBlocks;
                        this.loadedBlocks = this.loadingBlocks;
                        this.loadingBlocks = bu;
                        this.loadedMapChunkX = this.loadingMapChunkX;
                        this.loadedMapChunkZ = this.loadingMapChunkZ;
                        this.loadedLevels = this.loadingLevels;
                        this.loadedTerrainSlopes = this.loadingTerrainSlopes;
                        this.loadedTerrainDepth = this.loadingTerrainDepth;
                        this.loadedRedstone = this.loadingRedstone;
                        this.loadedColours = this.loadingColours;
                        this.loadedTransparency = this.loadingTransparency;
                        this.loadedBiomesVanillaMode = this.loadingBiomesVanillaMode;
                        this.loadedDimension = this.loadingDimension;
                        this.loadedCaveMapsDepth = this.loadingCaveMapsDepth;
                        this.loadedIgnoreHeightmaps = this.loadingIgnoreHeightmaps;
                        this.loadedLightOverlayColor = this.loadingLightOverlayColor;
                        this.loadedLightOverlayMaxLight = this.loadingLightOverlayMaxLight;
                        this.loadedLightOverlayMinLight = this.loadingLightOverlayMinLight;
                        this.loadedLightOverlayType = this.loadingLightOverlayType;
                        this.loadedFlowers = this.loadingFlowers;
                        this.loadedTime = System.currentTimeMillis();
                    }
                    this.detectedChunkChanges.clear();
                    this.prevLoadedCaving = this.loadedCaving;
                    this.loadedCaving = this.loadingCaving;
                    this.forcedRefresh = false;
                    ++this.runNumber;
                }
                ++this.updateChunkZ;
                if (this.updateChunkZ >= this.loadingSideInChunks) {
                    this.updateChunkZ = 0;
                    this.updateChunkX = (this.updateChunkX + 1) % this.loadingSideInChunks;
                }
            }
        }
        int passed = (int)(System.nanoTime() - processStart);
        return outsideRender;
    }

    private void writeTile(MinimapProcessor minimapProcessor, double playerX, double playerY, double playerZ, class_1937 world, MinimapChunk mchunk, MinimapChunk oldChunk, MinimapChunk topChunk, MinimapChunk topLeftChunk, MinimapChunk leftChunk, int canvasX, int canvasZ, int insideX, int insideZ, boolean onlyLoad, boolean outsideRender) {
        int tileX = mchunk.getX() * 4 + insideX;
        int tileZ = mchunk.getZ() * 4 + insideZ;
        int halfSide = this.loadingSideInChunks / 2;
        int tileFromCenterX = canvasX - halfSide;
        int tileFromCenterZ = canvasZ - halfSide;
        MinimapTile oldTile = null;
        if (oldChunk != null) {
            oldTile = oldChunk.getTile(insideX, insideZ);
        }
        class_2818 bchunk = (class_2818)world.method_8402(tileX, tileZ, class_2806.field_12803, false);
        boolean neighborsLoaded = true;
        block4: for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                class_2818 nChunk;
                if (i == 0 && j == 0 || (nChunk = world.method_8497(tileX + i, tileZ + j)) != null && !(nChunk instanceof class_2812)) continue;
                neighborsLoaded = false;
                continue block4;
            }
        }
        boolean chunkUpdated = false;
        boolean chunkIsClean = true;
        try {
            chunkIsClean = bchunk == null || (Boolean)XaeroMinimapCore.chunkCleanField.get(bchunk) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        boolean bl = chunkUpdated = !chunkIsClean;
        if (chunkIsClean && bchunk != null && this.detectedChunkChanges.contains(Misc.getChunkPosAsLong(bchunk))) {
            chunkUpdated = true;
        }
        boolean bl2 = chunkUpdated = chunkUpdated || oldTile == null || oldTile.caveLevel != this.loadingCaving;
        if (outsideRender || bchunk == null || bchunk instanceof class_2812 || !neighborsLoaded || (!chunkUpdated || onlyLoad || tileFromCenterX > this.updateRadius || tileFromCenterZ > this.updateRadius || tileFromCenterX < -this.updateRadius || tileFromCenterZ < -this.updateRadius) && oldTile != null && oldTile.isSuccess() && oldChunk.getLevelsBuffered() == this.loadingLevels && !this.settingsChanged) {
            if (oldTile != null && oldChunk.getLevelsBuffered() == this.loadingLevels && !this.settingsChanged) {
                mchunk.setTile(insideX, insideZ, oldTile);
                oldTile.setWasTransfered(true);
                mchunk.setHasSomething(oldChunk.isHasSomething());
                if (this.forcedRefresh) {
                    mchunk.setChanged(true);
                }
            }
            return;
        }
        if (oldTile != null && oldChunk.getLevelsBuffered() != this.loadingLevels) {
            oldTile = null;
        }
        MinimapTile tile = null;
        int sectionBasedHeight = this.loadingIgnoreHeightmaps ? this.getSectionBasedHeight(bchunk, 64) : 0;
        class_2902.class_2903 typeWorldSurface = class_2902.class_2903.field_13202;
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getWorldData((class_638)world);
        float shadowR = worldData.shadowR;
        float shadowG = worldData.shadowG;
        float shadowB = worldData.shadowB;
        int playerYi = (int)playerY;
        boolean sameCaveLevel = oldTile != null && this.loadingCaving == oldTile.caveLevel;
        boolean settingsChanged = this.settingsChanged;
        int loadingCaving = this.loadingCaving;
        int loadingLevels = this.loadingLevels;
        int loadingTerrainSlopes = this.loadingTerrainSlopes;
        boolean loadingTerrainDepth = this.loadingTerrainDepth;
        List<Integer> pixelTransparentSizes = this.pixelTransparentSizes;
        List<class_2680> pixelBlockStates = this.pixelBlockStates;
        List<Integer> pixelBlockLights = this.pixelBlockLights;
        int[] underRed = this.underRed;
        int[] underGreen = this.underGreen;
        int[] underBlue = this.underBlue;
        float[] postBrightness = this.postBrightness;
        float[] brightness = this.brightness;
        int[] red = this.red;
        int[] green = this.green;
        int[] blue = this.blue;
        int[] tempColor = this.tempColor;
        boolean loadingIgnoreHeightmaps = this.loadingIgnoreHeightmaps;
        int loadingCaveMapsDepth = this.loadingCaveMapsDepth;
        class_2338.class_2339 mutableBlockPos = this.mutableBlockPos;
        class_2338.class_2339 mutableBlockPos2 = this.mutableBlockPos2;
        Long seedForLoading = this.seedForLoading;
        int loadedLevels = this.loadedLevels;
        AXaeroMinimap modMain = this.modMain;
        MinimapWriterHelper helper = this.helper;
        int loadingColours = this.loadingColours;
        boolean loadingRedstone = this.loadingRedstone;
        boolean loadingTransparency = this.loadingTransparency;
        int loadingLightOverlayType = this.loadingLightOverlayType;
        int loadingLightOverlayMaxLight = this.loadingLightOverlayMaxLight;
        int loadingLightOverlayMinLight = this.loadingLightOverlayMinLight;
        int loadingLightOverlayColor = this.loadingLightOverlayColor;
        boolean loadingFlowers = this.loadingFlowers;
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                tile = this.loadBlockColor(playerYi, world, blockX, blockZ, bchunk, tileX, tileZ, insideX, insideZ, sectionBasedHeight, typeWorldSurface, oldTile, mchunk, topChunk, topLeftChunk, leftChunk, shadowR, shadowG, shadowB, sameCaveLevel, canvasX, canvasZ, settingsChanged, loadingCaving, loadingLevels, loadingTerrainSlopes, loadingTerrainDepth, pixelTransparentSizes, pixelBlockStates, pixelBlockLights, underRed, underGreen, underBlue, postBrightness, brightness, red, green, blue, tempColor, loadingIgnoreHeightmaps, loadingCaveMapsDepth, mutableBlockPos, mutableBlockPos2, seedForLoading, loadedLevels, modMain, helper, loadingColours, loadingRedstone, loadingTransparency, loadingLightOverlayType, loadingLightOverlayMaxLight, loadingLightOverlayMinLight, loadingLightOverlayColor, loadingFlowers);
            }
        }
        tile.caveLevel = loadingCaving;
        if (!chunkIsClean) {
            long chunkPosLong = Misc.getChunkPosAsLong(bchunk);
            if (!this.detectedChunkChanges.contains(chunkPosLong)) {
                this.detectedChunkChanges.add(chunkPosLong);
            }
            try {
                XaeroMinimapCore.chunkCleanField.set(bchunk, true);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public MinimapTile loadBlockColor(int playerYi, class_1937 world, int insideX, int insideZ, class_2818 bchunk, int tileX, int tileZ, int tileInsideX, int tileInsideZ, int sectionBasedHeight, class_2902.class_2903 typeWorldSurface, MinimapTile oldTile, MinimapChunk mchunk, MinimapChunk topChunk, MinimapChunk topLeftChunk, MinimapChunk leftChunk, float shadowR, float shadowG, float shadowB, boolean sameCaveLevel, int canvasX, int canvasZ, boolean settingsChanged, int loadingCaving, int loadingLevels, int loadingTerrainSlopes, boolean loadingTerrainDepth, List<Integer> pixelTransparentSizes, List<class_2680> pixelBlockStates, List<Integer> pixelBlockLights, int[] underRed, int[] underGreen, int[] underBlue, float[] postBrightness, float[] brightness, int[] red, int[] green, int[] blue, int[] tempColor, boolean loadingIgnoreHeightmaps, int loadingCaveMapsDepth, class_2338.class_2339 mutableBlockPos, class_2338.class_2339 mutableBlockPos2, Long seedForLoading, int loadedLevels, AXaeroMinimap modMain, MinimapWriterHelper helper, int loadingColours, boolean loadingRedstone, boolean loadingTransparency, int loadingLightOverlayType, int loadingLightOverlayMaxLight, int loadingLightOverlayMinLight, int loadingLightOverlayColor, boolean loadingFlowers) {
        int i;
        boolean reuseColour;
        class_2818 prevChunk2;
        MinimapTile tile;
        int lowY;
        int highY;
        if (loadingCaving != -1) {
            highY = loadingCaving;
        } else {
            int height = bchunk.method_12005(typeWorldSurface, insideX, insideZ);
            highY = loadingIgnoreHeightmaps || height == -1 ? sectionBasedHeight : height + 3;
        }
        int n = lowY = loadingCaving != -1 ? playerYi - loadingCaveMapsDepth : 0;
        if (lowY < 0) {
            lowY = 0;
        }
        pixelTransparentSizes.clear();
        pixelBlockStates.clear();
        pixelBlockLights.clear();
        this.currentComparisonCode = 0L;
        byte currentComparisonCodeAdd = 0;
        byte currentComparisonCodeAdd2 = 0;
        this.blockY = 0;
        for (int i2 = 0; i2 < loadingLevels; ++i2) {
            underRed[i2] = 0;
            underGreen[i2] = 0;
            underBlue[i2] = 0;
        }
        this.currentTransparencyMultiplier = 1.0f;
        this.sun = 15;
        this.blockColor = 0;
        this.isglowing = false;
        double secondaryBR = 1.0;
        double secondaryBG = 1.0;
        double secondaryBB = 1.0;
        class_2248 block = this.findBlock(world, bchunk, insideX, insideZ, highY, lowY, loadingCaving, loadingRedstone, mutableBlockPos, mutableBlockPos2, loadingColours, loadingTransparency, pixelBlockLights, pixelBlockStates, loadingLevels, pixelTransparentSizes, loadingFlowers);
        boolean isglowing = this.isglowing;
        int blockY = this.blockY;
        long currentComparisonCode = this.currentComparisonCode;
        boolean success = true;
        int prevHeight = -1;
        int prevHeightDiagonal = -1;
        int prevInsideX = insideX - 1;
        int prevInsideZ = insideZ - 1;
        boolean xEdge = prevInsideX < 0;
        boolean zEdge = prevInsideZ < 0;
        MinimapTile prevHeightSrc = tile = mchunk.getTile(tileInsideX, tileInsideZ);
        MinimapTile prevHeightDiagonalSrc = tile;
        if (zEdge) {
            prevInsideZ = 15;
            if (tileInsideZ > 0) {
                prevHeightSrc = mchunk.getTile(tileInsideX, tileInsideZ - 1);
            } else if (topChunk != null) {
                prevHeightSrc = topChunk.getTile(tileInsideX, 3);
            }
        }
        if (xEdge) {
            prevInsideX = 15;
            if (zEdge) {
                if (tileInsideZ > 0 && tileInsideX > 0) {
                    prevHeightDiagonalSrc = mchunk.getTile(tileInsideX - 1, tileInsideZ - 1);
                } else if (tileInsideX == 0 && tileInsideZ == 0) {
                    if (topLeftChunk != null) {
                        prevHeightDiagonalSrc = topLeftChunk.getTile(3, 3);
                    }
                } else if (tileInsideX == 0) {
                    if (leftChunk != null) {
                        prevHeightDiagonalSrc = leftChunk.getTile(3, tileInsideZ - 1);
                    }
                } else if (topChunk != null) {
                    prevHeightDiagonalSrc = topChunk.getTile(tileInsideX - 1, 3);
                }
            } else if (tileInsideX > 0) {
                prevHeightDiagonalSrc = mchunk.getTile(tileInsideX - 1, tileInsideZ);
            } else if (leftChunk != null) {
                prevHeightDiagonalSrc = leftChunk.getTile(3, tileInsideZ);
            }
        } else {
            prevHeightDiagonalSrc = prevHeightSrc;
        }
        if (prevHeightSrc != null) {
            prevHeight = prevHeightSrc.getHeight(insideX, prevInsideZ);
        } else if (zEdge) {
            prevHeight = blockY;
            if (pixelTransparentSizes.isEmpty()) {
                try {
                    prevChunk2 = world.method_8497(tileX, tileZ - 1);
                    if (prevChunk2 != null) {
                        prevHeight = prevChunk2.method_12005(typeWorldSurface, insideX, prevInsideZ);
                    }
                }
                catch (IllegalStateException prevChunk2) {
                    // empty catch block
                }
            }
            success = false;
        }
        if (prevHeightDiagonalSrc != null) {
            prevHeightDiagonal = prevHeightDiagonalSrc.getHeight(prevInsideX, prevInsideZ);
        } else if (xEdge || zEdge) {
            prevHeightDiagonal = blockY;
            if (pixelTransparentSizes.isEmpty()) {
                try {
                    class_2818 class_28182 = xEdge && zEdge ? world.method_8497(tileX - 1, tileZ - 1) : (prevChunk2 = zEdge ? world.method_8497(tileX, tileZ - 1) : world.method_8497(tileX - 1, tileZ));
                    if (prevChunk2 != null) {
                        prevHeightDiagonal = prevChunk2.method_12005(typeWorldSurface, prevInsideX, prevInsideZ);
                    }
                }
                catch (IllegalStateException prevChunk3) {
                    // empty catch block
                }
            }
            success = false;
        }
        int verticalSlope = 0;
        int diagonalSlope = 0;
        if (loadingTerrainSlopes > 0) {
            if (prevHeight != -1) {
                verticalSlope = Math.max(-128, Math.min(127, blockY - prevHeight));
            }
            if (prevHeightDiagonal != -1) {
                diagonalSlope = Math.max(-128, Math.min(127, blockY - prevHeightDiagonal));
            }
        }
        currentComparisonCode |= 0L;
        for (int i3 = 0; i3 < pixelBlockLights.size(); ++i3) {
            int l = pixelBlockLights.get(i3);
            if (i3 <= 1) {
                currentComparisonCodeAdd = (byte)(currentComparisonCodeAdd | l << 4 * i3 + 2);
            }
            if (i3 < 1) continue;
            currentComparisonCode |= (long)(l << 4 * (i3 - 1) >> 2);
        }
        int add2Calculation = 17;
        for (int i4 = 0; i4 < pixelTransparentSizes.size(); ++i4) {
            add2Calculation = add2Calculation * 37 + pixelTransparentSizes.get(i4);
        }
        currentComparisonCodeAdd = (byte)(currentComparisonCodeAdd | add2Calculation >> 8 & 3);
        currentComparisonCodeAdd2 = (byte)add2Calculation;
        boolean bl = reuseColour = !settingsChanged && sameCaveLevel && !oldTile.pixelChanged(insideX, insideZ, currentComparisonCode, currentComparisonCodeAdd, currentComparisonCodeAdd2, (byte)verticalSlope, (byte)diagonalSlope);
        if (!reuseColour) {
            boolean hasTransparentLayer;
            int firstSun = this.sun;
            boolean bl2 = hasTransparentLayer = !pixelTransparentSizes.isEmpty();
            if (hasTransparentLayer && firstSun != 15) {
                this.sun = 15;
            }
            this.calculateBlockColors(world, bchunk, insideX, insideZ, mutableBlockPos2, pixelTransparentSizes, pixelBlockStates, pixelBlockLights, loadingColours, loadingLightOverlayColor);
            int blockColor = this.blockColor;
            float currentTransparencyMultiplier = this.currentTransparencyMultiplier;
            int sun = this.sun;
            boolean bl3 = isglowing = block != null && !(block instanceof class_2431) && isglowing;
            if (!isglowing || hasTransparentLayer) {
                boolean lighting = loadingLevels != 1;
                int blockLight = pixelBlockLights.isEmpty() ? 0 : pixelBlockLights.get(pixelBlockLights.size() - 1);
                for (int i5 = 0; i5 < loadingLevels; ++i5) {
                    postBrightness[i5] = 1.0f;
                    if (!isglowing && !lighting && loadingCaving != -1) {
                        if (!hasTransparentLayer) {
                            brightness[i5] = (float)Math.min((double)blockY / 80.0, 1.0);
                            continue;
                        }
                        brightness[i5] = 1.0f;
                        postBrightness[i5] = (float)Math.min((double)blockY / 80.0, 1.0);
                        continue;
                    }
                    if (!isglowing) {
                        brightness[i5] = !hasTransparentLayer ? this.getBlockBrightness(9.0f, sun, i5, blockLight) : this.getBlockBrightness(9.0f, sun, 0, blockLight);
                    }
                    if (!hasTransparentLayer) continue;
                    int topLight = pixelBlockLights.get(0);
                    postBrightness[i5] = this.getBlockBrightness(9.0f, firstSun, i5, topLight);
                }
            }
            int cr = blockColor >> 16 & 0xFF;
            int cg = blockColor >> 8 & 0xFF;
            int cb = blockColor & 0xFF;
            if (isglowing) {
                helper.getGlowingColour(cr, cg, cb, tempColor);
                cr = tempColor[0];
                cg = tempColor[1];
                cb = tempColor[2];
            }
            float depthBrightness = 1.0f;
            if (!isglowing && loadingCaving == -1 && loadingTerrainDepth) {
                float min;
                depthBrightness = (float)blockY / 63.0f;
                float max = loadingTerrainSlopes >= 2 ? 1.0f : 1.15f;
                float f = min = loadingTerrainSlopes >= 2 ? 0.9f : 0.7f;
                if (depthBrightness > max) {
                    depthBrightness = max;
                } else if (depthBrightness < min) {
                    depthBrightness = min;
                }
            }
            if (loadingTerrainSlopes > 0) {
                if (loadingTerrainSlopes == 1) {
                    if (!isglowing) {
                        if (verticalSlope > 0) {
                            depthBrightness = (float)((double)depthBrightness * 1.15);
                        } else if (verticalSlope < 0) {
                            depthBrightness = (float)((double)depthBrightness * 0.85);
                        }
                    }
                } else {
                    float ambientLightColored = 0.2f;
                    float ambientLightWhite = 0.5f;
                    float maxDirectLight = 0.6666667f;
                    if (isglowing) {
                        ambientLightColored = 0.0f;
                        ambientLightWhite = 1.0f;
                        maxDirectLight = 0.22222224f;
                    }
                    float cos = 0.0f;
                    if (loadingTerrainSlopes == 2) {
                        float crossZ = -verticalSlope;
                        if (crossZ < 1.0f) {
                            if (verticalSlope == 1 && diagonalSlope == 1) {
                                cos = 1.0f;
                            } else {
                                float crossX = verticalSlope - diagonalSlope;
                                float cast = 1.0f - crossZ;
                                float crossMagnitude = (float)Math.sqrt(crossX * crossX + 1.0f + crossZ * crossZ);
                                cos = (float)((double)(cast / crossMagnitude) / Math.sqrt(2.0));
                            }
                        }
                    } else if (verticalSlope >= 0) {
                        if (verticalSlope == 1) {
                            cos = 1.0f;
                        } else {
                            float surfaceDirectionMagnitude = (float)Math.sqrt(verticalSlope * verticalSlope + 1);
                            float castToMostLit = verticalSlope + 1;
                            cos = (float)((double)(castToMostLit / surfaceDirectionMagnitude) / Math.sqrt(2.0));
                        }
                    }
                    float directLightClamped = 0.0f;
                    if (cos == 1.0f) {
                        directLightClamped = maxDirectLight;
                    } else if (cos > 0.0f) {
                        directLightClamped = (float)Math.ceil(cos * 10.0f) / 10.0f * maxDirectLight * 0.88388f;
                    }
                    float whiteLight = ambientLightWhite + directLightClamped;
                    secondaryBR *= (double)(shadowR * ambientLightColored + whiteLight);
                    secondaryBG *= (double)(shadowG * ambientLightColored + whiteLight);
                    secondaryBB *= (double)(shadowB * ambientLightColored + whiteLight);
                }
            }
            secondaryBR *= (double)depthBrightness;
            secondaryBG *= (double)depthBrightness;
            secondaryBB *= (double)depthBrightness;
            if (loadingLightOverlayType > 0) {
                int testLight;
                int blockLight;
                int n2 = blockLight = pixelBlockLights.isEmpty() ? 0 : pixelBlockLights.get(0);
                int n3 = loadingLightOverlayType == 1 ? blockLight : (testLight = loadingLightOverlayType == 2 ? firstSun : Math.max(blockLight, firstSun));
                if (testLight >= loadingLightOverlayMinLight && testLight <= loadingLightOverlayMaxLight) {
                    int overlayColor = ModSettings.COLORS[loadingLightOverlayColor];
                    int overlayRed = (overlayColor >> 16 & 0xFF) * 2 / 3;
                    int overlayGreen = (overlayColor >> 8 & 0xFF) * 2 / 3;
                    int overlayBlue = (overlayColor & 0xFF) * 2 / 3;
                    int i6 = 0;
                    while (i6 < loadingLevels) {
                        float destColorScale = (isglowing ? 1.0f : postBrightness[i6]) / 3.0f;
                        int n4 = i6;
                        underRed[n4] = (int)((float)underRed[n4] * destColorScale);
                        int n5 = i6;
                        underGreen[n5] = (int)((float)underGreen[n5] * destColorScale);
                        int n6 = i6;
                        underBlue[n6] = (int)((float)underBlue[n6] * destColorScale);
                        int n7 = i6;
                        brightness[n7] = brightness[n7] * destColorScale;
                        postBrightness[i6] = 1.0f;
                        int n8 = i6;
                        underRed[n8] = underRed[n8] + overlayRed;
                        int n9 = i6;
                        underGreen[n9] = underGreen[n9] + overlayGreen;
                        int n10 = i6++;
                        underBlue[n10] = underBlue[n10] + overlayBlue;
                    }
                    if (isglowing) {
                        secondaryBR /= 3.0;
                        secondaryBG /= 3.0;
                        secondaryBB /= 3.0;
                    }
                }
            }
            for (int i7 = 0; i7 < loadingLevels; ++i7) {
                float b;
                if (isglowing) {
                    b = 1.0f;
                    if (!hasTransparentLayer) {
                        postBrightness[i7] = 1.0f;
                    }
                } else {
                    b = brightness[i7];
                }
                red[i7] = (int)(((double)((float)cr * b) * secondaryBR * (double)currentTransparencyMultiplier + (double)underRed[i7]) * (double)postBrightness[i7]);
                if (red[i7] > 255) {
                    red[i7] = 255;
                }
                green[i7] = (int)(((double)((float)cg * b) * secondaryBG * (double)currentTransparencyMultiplier + (double)underGreen[i7]) * (double)postBrightness[i7]);
                if (green[i7] > 255) {
                    green[i7] = 255;
                }
                blue[i7] = (int)(((double)((float)cb * b) * secondaryBB * (double)currentTransparencyMultiplier + (double)underBlue[i7]) * (double)postBrightness[i7]);
                if (blue[i7] <= 255) continue;
                blue[i7] = 255;
            }
        } else {
            for (i = 0; i < loadingLevels; ++i) {
                red[i] = oldTile.getRed(i, insideX, insideZ);
                green[i] = oldTile.getGreen(i, insideX, insideZ);
                blue[i] = oldTile.getBlue(i, insideX, insideZ);
            }
        }
        if (this.notEmptyColor(red, green, blue)) {
            mchunk.setHasSomething(true);
        }
        if (tile == null) {
            tile = MinimapTile.getANewTile(modMain.getSettings(), tileX, tileZ, seedForLoading);
            mchunk.setTile(tileInsideX, tileInsideZ, tile);
        }
        tile.setHeight(insideX, insideZ, blockY);
        tile.setCode(insideX, insideZ, currentComparisonCode, currentComparisonCodeAdd, currentComparisonCodeAdd2, (byte)verticalSlope, (byte)diagonalSlope);
        if (tile.isSuccess()) {
            tile.setSuccess(success);
        }
        if (oldTile != null) {
            int oldTileDarkestLevel = loadedLevels - 1;
            int tileDarkestLevel = loadingLevels - 1;
            if (oldTile.getRed(oldTileDarkestLevel, insideX, insideZ) != red[tileDarkestLevel] || oldTile.getGreen(oldTileDarkestLevel, insideX, insideZ) != green[tileDarkestLevel] || oldTile.getBlue(oldTileDarkestLevel, insideX, insideZ) != blue[tileDarkestLevel]) {
                mchunk.setChanged(true);
            }
        } else {
            mchunk.setChanged(true);
        }
        for (i = 0; i < loadingLevels; ++i) {
            tile.setRGB(i, insideX, insideZ, red[i], green[i], blue[i]);
        }
        return tile;
    }

    public class_2248 findBlock(class_1937 world, class_2818 bchunk, int insideX, int insideZ, int highY, int lowY, int loadingCaving, boolean loadingRedstone, class_2338.class_2339 mutableBlockPos, class_2338.class_2339 mutableBlockPos2, int loadingColours, boolean loadingTransparency, List<Integer> pixelBlockLights, List<class_2680> pixelBlockStates, int loadingLevels, List<Integer> pixelTransparentSizes, boolean loadingFlowers) {
        this.underair = false;
        this.previousTransparentState = null;
        for (int i = highY; i >= lowY; --i) {
            mutableBlockPos.method_10103(insideX, i, insideZ);
            class_2680 state = bchunk.method_8320((class_2338)mutableBlockPos);
            class_3610 fluidFluidState = state.method_11618();
            class_2680 fluidState = fluidFluidState.method_15759();
            if (!fluidFluidState.method_15769()) {
                this.underair = true;
                if (this.findBlockHelp(world, (class_2791)bchunk, insideX, i, insideZ, fluidState, fluidFluidState, loadingCaving, loadingRedstone, mutableBlockPos, mutableBlockPos2, loadingColours, loadingTransparency, pixelBlockLights, pixelBlockStates, loadingLevels, pixelTransparentSizes, loadingFlowers)) {
                    return fluidState.method_11614();
                }
            }
            if (state == null || state.method_11614() != class_2246.field_10124 && state.method_11614() == fluidState.method_11614() || !this.findBlockHelp(world, (class_2791)bchunk, insideX, i, insideZ, state, null, loadingCaving, loadingRedstone, mutableBlockPos, mutableBlockPos2, loadingColours, loadingTransparency, pixelBlockLights, pixelBlockStates, loadingLevels, pixelTransparentSizes, loadingFlowers)) continue;
            return state.method_11614();
        }
        return null;
    }

    private boolean findBlockHelp(class_1937 world, class_2791 bchunk, int insideX, int i, int insideZ, class_2680 state, class_3610 fluidFluidState, int loadingCaving, boolean loadingRedstone, class_2338.class_2339 mutableBlockPos, class_2338.class_2339 mutableBlockPos2, int loadingColours, boolean loadingTransparency, List<Integer> pixelBlockLights, List<class_2680> pixelBlockStates, int loadingLevels, List<Integer> pixelTransparentSizes, boolean loadingFlowers) {
        class_2248 got = state.method_11614();
        if (!(got instanceof class_2189) && (this.underair || loadingCaving == -1)) {
            boolean isRedstone = false;
            if (!(got instanceof class_2404) && state.method_11610() == class_2464.field_11455) {
                return false;
            }
            if (got == class_2246.field_10336) {
                return false;
            }
            if (got == class_2246.field_10479) {
                return false;
            }
            if (got instanceof class_2320) {
                return false;
            }
            if (!loadingFlowers && got instanceof class_2261) {
                return false;
            }
            boolean bl = isRedstone = got == class_2246.field_10523 || got == class_2246.field_10091 || got instanceof class_2462 || got instanceof class_2286;
            if (!loadingRedstone && isRedstone) {
                return false;
            }
            if (this.buggedStates.contains(state)) {
                return false;
            }
            this.blockY = i;
            class_2338.class_2339 globalPos = mutableBlockPos2.method_10103(bchunk.method_12004().field_9181 * 16 + insideX, i, bchunk.method_12004().field_9180 * 16 + insideZ);
            class_2338.class_2339 lightPos = mutableBlockPos.method_10103(globalPos.method_10263(), globalPos.method_10264() + 1, globalPos.method_10260());
            class_3620 mapColor = null;
            try {
                mapColor = state.method_11625((class_1922)world, (class_2338)globalPos);
            }
            catch (Throwable t) {
                this.buggedStates.add(state);
                System.out.println("Broken vanilla map color definition found: " + got.method_9580());
            }
            if (!(isRedstone && loadingColours != 1 || mapColor != null && mapColor.field_16011 != 0)) {
                return false;
            }
            if (this.currentComparisonCode == 0L) {
                this.firstBlockY = i;
                if (loadingLevels != 1 && loadingCaving != -1) {
                    this.sun = world.method_8314(class_1944.field_9284, (class_2338)lightPos);
                }
            }
            int stateId = class_2248.method_9507((class_2680)state);
            if (loadingTransparency && (state == this.previousTransparentState || this.isTransparent(state, fluidFluidState))) {
                if (pixelBlockStates.size() < 5 && state != this.previousTransparentState) {
                    this.currentComparisonCode += (long)stateId & 0xFFFFFFFFL;
                    pixelBlockStates.add(state);
                    pixelTransparentSizes.add(1);
                    pixelBlockLights.add(loadingLevels == 1 ? 0 : world.method_8314(class_1944.field_9282, (class_2338)lightPos));
                    this.previousTransparentState = state;
                } else {
                    pixelTransparentSizes.set(pixelTransparentSizes.size() - 1, pixelTransparentSizes.get(pixelTransparentSizes.size() - 1) + 1);
                }
                return false;
            }
            this.currentComparisonCode += (long)stateId & 0xFFFFFFFFL;
            this.currentComparisonCode <<= 29;
            this.currentComparisonCode |= (long)i << 21;
            pixelBlockLights.add(loadingLevels == 1 ? 0 : world.method_8314(class_1944.field_9282, (class_2338)lightPos));
            pixelBlockStates.add(state);
            this.isglowing = this.isGlowing(state, world, (class_2338)globalPos);
            return true;
        }
        if (got instanceof class_2189) {
            this.underair = true;
        }
        return false;
    }

    private void calculateBlockColors(class_1937 world, class_2818 bchunk, int insideX, int insideZ, class_2338.class_2339 mutableBlockPos2, List<Integer> pixelTransparentSizes, List<class_2680> pixelBlockStates, List<Integer> pixelBlockLights, int loadingColours, int loadingLightOverlayColor) {
        int firstBlockY = this.firstBlockY;
        class_2338.class_2339 globalPos = mutableBlockPos2.method_10103(bchunk.method_12004().field_9181 * 16 + insideX, firstBlockY, bchunk.method_12004().field_9180 * 16 + insideZ);
        if (!pixelTransparentSizes.isEmpty()) {
            for (int i = 0; i < pixelTransparentSizes.size(); ++i) {
                class_2680 state = pixelBlockStates.get(i);
                class_2248 b = state.method_11614();
                int size = pixelTransparentSizes.get(i);
                int opacity = state.method_11581((class_1922)bchunk.method_12200(), (class_2338)globalPos);
                this.applyTransparentLayer(world, bchunk, b, state, opacity * size, (class_2338)globalPos, pixelBlockLights.get(i));
                int nextY = globalPos.method_10264() - size;
                globalPos.method_10099(nextY);
            }
        }
        if (!pixelBlockStates.isEmpty()) {
            int color;
            class_2680 state = pixelBlockStates.get(pixelBlockStates.size() - 1);
            class_2248 b = state.method_11614();
            if (loadingColours == 1) {
                class_3620 minimapColor = state.method_11625((class_1922)world, (class_2338)globalPos);
                color = minimapColor.field_16011;
            } else {
                color = this.loadBlockColourFromTexture(world, state, b, (class_2338)globalPos, true);
            }
            this.blockColor = this.addBlockColorMultipliers(color, state, world, (class_2338)globalPos);
        }
    }

    private boolean isTransparent(class_2680 state, class_3610 fluidFluidState) {
        Boolean cachedValue = this.transparentCache.get(state);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean transparent = state.method_11614() instanceof class_2368 || (fluidFluidState == null ? class_4696.method_23679((class_2680)state) == class_1921.method_23583() : class_4696.method_23680((class_3610)fluidFluidState) == class_1921.method_23583());
        this.transparentCache.put(state, transparent);
        return transparent;
    }

    private boolean isGlowing(class_2680 state, class_1937 world, class_2338 pos) {
        Boolean cachedValue = this.glowingCache.get(state);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean isGlowing = false;
        try {
            isGlowing = state.method_11630() > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.glowingCache.put(state, isGlowing);
        return isGlowing;
    }

    private void applyTransparentLayer(class_1937 world, class_2818 bchunk, class_2248 b, class_2680 state, int opacity, class_2338 globalPos, int blockLight) {
        float transparency;
        int red = 0;
        int green = 0;
        int blue = 0;
        float f = b instanceof class_2404 ? 0.66f : (transparency = b instanceof class_2386 ? 0.83f : 0.5f);
        int color = this.loadingColours == 0 ? this.loadBlockColourFromTexture(world, state, b, globalPos, true) : (b instanceof class_2404 ? -16751391 : state.method_11625((class_1922)world, (class_2338)globalPos).field_16011);
        color = this.addBlockColorMultipliers(color, state, world, globalPos);
        red = color >> 16 & 0xFF;
        green = color >> 8 & 0xFF;
        blue = color & 0xFF;
        if (this.isGlowing(state, bchunk.method_12200(), globalPos)) {
            this.helper.getGlowingColour(red, green, blue, this.tempColor);
            red = this.tempColor[0];
            green = this.tempColor[1];
            blue = this.tempColor[2];
        }
        float overlayIntensity = this.currentTransparencyMultiplier * transparency * this.getBlockBrightness(9.0f, this.sun, 0, blockLight);
        int i = 0;
        while (i < this.loadingLevels) {
            int n = i;
            this.underRed[n] = (int)((float)this.underRed[n] + (float)red * overlayIntensity);
            int n2 = i;
            this.underGreen[n2] = (int)((float)this.underGreen[n2] + (float)green * overlayIntensity);
            int n3 = i++;
            this.underBlue[n3] = (int)((float)this.underBlue[n3] + (float)blue * overlayIntensity);
        }
        this.currentTransparencyMultiplier *= 1.0f - transparency;
        this.sun -= opacity;
        if (this.sun < 0) {
            this.sun = 0;
        }
    }

    private int loadBlockColourFromTexture(class_1937 world, class_2680 state, class_2248 b, class_2338 pos, boolean convert) {
        int stateHash = class_2248.method_9507((class_2680)state);
        Integer c = this.blockColours.get(stateHash);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                class_1058 texture;
                List upQuads = null;
                class_773 bms = class_310.method_1551().method_1541().method_3351();
                class_1087 model = bms.method_3335(state);
                if (convert) {
                    upQuads = model.method_4707(state, class_2350.field_11036, this.usedRandom);
                }
                class_1058 missingTexture = class_310.method_1551().method_1554().method_24153(class_1059.field_5275).method_4608((class_2960)null);
                if (upQuads == null || upQuads.isEmpty() || ((MixinBakedQuad)upQuads.get(0)).getSprite() == missingTexture) {
                    texture = bms.method_3339(state);
                    if (texture == missingTexture) {
                        List quads;
                        for (int i = class_2350.values().length - 1; i >= 0 && (i == 1 || (quads = model.method_4707(state, class_2350.values()[i], this.usedRandom)).isEmpty() || (texture = ((MixinBakedQuad)quads.get(0)).getSprite()) == missingTexture); --i) {
                        }
                    }
                } else {
                    texture = ((MixinBakedQuad)upQuads.get(0)).getSprite();
                }
                name = texture.method_4598() + ".png";
                if (b instanceof class_2431 && b != class_2246.field_10213) {
                    name = "minecraft:block/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    args = new String[]{"minecraft", args[0]};
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    class_2960 location = new class_2960(args[0], "textures/" + args[1]);
                    class_3298 resource = class_310.method_1551().method_1478().method_14486(location);
                    InputStream input = resource.method_14482();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 64;
                    int tw = img.getWidth();
                    if (tw > 0) {
                        int diff = tw / 8;
                        for (int i = 0; i < 8; ++i) {
                            for (int j = 0; j < 8; ++j) {
                                int rgb = img.getRGB(i * diff, j * diff);
                                int alpha = rgb >> 24 & 0xFF;
                                if (rgb == 0 || alpha == 0) {
                                    --total;
                                    continue;
                                }
                                red += rgb >> 16 & 0xFF;
                                green += rgb >> 8 & 0xFF;
                                blue += rgb & 0xFF;
                            }
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new SilentException("Black texture " + tw);
                    }
                    c = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(world, state, b, pos, false);
                }
                c = 0;
                if (state != null && state.method_11625((class_1922)world, pos) != null) {
                    c = state.method_11625((class_1922)world, (class_2338)pos).field_16011;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Block file not found: " + b.method_9580());
            }
            catch (Exception e) {
                if (state.method_11625((class_1922)world, pos) != null) {
                    c = state.method_11625((class_1922)world, (class_2338)pos).field_16011;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Exception when loading " + b.method_9580() + " texture, using material colour.");
                if (e instanceof SilentException) {
                    System.out.println(e.getMessage());
                }
                e.printStackTrace();
            }
            if (c != null) {
                this.blockColours.put(stateHash, c);
            }
        }
        return c;
    }

    private int addBlockColorMultipliers(int c, class_2680 state, class_1937 world, class_2338 pos) {
        if (this.modMain.getSettings().getBlockColours() == 1 && !this.loadingBiomesVanillaMode) {
            return c;
        }
        int grassColor = 0xFFFFFF;
        try {
            grassColor = class_310.method_1551().method_1505().method_1697(state, (class_1920)world, pos, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (class_148 class_1482) {
            // empty catch block
        }
        if (grassColor != 0xFFFFFF) {
            float rMultiplier = (float)(c >> 16 & 0xFF) / 255.0f;
            float gMultiplier = (float)(c >> 8 & 0xFF) / 255.0f;
            float bMultiplier = (float)(c & 0xFF) / 255.0f;
            int red = (int)((float)(grassColor >> 16 & 0xFF) * rMultiplier);
            int green = (int)((float)(grassColor >> 8 & 0xFF) * gMultiplier);
            int blue = (int)((float)(grassColor & 0xFF) * bMultiplier);
            c = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        return c;
    }

    private boolean ignoreWorld(class_1937 world) {
        for (int i = 0; i < dimensionsToIgnore.length; ++i) {
            if (!dimensionsToIgnore[i].equals(WaypointsManager.getDimensionKey(world.method_8597().method_12460()).method_12832())) continue;
            return true;
        }
        return false;
    }

    private int getCaving(double playerX, double playerY, double playerZ, class_1937 world) {
        if (!this.modMain.getSettings().getCaveMaps() || this.mc.field_1724.method_6059(Effects.NO_CAVE_MAPS) || this.mc.field_1724.method_6059(Effects.NO_CAVE_MAPS_BENEFICIAL) || this.mc.field_1724.method_6059(Effects.NO_CAVE_MAPS_HARMFUL)) {
            return -1;
        }
        if (this.ignoreWorld(world)) {
            return this.lastCaving;
        }
        int y = Math.max((int)playerY + 1, 0);
        if (y > 255 || y < 0) {
            return -1;
        }
        int x = OptimizedMath.myFloor(playerX);
        int z = OptimizedMath.myFloor(playerZ);
        this.mutableBlockPos.method_10103(x, y, z);
        class_2818 bchunk = world.method_8497(x >> 4, z >> 4);
        if (bchunk == null) {
            return -1;
        }
        int skyLight = world.method_8314(class_1944.field_9284, (class_2338)this.mutableBlockPos);
        int roofRadius = this.modMain.getSettings().caveMaps - 1;
        int insideX = x & 0xF;
        int insideZ = z & 0xF;
        int bottom = y;
        int top = -1;
        boolean ignoringHeightmaps = this.modMain.getSettings().isIgnoreHeightmaps();
        if (skyLight < 15 && !ignoringHeightmaps) {
            top = bchunk.method_12005(class_2902.class_2903.field_13202, insideX, insideZ);
        } else if (ignoringHeightmaps) {
            class_2826[] sections = bchunk.method_12006();
            int playerSection = y >> 4;
            boolean foundSomething = false;
            for (int i = playerSection; i < sections.length; ++i) {
                class_2826 searchedSection = sections[i];
                if (searchedSection == class_2818.field_12852) continue;
                if (!foundSomething) {
                    bottom = Math.max(bottom, i << 4);
                    foundSomething = true;
                }
                top = (i << 4) + 15;
            }
            if (!foundSomething) {
                return -1;
            }
        }
        if (top < 0) {
            return -1;
        }
        if (top > 255) {
            top = 255;
        }
        block1: for (int i = bottom; i <= top; ++i) {
            for (int o = x - roofRadius; o <= x + roofRadius; ++o) {
                for (int p = z - roofRadius; p <= z + roofRadius; ++p) {
                    this.mutableBlockPos.method_10103(o, i, p);
                    class_2680 state = world.method_8320((class_2338)this.mutableBlockPos);
                    if (!state.method_11620().method_15804() || state.method_11614() == class_2246.field_10499) continue block1;
                }
            }
            this.lastCaving = Math.min(i, y + 3);
            return this.lastCaving;
        }
        return -1;
    }

    public int getSectionBasedHeight(class_2818 bchunk, int startY) {
        class_2826 searchedSection;
        int i;
        class_2826[] sections = bchunk.method_12006();
        int playerSection = startY >> 4;
        int result = -1;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection == class_2818.field_12852) continue;
            result = (i << 4) + 15;
        }
        if (playerSection > 0 && result == -1) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection == class_2818.field_12852) continue;
                result = (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public int getLoadSide() {
        return 9;
    }

    public int getUpdateRadiusInChunks() {
        return (int)Math.ceil((double)this.loadingSideInChunks / 2.0 / this.minimapSession.getMinimapProcessor().getMinimapZoom());
    }

    public int getMapCoord(int side, int coord) {
        return (coord >> 6) - side / 2;
    }

    public int getLoadedCaving() {
        return this.loadedCaving;
    }

    private boolean notEmptyColor(int[] red, int[] green, int[] blue) {
        return red[0] != 0 || green[0] != 0 || blue[0] != 0;
    }

    public float getBlockBrightness(float min, int sun, int lightLevel, int blockLight) {
        if (this.loadingLevels == 1) {
            return (min + (float)sun) / (15.0f + min);
        }
        return (min + Math.max((lightLevel == -1 || lightLevel == 0 ? 1.0f : ((float)this.loadingLevels - 1.0f - (float)lightLevel) / ((float)this.loadingLevels - 1.0f)) * (float)sun, (float)blockLight)) / (15.0f + min);
    }

    public MinimapChunk[][] getLoadedBlocks() {
        return this.loadedBlocks;
    }

    public int getLoadedMapChunkZ() {
        return this.loadedMapChunkZ;
    }

    public int getLoadedMapChunkX() {
        return this.loadedMapChunkX;
    }

    public int getLoadedLevels() {
        return this.loadedLevels;
    }

    public void setClearBlockColours(boolean clearBlockColours) {
        this.clearBlockColours = clearBlockColours;
    }

    public void setSeedForLoading(Long seedForLoading) {
        this.seedForLoading = seedForLoading;
    }

    public void cleanup() {
        if (this.loadedBlocks != null) {
            for (int i = 0; i < this.loadedBlocks.length; ++i) {
                for (int j = 0; j < this.loadedBlocks.length; ++j) {
                    MinimapChunk m = this.loadedBlocks[i][j];
                    if (m == null) continue;
                    m.cleanup(this.minimapInterface);
                }
            }
        }
    }
}

