/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_2818;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import xaero.common.AXaeroMinimap;
import xaero.common.gui.IScreenBase;

public class Misc {
    public static final class_1159 IDENTITY = class_4590.method_22931().method_22936();

    public static double getMouseX(class_310 mc) {
        return mc.field_1729.method_1603() * (double)mc.method_22683().method_4489() / (double)mc.method_22683().method_4480();
    }

    public static double getMouseY(class_310 mc) {
        return mc.field_1729.method_1604() * (double)mc.method_22683().method_4506() / (double)mc.method_22683().method_4507();
    }

    public static void drawPiercingText(String name, float x, float y, int color, boolean shadow, class_4597.class_4598 renderTypeBuffer) {
        class_310.method_1551().field_1772.method_22942(name, x, y, color, shadow, IDENTITY, (class_4597)renderTypeBuffer, true, 0, 0xF000F0);
        renderTypeBuffer.method_22993();
    }

    public static void drawCenteredPiercingText(String name, float x, float y, int color, boolean shadow, class_4597.class_4598 renderTypeBuffer) {
        Misc.drawPiercingText(name, x - (float)(class_310.method_1551().field_1772.method_1727(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void minecraftOrtho(class_310 mc) {
        class_1041 mainwindow = mc.method_22683();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)mainwindow.method_4489() / mainwindow.method_4495()), (double)((double)mainwindow.method_4506() / mainwindow.method_4495()), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFromOnFail) throws IOException {
        Path backupPath = null;
        try {
            if (Files.exists(to, new LinkOption[0])) {
                backupPath = Misc.quickFileBackupMove(to);
            }
            Files.move(from, to, new CopyOption[0]);
        }
        catch (IOException ioe) {
            while (backupFromOnFail) {
                try {
                    if (!Files.exists(from, new LinkOption[0])) break;
                    Misc.quickFileBackupMove(from);
                    break;
                }
                catch (IOException ioe2) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            throw ioe;
        }
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static boolean inputMatchesKeyBinding(class_3675.class_307 type, int code, class_304 kb) {
        return code != -1 && KeyBindingHelper.getBoundKeyOf((class_304)kb).method_1442() == type && KeyBindingHelper.getBoundKeyOf((class_304)kb).method_1444() == code;
    }

    public static boolean screenShouldSkipWorldRender(AXaeroMinimap modMain, class_437 screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && modMain.getSupportMods().worldmap() && modMain.getSupportMods().worldmapSupport.screenShouldSkipWorldRender(screen);
    }

    public static long getChunkPosAsLong(class_2818 chunk) {
        return chunk.method_12004().method_8324();
    }

    public static Field getFieldReflection(Class<?> c, String obfuscatedName, String shortObfuscatedName, String name) {
        Field field = null;
        try {
            field = c.getDeclaredField(obfuscatedName);
        }
        catch (NoSuchFieldException e) {
            field = Misc.getFieldReflection(c, shortObfuscatedName, name);
        }
        return field;
    }

    public static Field getFieldReflection(Class<?> c, String obfuscatedName, String name) {
        Field field = null;
        try {
            field = c.getDeclaredField(obfuscatedName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = c.getDeclaredField(name);
            }
            catch (NoSuchFieldException e1) {
                throw new RuntimeException(e1);
            }
        }
        return field;
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }
}

