/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4493;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.lwjgl.opengl.GL11;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconManager {
    private EntityIconPrerenderer prerenderer;
    private Map<class_2960, EntityIconDefinition> iconDefinitions;
    private Map<String, Integer> cachedTextures;
    private Map<String, Integer> cachedResourceTextures;
    private boolean canPrerender;
    private Gson gson;
    private StringBuilder entityStringBuilder;
    private EntityIconModelConfig defaultModelConfig;

    public EntityIconManager(EntityIconPrerenderer prerenderer) {
        this.prerenderer = prerenderer;
        this.iconDefinitions = new HashMap<class_2960, EntityIconDefinition>();
        this.cachedTextures = new HashMap<String, Integer>();
        this.cachedResourceTextures = new HashMap<String, Integer>();
        this.gson = new Gson();
        this.resetResources();
        this.entityStringBuilder = new StringBuilder();
        this.defaultModelConfig = new EntityIconModelConfig();
    }

    protected String getSavedEntityId(class_1297 e) {
        class_1299 entityType = e.method_5864();
        class_2960 identifier = class_1299.method_5890((class_1299)entityType);
        return entityType.method_5893() && identifier != null ? identifier.toString() : null;
    }

    public <T extends class_1297> int getEntityHeadTexture(T entity, class_276 defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean[] spriteBased, boolean debug, boolean debugEntityVariantIds) {
        class_1309 livingEntity;
        class_1799 headItemStack;
        class_2960 entityId = class_1299.method_5890((class_1299)entity.method_5864());
        EntityIconDefinition iconDefinition = this.iconDefinitions.get(entityId);
        class_898 renderManager = class_310.method_1551().method_1561();
        class_897 entityRenderer = renderManager.method_3953(entity);
        StringBuilder entityStringBuilder = this.entityStringBuilder;
        entityStringBuilder.setLength(0);
        boolean variantIdAppended = false;
        if (iconDefinition != null) {
            Method variantIdBuilderMethod = iconDefinition.getVariantIdBuilderMethod();
            if (variantIdBuilderMethod != null) {
                try {
                    variantIdBuilderMethod.invoke(null, entityStringBuilder, entityRenderer, entity);
                    variantIdAppended = true;
                }
                catch (Exception e) {
                    System.out.println("Exception while using the variant builder ID method " + iconDefinition.getVariantIdBuilderMethodString() + " defined for " + entityId);
                    e.printStackTrace();
                    iconDefinition.setVariantIdBuilderMethod(null);
                }
            } else {
                Method variantOldIdMethod = iconDefinition.getOldVariantIdMethod();
                if (variantOldIdMethod != null) {
                    try {
                        String entityVariantString = (String)variantOldIdMethod.invoke(null, entityRenderer, entity);
                        entityStringBuilder.append(entityVariantString);
                        variantIdAppended = true;
                    }
                    catch (Exception e) {
                        System.out.println("Exception while using the variant ID method " + iconDefinition.getOldVariantIdMethodString() + " defined for " + entityId);
                        e.printStackTrace();
                        iconDefinition.setOldVariantIdMethod(null);
                    }
                }
            }
        }
        if (!variantIdAppended) {
            EntityIconDefinitions.buildVariantIdString(entityStringBuilder, entityRenderer, entity);
        }
        String entityVariantString = entityStringBuilder.toString();
        entityStringBuilder.append("%").append(this.getSavedEntityId(entity));
        if (entity instanceof class_1309 && (headItemStack = (livingEntity = (class_1309)entity).method_6118(class_1304.field_6169)) != null && headItemStack != class_1799.field_8037) {
            entityStringBuilder.append("%").append(class_2378.field_11142.method_10221((Object)headItemStack.method_7909()));
        }
        String cacheKey = entityStringBuilder.toString();
        Integer cachedValue = this.cachedTextures.get(cacheKey);
        spriteBased[0] = false;
        if (cachedValue == null) {
            cachedValue = this.cachedResourceTextures.get(cacheKey);
            if (cachedValue == null) {
                class_2960 iconType;
                if (debugEntityVariantIds) {
                    class_310.method_1551().field_1705.method_1743().method_1812((class_2561)new class_2585(entityVariantString));
                }
                String variantMapKey = entityVariantString;
                if (iconDefinition != null) {
                    iconType = iconDefinition.getVariantType(variantMapKey);
                    if (iconType == null) {
                        variantMapKey = "default";
                        iconType = iconDefinition.getVariantType(variantMapKey);
                    }
                } else {
                    iconType = EntityIconDefinition.MODEL_TYPE;
                }
                if (iconType == EntityIconDefinition.MODEL_TYPE) {
                    if (this.canPrerender) {
                        EntityIconModelConfig variantModelConfig;
                        EntityIconModelConfig modelConfig = this.defaultModelConfig;
                        EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                        if (variantModelConfig != null) {
                            modelConfig = variantModelConfig;
                        }
                        cachedValue = this.prerenderer.prerender(entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, debug);
                        this.cachedTextures.put(cacheKey, cachedValue);
                        if (cachedValue != -1) {
                            this.canPrerender = false;
                        }
                    } else {
                        cachedValue = -1;
                    }
                } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                    cachedValue = -1;
                    this.cachedTextures.put(cacheKey, cachedValue);
                } else {
                    class_310.method_1551().method_1531().method_22813(iconType);
                    GL11.glTexParameteri((int)3553, (int)33085, (int)3);
                    GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                    GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
                    GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9985);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                    GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                    this.prerenderer.generateMipmaps();
                    cachedValue = class_4493.method_29334();
                    this.cachedResourceTextures.put(cacheKey, cachedValue);
                    spriteBased[0] = true;
                }
            } else {
                spriteBased[0] = true;
            }
        }
        return cachedValue;
    }

    public void reset() {
        for (Integer value : this.cachedTextures.values()) {
            if (value == null || value <= 0) continue;
            class_4493.method_22079((int)value);
        }
        this.cachedTextures.clear();
        System.out.println("Entity icon manager reset!");
    }

    public void resetResources() {
        System.out.println("Reloading entity icon resources...");
        Set entityIds = class_2378.field_11145.method_10235();
        Gson gson = this.gson;
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.resetResourcesAttempt(gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        System.out.println("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResourcesAttempt(Gson gson, Set<class_2960> entityIds) throws IOException {
        this.cachedResourceTextures.clear();
        this.iconDefinitions.clear();
        for (class_2960 id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            class_3298 resource = null;
            try {
                resource = class_310.method_1551().method_1478().method_14486(new class_2960("xaerominimap", "entity/icon/definition/" + id.method_12836() + "/" + id.method_12832() + ".json"));
            }
            catch (FileNotFoundException fnfe) {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                if (resource == null) continue;
                resourceInput = resource.method_14482();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(line -> {
                    stringBuilder.append((String)line);
                    stringBuilder.append('\n');
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                this.iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                System.out.println("Json syntax exception when loading the entity icon definition for " + id + ".");
                jse.printStackTrace();
            }
        }
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelRenderDetection(class_583<?> model, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelRenderDetection(model, red, green, blue, alpha);
    }

    public void onModelPartRenderDetection(class_630 modelRenderer, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }
}

