/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3882;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_895;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.LivingEntityRotationResetter;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.misc.Misc;

public class EntityIconPrerenderer {
    private static final class_630[] ONE_RENDERER_ARRAY = new class_630[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private ImprovedFramebuffer modelRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer iconScaleFramebuffer;
    private class_4587 matrixStack;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private LivingEntityRotationResetter livingEntityRotationResetter;
    private class_4597.class_4598 entityIconRenderTypeBuffer = class_4597.method_22991((class_287)new class_287(256));
    public static boolean DETECTING_MODEL_RENDERS;
    private class_897 modelRenderDetectionEntityRenderer;
    private Class<?> modelRenderDetectionEntityModelClass;
    private List<ModelRenderDetectionElement> modelRenderDetectionList;
    private ModelRenderDetectionElement lastModelRenderDetected;
    private class_4597.class_4598 modelRenderDetectionRenderTypeBuffer;
    private Field lastRenderTypeField;
    private Class<?> renderTypeTypeClass;
    private Field enderDragonModelField;
    private Field renderStateField;
    private Field renderStateTextureStateField;
    private Field renderStateTextureStateTextureField;
    private Field blendStateField;
    private Field colorMaskStateField;
    private Field depthStateField;
    private Field blendStateSrcFactorField;
    private Field blendStateDestFactorField;
    private Field blendStateAlphaSrcFactorField;
    private Field blendStateAlphaDestFactorField;
    private Field colorMaskStateRedField;
    private Field colorMaskStateGreenField;
    private Field colorMaskStateBlueField;
    private Field colorMaskStateAlphaField;
    private Field depthStateFuncField;
    private Field depthStateMaskField;
    private Field depthStateTestField;
    private Field booleanStateCurrentStateField;
    private Field cullStateField;
    private Field cullStateEnabledField;
    private Field cullStateModeField;

    public EntityIconPrerenderer() {
        this.modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.iconScaleFramebuffer = new ImprovedFramebuffer(64, 64, false);
        OpenGLException.checkGLError();
        class_4493.method_22079((int)this.iconScaleFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
        this.matrixStack = new class_4587();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.livingEntityRotationResetter = new LivingEntityRotationResetter();
        this.modelRenderFramebuffer.method_1241();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        class_4493.method_21954((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_1480, (int)this.modelRenderFramebuffer.field_1477, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        class_4493.method_22081((int)0);
        this.iconRenderFramebuffer.method_1241();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        class_4493.method_21954((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_1480, (int)this.iconRenderFramebuffer.field_1477, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        class_4493.method_22081((int)0);
        this.modelRenderDetectionList = new ArrayList<ModelRenderDetectionElement>();
        this.enderDragonModelField = Misc.getFieldReflection(class_895.class, "field_21008", "model");
        this.lastRenderTypeField = Misc.getFieldReflection(class_4597.class_4598.class, "field_20954", "c", "currentLayer");
        try {
            try {
                this.renderTypeTypeClass = Class.forName("net.minecraft.class_1921$class_4687");
            }
            catch (ClassNotFoundException e) {
                this.renderTypeTypeClass = Class.forName("net.minecraft.client.render.RenderLayer$MultiPhase");
            }
            this.renderStateField = Misc.getFieldReflection(this.renderTypeTypeClass, "field_21403", "phases");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.renderStateTextureStateField = Misc.getFieldReflection(class_1921.class_4688.class, "field_21406", "texture");
        this.renderStateTextureStateTextureField = Misc.getFieldReflection(class_4668.class_4683.class, "field_21397", "id");
        this.blendStateField = Misc.getFieldReflection(class_4493.class, "field_20472", "BLEND");
        this.colorMaskStateField = Misc.getFieldReflection(class_4493.class, "field_20486", "COLOR_MASK");
        this.depthStateField = Misc.getFieldReflection(class_4493.class, "field_20473", "DEPTH");
        this.cullStateField = Misc.getFieldReflection(class_4493.class, "field_20475", "CULL");
        try {
            Class<?> blendStateClass;
            try {
                blendStateClass = Class.forName("net.minecraft.class_4493$class_1017");
            }
            catch (ClassNotFoundException e) {
                blendStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$BlendFuncState");
            }
            this.blendStateSrcFactorField = Misc.getFieldReflection(blendStateClass, "field_5049", "srcFactorRGB");
            this.blendStateDestFactorField = Misc.getFieldReflection(blendStateClass, "field_5048", "dstFactorRGB");
            this.blendStateAlphaSrcFactorField = Misc.getFieldReflection(blendStateClass, "field_5047", "srcFactorAlpha");
            this.blendStateAlphaDestFactorField = Misc.getFieldReflection(blendStateClass, "field_5046", "dstFactorAlpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> colorMaskStateClass;
            try {
                colorMaskStateClass = Class.forName("net.minecraft.class_4493$class_1022");
            }
            catch (ClassNotFoundException e) {
                colorMaskStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$ColorMask");
            }
            this.colorMaskStateRedField = Misc.getFieldReflection(colorMaskStateClass, "field_5063", "red");
            this.colorMaskStateGreenField = Misc.getFieldReflection(colorMaskStateClass, "field_5062", "green");
            this.colorMaskStateBlueField = Misc.getFieldReflection(colorMaskStateClass, "field_5061", "blue");
            this.colorMaskStateAlphaField = Misc.getFieldReflection(colorMaskStateClass, "field_5060", "alpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> depthStateClass;
            try {
                depthStateClass = Class.forName("net.minecraft.class_4493$class_1026");
            }
            catch (ClassNotFoundException e) {
                depthStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$DepthTestState");
            }
            this.depthStateTestField = Misc.getFieldReflection(depthStateClass, "field_5074", "capState");
            this.depthStateFuncField = Misc.getFieldReflection(depthStateClass, "field_5075", "func");
            this.depthStateMaskField = Misc.getFieldReflection(depthStateClass, "field_5076", "mask");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> cullStateClass;
            try {
                cullStateClass = Class.forName("net.minecraft.class_4493$class_1025");
            }
            catch (ClassNotFoundException e) {
                cullStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$CullFaceState");
            }
            this.cullStateEnabledField = Misc.getFieldReflection(cullStateClass, "field_5072", "capState");
            this.cullStateModeField = Misc.getFieldReflection(cullStateClass, "field_5073", "mode");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> booleanStateClass;
            try {
                booleanStateClass = Class.forName("net.minecraft.class_4493$class_1018");
            }
            catch (ClassNotFoundException e) {
                booleanStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$CapabilityTracker");
            }
            this.booleanStateCurrentStateField = Misc.getFieldReflection(booleanStateClass, "field_5051", "state");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public int prerender(class_897 entityRenderer, class_1297 entity, class_276 defaultFramebuffer, MinimapRendererHelper helper, float scale, EntityIconModelConfig modelConfig, boolean debug) {
        class_1309 livingEntity;
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        ImprovedFramebuffer iconScaleFramebuffer = this.iconScaleFramebuffer;
        int finalIconSize = iconScaleFramebuffer.field_1480;
        OpenGLException.checkGLError();
        class_4587 matrixStack = this.matrixStack;
        modelRenderFramebuffer.method_1235(true);
        int farPlane = 500;
        this.setupMatrices(finalIconSize, farPlane);
        OpenGLException.checkGLError();
        DETECTING_MODEL_RENDERS = true;
        this.modelRenderDetectionEntityRenderer = entityRenderer;
        this.modelRenderDetectionEntityModelClass = null;
        this.modelRenderDetectionList.clear();
        this.lastModelRenderDetected = null;
        class_4493.method_22076();
        class_4597.class_4598 renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = this.entityIconRenderTypeBuffer;
        if (class_310.method_1551().method_1561().field_4686 != null) {
            class_4587.class_4665 matrixEntryToRestore = matrixStack.method_23760();
            matrixStack.method_22903();
            try {
                entityRenderer.method_3936(entity, 0.0f, 1.0f, matrixStack, (class_4597)renderTypeBuffer, 0xF000F0);
                renderTypeBuffer.method_22993();
                OpenGLException.checkGLError();
            }
            catch (Exception e) {
                this.modelRenderDetectionList.clear();
                System.out.println("Exception when calling the full entity renderer before rendering the icon. " + entity.method_5820());
                e.printStackTrace();
            }
            while (matrixStack.method_23760() != matrixEntryToRestore) {
                matrixStack.method_22909();
            }
            while (GL11.glGetError() != 0) {
            }
        } else {
            System.out.println("Render info was null for entity " + entity.method_5820());
        }
        DETECTING_MODEL_RENDERS = false;
        class_583 entityModel = this.getEntityRendererModel(entityRenderer);
        if (entityModel == null) {
            this.endModelRendering(modelRenderFramebuffer);
            defaultFramebuffer.method_1235(true);
            this.restoreMatrices(helper);
            return -1;
        }
        class_4493.method_22012();
        class_4493.method_22053();
        class_4493.method_21943((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        class_4493.method_21965((int)16640, (boolean)class_310.field_1703);
        class_4493.method_22056();
        class_4493.method_22050();
        class_4493.method_22076();
        class_4493.method_22001((int)515);
        class_308.method_24210();
        if (debug) {
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 10.0, -10.0);
            matrixStack.method_22905(1.0f, -1.0f, 1.0f);
            class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-65536);
            matrixStack.method_22909();
            class_4493.method_22056();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        class_4587.class_4665 matrixEntryToRestore = matrixStack.method_23760();
        matrixStack.method_22903();
        matrixStack.method_22904((double)(finalIconSize / 2), (double)(finalIconSize / 2), -450.0);
        matrixStack.method_22904((double)modelConfig.offsetX, (double)(-modelConfig.offsetY), 0.0);
        int mainScale = finalIconSize / 2;
        matrixStack.method_22905((float)mainScale, (float)(-mainScale), (float)(-mainScale));
        if (scale < 1.0f) {
            matrixStack.method_22905(scale, scale, scale);
        }
        matrixStack.method_22905(modelConfig.baseScale, modelConfig.baseScale, modelConfig.baseScale);
        EntityIconDefinitions.customTransformation(matrixStack, entityModel, entity, this);
        matrixStack.method_22907(class_1160.field_20705.method_23214(modelConfig.rotationY));
        matrixStack.method_22907(class_1160.field_20703.method_23214(modelConfig.rotationX));
        matrixStack.method_22907(class_1160.field_20707.method_23214(modelConfig.rotationZ));
        class_1309 class_13092 = livingEntity = entity instanceof class_1309 ? (class_1309)entity : null;
        if (livingEntity != null) {
            this.livingEntityRotationResetter.rememberAndResetValues(livingEntity);
        }
        boolean renderedSomething = this.renderIcon(matrixStack, renderTypeBuffer, entityRenderer, entityModel, this.modelRenderDetectionList, (class_1297)((class_1309)entity), modelConfig);
        if (livingEntity != null) {
            this.livingEntityRotationResetter.restore(livingEntity);
        }
        EntityIconDefinitions.customPostRenderTransformation(matrixStack, entityModel, entity);
        while (matrixStack.method_23760() != matrixEntryToRestore) {
            matrixStack.method_22909();
        }
        if (debug) {
            matrixStack.method_22903();
            matrixStack.method_22904(9.0, 10.0, -10.0);
            matrixStack.method_22905(1.0f, -1.0f, 1.0f);
            class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16711936);
            matrixStack.method_22909();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        this.endModelRendering(modelRenderFramebuffer);
        int entityScaledIconTextureId = -1;
        if (renderedSomething) {
            iconRenderFramebuffer.method_1235(true);
            class_4493.method_21943((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            class_4493.method_21965((int)16384, (boolean)class_310.field_1703);
            class_4493.method_22053();
            if (debug) {
                matrixStack.method_22903();
                matrixStack.method_22904(18.0, 10.0, -10.0);
                matrixStack.method_22905(1.0f, -1.0f, 1.0f);
                class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16776961);
                matrixStack.method_22909();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.method_1241();
            class_4493.method_22000((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                    if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                    helper.drawMyTexturedModalRect(shadowOffsetX, finalIconSize + shadowOffsetY, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
                }
            }
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                matrixStack.method_22903();
                matrixStack.method_22904(27.0, 10.0, -10.0);
                matrixStack.method_22905(1.0f, -1.0f, 1.0f);
                class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16711681);
                matrixStack.method_22909();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            class_4493.method_22056();
            iconRenderFramebuffer.method_1240();
            iconRenderFramebuffer.method_1241();
            iconRenderFramebuffer.generateMipmaps();
            class_4493.method_22081((int)0);
            entityScaledIconTextureId = class_4493.method_21914();
            OpenGLException.checkGLError();
            class_4493.method_22081((int)entityScaledIconTextureId);
            EntityIconPrerenderer.setupIconTextureParams();
            OpenGLException.checkGLError();
            class_4493.method_21954((int)3553, (int)0, (int)32856, (int)iconScaleFramebuffer.field_1480, (int)iconScaleFramebuffer.field_1477, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            class_4493.method_22081((int)0);
            OpenGLException.checkGLError();
            iconScaleFramebuffer.method_1235(true);
            iconScaleFramebuffer.setFramebufferTexture(entityScaledIconTextureId);
            iconScaleFramebuffer.method_1239();
            iconRenderFramebuffer.method_1241();
            class_4493.method_22012();
            class_4493.method_22053();
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                matrixStack.method_22903();
                matrixStack.method_22904(36.0, 10.0, -10.0);
                matrixStack.method_22905(1.0f, -1.0f, 1.0f);
                class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-256);
                matrixStack.method_22909();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            class_4493.method_22021();
            class_4493.method_22056();
            class_4493.method_22081((int)0);
        }
        this.restoreMatrices(helper);
        iconScaleFramebuffer.method_1240();
        defaultFramebuffer.method_1235(true);
        return entityScaledIconTextureId;
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        class_4493.method_21907((int)5889);
        class_4493.method_21924();
        class_4493.method_21939((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        class_4493.method_21907((int)5888);
        class_4493.method_21926();
        class_4493.method_21924();
    }

    private void restoreMatrices(MinimapRendererHelper helper) {
        class_4493.method_21928();
        class_4493.method_21907((int)5889);
        helper.defaultOrtho();
        class_4493.method_21907((int)5888);
    }

    private void endModelRendering(ImprovedFramebuffer modelRenderFramebuffer) {
        modelRenderFramebuffer.method_1240();
        class_4493.method_22056();
        class_308.method_24211();
        class_308.method_1450();
        class_4493.method_22021();
        class_4493.method_21945((int)516, (float)0.0f);
    }

    public static void setupIconTextureParams() {
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    private class_630 renderModel(class_4587 matrixStack, class_4597.class_4598 renderTypeBuffer, class_897 entityRenderer, class_583 entityModel, class_1297 entity, EntityIconModelConfig modelConfig, class_630 mainPart, ArrayList<class_630> renderedModels, class_2960 entityTexture, boolean forceFieldCheck, boolean fullModelIcon, ModelRenderDetectionElement mrde) {
        boolean isChildBU = entityModel.field_3448;
        entityModel.field_3448 = false;
        if (entityTexture != null) {
            class_4588 vertexBuilder = this.setupModelRenderType(renderTypeBuffer, entityTexture, mrde);
            if (modelConfig.modelMainPartFieldAliases != null && !modelConfig.modelMainPartFieldAliases.isEmpty()) {
                mainPart = this.searchSuperclassFields(vertexBuilder, entityModel, renderedModels, mainPart, modelConfig.modelMainPartFieldAliases, true, modelConfig.modelPartsRotationReset, mrde);
            }
            if (!forceFieldCheck && entityModel instanceof class_4592) {
                if (entityModel instanceof class_572) {
                    class_630 headRenderer = ((class_572)entityModel).field_3398;
                    if (mainPart == null) {
                        mainPart = headRenderer;
                    }
                    class_630 headWearRenderer = ((class_572)entityModel).field_3394;
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headWearRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelHeadPartsMethod, entityModel, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                if (fullModelIcon) {
                    mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelBodyPartsMethod, entityModel, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
            } else if (!forceFieldCheck && entityModel instanceof class_4595 && fullModelIcon) {
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.segmentedModelPartsMethod, entityModel, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
            } else {
                if (!forceFieldCheck && entityModel instanceof class_3882) {
                    if (mainPart == null) {
                        mainPart = ((class_3882)entityModel).method_2838();
                    }
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                if (modelConfig.modelPartsFields == null) {
                    mainPart = this.searchSuperclassFields(vertexBuilder, entityModel, renderedModels, mainPart, (List<String>)EntityIconDefinitions.HEAD_HARDCODED_NAMES, true, modelConfig.modelPartsRotationReset, mrde);
                }
                Object headPartsFields = EntityIconDefinitions.HEAD_PARTS_HARDCODED_NAMES;
                if (fullModelIcon) {
                    headPartsFields = null;
                } else if (modelConfig.modelPartsFields != null) {
                    headPartsFields = modelConfig.modelPartsFields;
                }
                mainPart = this.searchSuperclassFields(vertexBuilder, entityModel, renderedModels, mainPart, (List<String>)headPartsFields, false, modelConfig.modelPartsRotationReset, mrde);
            }
            renderTypeBuffer.method_22993();
        }
        entityModel.field_3448 = isChildBU;
        return mainPart;
    }

    private class_4588 setupModelRenderType(class_4597.class_4598 renderTypeBuffer, class_2960 entityTexture, ModelRenderDetectionElement mrde) {
        int blendAlphaSrcFactor = mrde.blendAlphaSrcFactor;
        int blendAlphaDestFactor = mrde.blendAlphaDestFactor;
        if (mrde.blendDestFactor == 1 && mrde.blendSrcFactor != 0) {
            blendAlphaSrcFactor = 0;
            blendAlphaDestFactor = 1;
        }
        CustomRenderTypes.setDynamicBlendFunc(mrde.blendSrcFactor, mrde.blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor);
        CustomRenderTypes.setDynamicWriteMask(mrde.depthMask, mrde.colorMaskR, mrde.colorMaskG, mrde.colorMaskB, mrde.colorMaskA);
        CustomRenderTypes.setDynamicCull(mrde.cullFace, mrde.cullMode);
        return renderTypeBuffer.getBuffer(CustomRenderTypes.entityIconRenderType(entityTexture, mrde.depthTest ? mrde.depthFunc : 519));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_630[] handleDeclaredField(Field f, class_583 entityModel, String matchedFilterElement) throws IllegalArgumentException, IllegalAccessException {
        boolean accessibleBU = f.isAccessible();
        try {
            f.setAccessible(true);
            Object fieldValue = f.get(entityModel);
            if (fieldValue instanceof class_630[] || fieldValue instanceof Collection) {
                class_630[] collectionArray = null;
                if (fieldValue instanceof class_630[]) {
                    collectionArray = (class_630[])fieldValue;
                } else if (fieldValue instanceof Collection) {
                    Collection collection = (Collection)fieldValue;
                    try {
                        collectionArray = collection.toArray(ONE_RENDERER_ARRAY);
                    }
                    catch (ArrayStoreException ase) {
                        throw new IllegalArgumentException("Field " + f.getName() + " is not a collection of model parts (ModelPart on fabric).", ase);
                    }
                }
                if (collectionArray.length > 0) {
                    if (matchedFilterElement != null && matchedFilterElement.endsWith("]")) {
                        int lastStartBracket = matchedFilterElement.lastIndexOf(91);
                        if (lastStartBracket == -1) {
                            throw new IllegalArgumentException("Model part field name " + matchedFilterElement + " ends with ] but is missing [!");
                        }
                        try {
                            String[] indicesString = matchedFilterElement.substring(lastStartBracket + 1, matchedFilterElement.length() - 1).split("[,;]");
                            class_630[] result = indicesString.length == 1 ? ONE_RENDERER_ARRAY : new class_630[indicesString.length];
                            for (int i = 0; i < indicesString.length; ++i) {
                                String indexString = indicesString[i];
                                int elementIndex = Integer.parseInt(indexString.trim());
                                result[i] = collectionArray[elementIndex];
                            }
                            class_630[] class_630Array = result;
                            return class_630Array;
                        }
                        catch (Exception nfe) {
                            throw new IllegalArgumentException("Invalid element index/indices in " + matchedFilterElement + "!", nfe);
                        }
                    }
                    class_630[] class_630Array = collectionArray;
                    return class_630Array;
                }
                throw new IllegalArgumentException("Empty collection referenced " + matchedFilterElement + "!");
            }
            EntityIconPrerenderer.ONE_RENDERER_ARRAY[0] = (class_630)fieldValue;
            class_630[] class_630Array = ONE_RENDERER_ARRAY;
            return class_630Array;
        }
        finally {
            f.setAccessible(accessibleBU);
        }
    }

    public class_630 searchSuperclassFields(class_4588 vertexBuilder, class_583 entityModel, ArrayList<class_630> renderedModels, class_630 mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Class<?> modelClass = entityModel.getClass();
        while (modelClass != class_583.class && modelClass != class_4592.class && modelClass != class_4595.class) {
            Field[] declaredModelFields = modelClass.getDeclaredFields();
            mainPart = this.handleFields(vertexBuilder, entityModel, declaredModelFields, renderedModels, mainPart, filter, justOne, zeroRotation, mrde);
            if ((!justOne || mainPart == null) && (modelClass = modelClass.getSuperclass()) != null) continue;
        }
        return mainPart;
    }

    public class_630 handleFields(class_4588 vertexBuilder, class_583 entityModel, Field[] declaredModelFields, ArrayList<class_630> renderedModels, class_630 mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        block9: for (Field f : declaredModelFields) {
            try {
                f.getType().asSubclass(class_630.class);
            }
            catch (ClassCastException cce) {
                try {
                    f.getType().asSubclass(class_630[].class);
                }
                catch (ClassCastException cce1) {
                    try {
                        f.getType().asSubclass(Collection.class);
                    }
                    catch (ClassCastException cce2) {
                        continue;
                    }
                }
            }
            try {
                class_630[] renderers;
                String comparisonName = f.getDeclaringClass().getName() + ";" + f.getName();
                String matchedFilterElement = null;
                if (filter != null && (matchedFilterElement = this.passesFilter(comparisonName, filter)) == null) continue;
                for (class_630 mr : renderers = EntityIconPrerenderer.handleDeclaredField(f, entityModel, matchedFilterElement)) {
                    if (mainPart == null) {
                        mainPart = mr;
                    }
                    this.entityModelPartsRenderer.renderPart(this.matrixStack, vertexBuilder, mr, renderedModels, mainPart, zeroRotation, mrde);
                    if (justOne) break block9;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return mainPart;
    }

    private String passesFilter(String entry, List<String> filter) {
        for (String f : filter) {
            if (f.equals(entry)) {
                return f;
            }
            int indexOfBracket = f.lastIndexOf(91);
            if (indexOfBracket == -1 || !f.substring(0, indexOfBracket).equals(entry)) continue;
            return f;
        }
        return null;
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }

    public void onModelRenderDetection(class_583<?> model, float red, float green, float blue, float alpha) {
        class_2960 texture;
        class_4668.class_4683 renderTextureState;
        class_1921.class_4688 renderState;
        if (this.modelRenderDetectionEntityModelClass == null) {
            class_583 currentMainModel = this.getEntityRendererModel(this.modelRenderDetectionEntityRenderer);
            Class<?> clazz = this.modelRenderDetectionEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
        }
        if (this.modelRenderDetectionEntityModelClass != model.getClass()) {
            return;
        }
        class_1921 lastRenderType = this.getLastRenderType((class_4597)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType != null && (renderState = this.getRenderState(lastRenderType)) != null && (renderTextureState = (class_4668.class_4683)Misc.getReflectFieldValue(renderState, this.renderStateTextureStateField)) != null && (texture = this.getRenderStateTextureStateTexture(renderTextureState)) != null) {
            lastRenderType.method_23516();
            Object BLEND = Misc.getReflectFieldValue(null, this.blendStateField);
            Object DEPTH = Misc.getReflectFieldValue(null, this.depthStateField);
            Object COLOR_MASK = Misc.getReflectFieldValue(null, this.colorMaskStateField);
            Object CULL = Misc.getReflectFieldValue(null, this.cullStateField);
            int blendSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateSrcFactorField);
            int blendDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateDestFactorField);
            int blendAlphaSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaSrcFactorField);
            int blendAlphaDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaDestFactorField);
            int depthFunc = (Integer)Misc.getReflectFieldValue(DEPTH, this.depthStateFuncField);
            boolean depthTest = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(DEPTH, this.depthStateTestField), this.booleanStateCurrentStateField);
            boolean depthMask = (Boolean)Misc.getReflectFieldValue(DEPTH, this.depthStateMaskField);
            boolean colorMaskR = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateRedField);
            boolean colorMaskG = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateGreenField);
            boolean colorMaskB = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateBlueField);
            boolean colorMaskA = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateAlphaField);
            boolean cullFace = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(CULL, this.cullStateEnabledField), this.booleanStateCurrentStateField);
            int cullMode = (Integer)Misc.getReflectFieldValue(CULL, this.cullStateModeField);
            lastRenderType.method_23518();
            this.lastModelRenderDetected = new ModelRenderDetectionElement(model, texture, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, red, green, blue, alpha, cullFace, cullMode);
            this.modelRenderDetectionList.add(this.lastModelRenderDetected);
        }
    }

    public void onModelPartRenderDetection(class_630 modelRenderer, float red, float green, float blue, float alpha) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private class_1921 getLastRenderType(class_4597 renderTypeBuffer) {
        if (renderTypeBuffer instanceof class_4597.class_4598) {
            Object lastRenderTypeObject = Misc.getReflectFieldValue(renderTypeBuffer, this.lastRenderTypeField);
            class_1921 lastRenderType = null;
            lastRenderType = lastRenderTypeObject instanceof Optional ? (class_1921)((Optional)lastRenderTypeObject).get() : (class_1921)lastRenderTypeObject;
            return lastRenderType;
        }
        return null;
    }

    private class_1921.class_4688 getRenderState(class_1921 renderType) {
        if (renderType.getClass() == this.renderTypeTypeClass) {
            class_1921.class_4688 renderState = (class_1921.class_4688)Misc.getReflectFieldValue(renderType, this.renderStateField);
            return renderState;
        }
        return null;
    }

    private class_2960 getRenderStateTextureStateTexture(class_4668.class_4683 textureState) {
        Object renderStateTextureObject = Misc.getReflectFieldValue(textureState, this.renderStateTextureStateTextureField);
        class_2960 renderStateTexture = null;
        renderStateTexture = renderStateTextureObject instanceof Optional ? (class_2960)((Optional)renderStateTextureObject).get() : (class_2960)renderStateTextureObject;
        return renderStateTexture;
    }

    private boolean renderIcon(class_4587 matrixStack, class_4597.class_4598 renderTypeBuffer, class_897 entityRenderer, class_583 mainEntityModel, List<ModelRenderDetectionElement> detectedModels, class_1297 entity, EntityIconModelConfig modelConfig) {
        EntityIconCustomRenderer entityIconCustomRenderer;
        boolean forceFieldCheck;
        boolean bl = forceFieldCheck = (modelConfig.renderingFullModel == null || modelConfig.renderingFullModel == false) && modelConfig.modelPartsFields != null;
        boolean fullModelIcon = modelConfig.renderingFullModel == null ? !forceFieldCheck && EntityIconDefinitions.fullModelIcon(mainEntityModel) : modelConfig.renderingFullModel;
        class_630 mainPart = null;
        boolean renderedSomething = false;
        ArrayList<class_630> mainRenderedModels = new ArrayList<class_630>();
        class_2960 mainEntityTexture = entityRenderer.method_3931(entity);
        if (detectedModels.isEmpty()) {
            detectedModels.add(new ModelRenderDetectionElement(mainEntityModel, mainEntityTexture, 770, 771, 1, 771, true, 515, true, true, true, true, true, 1.0f, 1.0f, 1.0f, 1.0f, false, 1029));
        }
        boolean allEmpty = true;
        for (ModelRenderDetectionElement modelRenderDetectionElement : detectedModels) {
            if (modelRenderDetectionElement.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderDetectionElement modelRenderDetectionElement : detectedModels) {
                modelRenderDetectionElement.allVisible = true;
            }
        }
        ModelRenderDetectionElement mainMrde = null;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            boolean mainPartsVisibility;
            if (mrde.isEmpty() || renderedSomething && !modelConfig.layersAllowed) continue;
            class_583<?> detectedModel = mrde.model;
            class_2960 detectedTexture = mrde.renderTexture;
            boolean mainModel = detectedModel == mainEntityModel;
            boolean bl2 = mainPartsVisibility = mainModel && mainMrde != null && mrde.sameVisibility(mainMrde);
            if (mainModel && !mainPartsVisibility) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                mainRenderedModels.clear();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, mainPart, mainRenderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde);
                mainMrde = mrde;
                renderedSomething = renderedSomething || !mainRenderedModels.isEmpty();
                continue;
            }
            if (!mainModel) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                ArrayList<class_630> renderedModels = new ArrayList<class_630>();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, mainPart, renderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde);
                renderedSomething = renderedSomething || !renderedModels.isEmpty();
                continue;
            }
            if (mainRenderedModels.isEmpty()) continue;
            class_4588 vertexBuilder = this.setupModelRenderType(renderTypeBuffer, detectedTexture, mrde);
            this.entityModelPartsRenderer.renderPartsIterable(mainRenderedModels, matrixStack, vertexBuilder, new ArrayList<class_630>(), mainPart, modelConfig.modelPartsRotationReset, mrde);
            renderTypeBuffer.method_22993();
        }
        if (!mainRenderedModels.isEmpty() && modelConfig.layersAllowed && (entityIconCustomRenderer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = entityIconCustomRenderer.render(matrixStack, renderTypeBuffer, entityRenderer, entity, mainEntityModel, this.entityModelPartsRenderer, mainRenderedModels, mainPart, modelConfig, mainMrde);
        }
        return renderedSomething;
    }

    private boolean resetModelRotations(class_1297 entity, class_583 model) {
        try {
            model.method_2816(entity, 0.0f, 0.0f, 1.0f);
            model.method_2819(entity, 0.0f, 0.0f, (float)entity.field_6012, 0.0f, 0.0f);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private class_583 getEntityRendererModel(class_897 entityRenderer) {
        if (entityRenderer instanceof class_922) {
            return ((class_922)entityRenderer).method_4038();
        }
        if (entityRenderer instanceof class_895) {
            return (class_583)Misc.getReflectFieldValue(entityRenderer, this.enderDragonModelField);
        }
        return null;
    }
}

