/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.configs.ConfigCategory;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.Commands;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.compat.Create;
import com.endertech.minecraft.mods.adpother.compat.ImmersivePetroleum;
import com.endertech.minecraft.mods.adpother.compat.ImmersiveVehicles;
import com.endertech.minecraft.mods.adpother.compat.Minecraft;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.emissions.PeriodicEntityEmission;
import com.endertech.minecraft.mods.adpother.events.AnvilEvents;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.init.Blocks;
import com.endertech.minecraft.mods.adpother.init.Breakables;
import com.endertech.minecraft.mods.adpother.init.Containers;
import com.endertech.minecraft.mods.adpother.init.Effects;
import com.endertech.minecraft.mods.adpother.init.Emitters;
import com.endertech.minecraft.mods.adpother.init.Entities;
import com.endertech.minecraft.mods.adpother.init.Fluids;
import com.endertech.minecraft.mods.adpother.init.Fuels;
import com.endertech.minecraft.mods.adpother.init.Impacts;
import com.endertech.minecraft.mods.adpother.init.Items;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.init.Tiles;
import com.endertech.minecraft.mods.adpother.init.Torches;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.items.VacuumTube;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.renderers.FilterFrameRenderer;
import com.endertech.minecraft.mods.adpother.renderers.FilterFrameScreen;
import com.endertech.minecraft.mods.adpother.renderers.GasRenderer;
import com.endertech.minecraft.mods.adpother.renderers.PurifiedAirRenderer;
import com.endertech.minecraft.mods.adpother.renderers.Smog;
import com.endertech.minecraft.mods.adpother.renderers.VacuumBagLayer;
import com.endertech.minecraft.mods.adpother.sources.BreakableBlock;
import com.endertech.minecraft.mods.adpother.sources.DroppedTorch;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adpother")
public class AdPother
extends AbstractForgeMod {
    public static final String ID = "adpother";
    public static final String NAME = "Pollution of the Realms";
    private static AdPother instance;
    public final Blocks blocks;
    public final Containers containers;
    public final Effects effects;
    public final Emitters emitters;
    public final Entities entities;
    public final Fluids fluids;
    public final Fuels fuels;
    public final Impacts impacts;
    public final Items items;
    public final Pollutants pollutants;
    public final Respirators respirators;
    public final Sources sources;
    public final Tiles tiles;
    public final Torches torches;
    public final Breakables breakables;

    public AdPother() {
        instance = this;
        this.pollutants = new Pollutants(this);
        this.blocks = new Blocks(this);
        this.containers = new Containers(this);
        this.items = new Items(this);
        this.effects = new Effects(this);
        this.emitters = new Emitters(this);
        this.entities = new Entities(this);
        this.fuels = new Fuels(this);
        this.fluids = new Fluids(this);
        this.impacts = new Impacts(this);
        this.respirators = new Respirators(this);
        this.sources = new Sources(this);
        this.tiles = new Tiles(this);
        this.torches = new Torches(this);
        this.breakables = new Breakables(this);
        this.mainConfigInit();
    }

    public static AdPother getInstance() {
        return instance;
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(VacuumTube.BlockSuckInMsg::new);
        this.registerNetMessage(VacuumTube.EntitySuckInMsg::new);
        this.registerNetMessage(EntityPollution.NetMsg::new);
        this.registerNetMessage(ImmersivePetroleum.FuelConsumedMsg::new);
    }

    public void commonPostInit() {
        WorldData.initBiomeConfigs();
        super.commonPostInit();
    }

    public void updateReloadedTags() {
        this.postInitRunnables.forEach(action -> action.run());
        super.updateReloadedTags();
    }

    public void mainConfigInit() {
        UnitConfig config = UnitConfig.in((Path)this.getConfigsDir(), (String)this.getId());
        String category = "Client";
        Smog.renderSmog = config.getBool("Client", "renderSmog", true, "Defines whether the smog from pollution should be rendered for the player.");
        Smog.colorSmog = config.getBool("Client", "colorSmog", true, "Defines whether the smog should be colored.");
        category = "Server";
        Emission.globalRate = this.defineRate(config, "Server", "globalEmissionRate", 100, "Global rate of emissions for all pollutants and sources on the server.");
        AnvilEvents.filterReplacingExpGain = config.getInt("Server", "filterReplacingExpGain", 0, IntBounds.between((Integer)-10, (Integer)10), "Experience gain after replacing the filter material in a respirator or a vacuum bag.");
        WorldData.altitudeBounds = config.getIntBounds("Server", "Altitude", GameBounds.HEIGHT.getIntBounds(), IntBounds.INTEGER, "Altitude bounds pollution can act within.");
        GasExplosion.maxChainLength = config.getInt("Server", "maxExplosionChainLength", 512, IntBounds.between((Integer)0, (Integer)2048), "Maximum gas blocks that can be involved in an explosive chain reaction.");
        String sub_category = ConfigCategory.name().join(new String[]{"Server", "Emission Sources"});
        String switch_comment = "Enables / disables emissions from this source.";
        String rate_comment = "Defines the rate of emissions from this source (in percents).";
        BreakableBlock.rate = this.defineRate(config, sub_category, "Breakables", 100, rate_comment);
        PeriodicEntityEmission.rate = this.defineRate(config, sub_category, "Entities", 100, rate_comment);
        Torch.rate = this.defineRate(config, sub_category, "WallTorches", 0, rate_comment);
        DroppedTorch.rate = this.defineRate(config, sub_category, "DroppedTorches", 0, rate_comment);
        Minecraft.Campfire.rate = this.defineRate(config, sub_category, "VanillaCampfires", 0, rate_comment);
        WorldEvents.furnaceEmissions = config.getBool(sub_category, "VanillaFurnaces", true, switch_comment);
        WorldEvents.burntBlockEmissions = config.getBool(sub_category, "BurntBlocks", true, switch_comment);
        WorldEvents.burntItemEmissionRate = this.defineRate(config, sub_category, "BurntItems", 100, rate_comment);
        for (SourceBase src : this.sources.getAll()) {
            boolean enabled = config.getBool(sub_category, ((Object)((Object)src)).getClass().getSimpleName(), true, switch_comment);
            src.setEnabled(enabled);
        }
        ImmersiveVehicles.rate = this.defineRate(config, sub_category, "ImmersiveVehicles(MTS)", 100, rate_comment);
        Create.inWorldProcessingEmissions = config.getBool(sub_category, "CreateInWorldProcessing", true, switch_comment);
        config.save();
    }

    private float defineRate(UnitConfig config, String category, String key, int defaultValue, String comment) {
        return config.getPercentage(category, key, Percentage.value((float)defaultValue), FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1000.0f)), comment).toFraction();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        this.pollutants.getAll().stream().filter(pollutant -> pollutant instanceof AbstractGas).forEach(pollutant -> this.setRenderLayer((Block)pollutant, RenderType.m_110466_()));
        for (Materials material : Materials.values()) {
            this.setRenderLayer((Block)material.filterFrame, RenderType.m_110466_());
        }
        this.setRenderLayer((Block)this.blocks.pollutedWater, RenderType.m_110466_());
        this.setRenderLayer((Fluid)this.fluids.pollutedWaterFlowing, RenderType.m_110466_());
        this.setRenderLayer((Fluid)this.fluids.pollutedWaterStill, RenderType.m_110466_());
        this.registerContainerScreen(this.containers.filterFrame, FilterFrameScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientAddRenderLayers() {
        this.addPlayerRenderLayer(VacuumBagLayer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterRenderers() {
        this.registerEntityRender(this.entities.gas, GasRenderer::new);
        this.registerEntityRender(this.entities.purifiedAir, PurifiedAirRenderer::new);
        this.registerTileRenderer(this.tiles.filterFrame, FilterFrameRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
        props.register((Item)this.items.aerometer, "state", (stack, world, entity) -> {
            if (ForgeItem.isBroken((ItemStack)stack)) {
                return -1.0f;
            }
            Optional<Entity> carrier = Aerometer.getCarrierFor(stack);
            if (carrier.isPresent()) {
                EntityPollution pollution = WorldData.getEntityPollution(carrier.get());
                return pollution.getDominantPollutant(pollutant -> true).map(pollution::getInfluenceOf).map(influence -> Float.valueOf((float)influence.getGrade().ordinal() + 1.0f)).orElse(Float.valueOf(0.0f)).floatValue();
            }
            return 0.0f;
        });
    }

    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        registry.replaceModelOf((Item)this.items.aerometer, ItemModel.BuiltIn::new);
    }

    protected void serverStarting(MinecraftServer server) {
    }

    public void registerCommands(ServerCommand command) {
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("list").executes(Commands::listBreakables, "breakables").executes(Commands::listEmitters, "emitters").executes(Commands::listFuels, "fuels").executes(Commands::listTorches, "torches");
        command.task("gen").executes(Commands::generate, new ServerCommand.Arg[]{Commands.pollutantArg(), ServerCommand.Arg.integer((String)"amount", (IntBounds)GameBounds.POLLUTION.getIntBounds())});
        command.task("identify").executes(Commands::identifyFuel, "fuel").executes(Commands::identifyEmitter, "emitter").executes(Commands::identifyBlock, "block").executes(Commands::identifyFluid, "fluid").executes(Commands::identifyItem, "item").executes(Commands::identifyEntity, "entity").executes(Commands::identifyTile, "tile");
        command.task("clean").executes(Commands::cleanChunk, "chunk").executes(Commands::cleanChunksAround, "around");
        command.task("emit").executes(Commands::emitAt, new ServerCommand.Arg[]{Commands.pollutantArg(), ServerCommand.Arg.integer((String)"quantity", (IntBounds)IntBounds.between((Integer)0, (Integer)16))});
        command.task("impact").executes(Commands::testImpact, new ServerCommand.Arg[]{Commands.pollutantArg(), Commands.impactTypeArg()});
        command.task("logging").executes(Commands::loggingFuelConsumption, "fuel");
        command.task("recalc").executes(Commands::recalcPollutionAtChunk, "chunk").executes(Commands::recalcPollutionAround, "around");
        command.task("reload").executes(Commands::reloadBreakables, "breakables").executes(Commands::reloadEmitters, "emitters").executes(Commands::reloadFuels, "fuels").executes(Commands::reloadImpacts, "impacts").executes(Commands::reloadSources, "sources").executes(Commands::reloadTorches, "torches").executes(Commands::reloadMainConfig, "main");
        command.task("stats").executes(Commands::chunkStats, "chunk").executes(Commands::worldStats, "world");
        command.task("tag").executes(Commands::testTag, new ServerCommand.Arg[]{ServerCommand.Arg.of((String)"tag", (ArgumentType)StringArgumentType.greedyString())});
        command.task("tick").executes(Commands::tickBlock, "block").executes(Commands::tickFluid, "fluid");
        command.register();
    }
}

