/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.config.BlockImpactList;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import com.endertech.minecraft.mods.adpother.impacts.EnvironmentalImpacts;
import com.endertech.minecraft.mods.adpother.init.Fuels;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.Generator;
import com.endertech.minecraft.mods.adpother.pollution.Stats;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class Commands {
    static ServerCommand.Arg<String> pollutantArg() {
        return ServerCommand.Arg.word((String)"pollutant", (context, builder) -> SharedSuggestionProvider.m_82981_(AdPother.getInstance().pollutants.getAll().stream().map(pollutant -> pollutant.getRegistryName().m_135815_()), (SuggestionsBuilder)builder));
    }

    static ServerCommand.Arg<String> impactTypeArg() {
        return ServerCommand.Arg.word((String)"type", (context, builder) -> SharedSuggestionProvider.m_82981_(Stream.of(AbstractImpacts.ImpactType.values()).map(IForgeEnum::getName), (SuggestionsBuilder)builder));
    }

    public static void chunkStats(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPollution pollution = WorldData.getChunkPollution((Level)world, context.getBlockPos());
        BiomeId biome = BiomeId.from((LevelAccessor)world, (BlockPos)context.getBlockPos());
        for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
            context.sendMessage(pollution.getOrCreateInfoFor(pollutant).toChatString(biome));
        }
    }

    public static void worldStats(ServerCommand.Context context) {
        Stats stats = WorldData.getData((Level)context.getLevel()).getStats(ChatFormatting.DARK_AQUA, ChatFormatting.YELLOW);
        for (String string : stats.toList()) {
            context.sendMessage(string);
        }
        context.sendMessage("");
    }

    public static void testTag(ServerCommand.Context context) {
        UnitId id = UnitId.from((String)((String)context.getArgument("tag", String.class)));
        ResourceLocation loc = id.toResLoc();
        Optional.ofNullable(ItemTags.m_13193_().m_13404_(loc)).map(Tag::m_6497_).ifPresent(list -> context.sendMessage("Items: " + list));
        Optional.ofNullable(FluidTags.m_144299_().m_13404_(loc)).map(Tag::m_6497_).ifPresent(list -> context.sendMessage("Fluids: " + list.stream().map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toList())));
    }

    public static void loggingFuelConsumption(ServerCommand.Context context) {
        boolean newValue;
        WorldEvents.loggingFuelConsumption = newValue = !WorldEvents.loggingFuelConsumption;
        context.sendMessage("loggingFuelConsumption=" + ServerCommand.Msg.bool((boolean)newValue));
    }

    public static void listBreakables(ServerCommand.Context context) {
        Commands.logListOf("Breakables", AdPother.getInstance().breakables.getAll(), context);
    }

    public static void listEmitters(ServerCommand.Context context) {
        Commands.logListOf("Emitters", AdPother.getInstance().emitters.getAll(), context);
    }

    public static void listFuels(ServerCommand.Context context) {
        Commands.logListOf("Fuels", AdPother.getInstance().fuels.getAll(), context);
    }

    public static void listTorches(ServerCommand.Context context) {
        Commands.logListOf("Torches", AdPother.getInstance().torches.getAll(), context);
    }

    private static <O> void logListOf(String title, Collection<O> list, ServerCommand.Context context) {
        Logger logger = AdPother.getInstance().getLogger();
        logger.debug(title + "[" + list.size() + "]: {");
        list.forEach(arg_0 -> ((Logger)logger).info(arg_0));
        logger.debug("}");
        context.sendMessage("List of all " + title.toLowerCase() + " was written to .minecraft/logs/debug.log");
    }

    public static void generate(ServerCommand.Context context) {
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        if (pollutant == null) {
            return;
        }
        ServerLevel level = context.getLevel();
        ChunkPollution pollution = WorldData.getChunkPollution((Level)level, context.getBlockPos());
        int amount = (Integer)context.getArgument("amount", Integer.TYPE);
        int count = Generator.generate((Level)level, (WorldBounds)pollution.getLocation().getBounds((LevelHeightAccessor)level), pollutant, amount);
        context.sendMessage("Added " + count + " units of " + Commands.msgPollutant(pollutant));
    }

    public static void cleanChunk(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPos pos = new ChunkPos(context.getBlockPos());
        WorldData.getChunkPollution((Level)world, ChunkLoc.from((Level)world, (ChunkPos)pos)).clean(world);
        context.sendMessage("Chunk at " + pos + " cleaned of all pollution");
    }

    public static void cleanChunksAround(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        for (ChunkPos pos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            WorldData.getChunkPollution((Level)world, ChunkLoc.from((Level)world, (ChunkPos)pos)).clean(world);
        }
        context.sendMessage("Chunks around " + centerPos + " cleaned of all pollution");
    }

    public static void recalcPollutionAtChunk(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPos pos = new ChunkPos(context.getBlockPos());
        WorldData.getChunkPollution((Level)world, ChunkLoc.from((Level)world, (ChunkPos)pos)).recalculate((Level)world);
        context.sendMessage("Pollution at chunk " + pos + " recalculated");
    }

    public static void recalcPollutionAround(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        for (ChunkPos pos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            WorldData.getChunkPollution((Level)world, ChunkLoc.from((Level)world, (ChunkPos)pos)).recalculate((Level)world);
        }
        context.sendMessage("Pollution around " + centerPos + " recalculated");
    }

    public static void testImpact(ServerCommand.Context context) {
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        AbstractImpacts.ImpactType type = Commands.getImpactType(context).orElse(null);
        if (pollutant == null || type == null) {
            return;
        }
        ServerLevel world = context.getLevel();
        BlockHitResult result = context.rayTraceBlockBeingLookedAt(true).orElse(null);
        if (result == null) {
            return;
        }
        BlockPos pos = result.m_82425_();
        BlockState state = world.m_8055_(pos);
        Optional<Direction> side = Optional.of(result.m_82434_());
        EnvironmentalImpacts impacts = AdPother.getInstance().impacts.environmentalImpacts;
        context.sendMessage(ServerCommand.Msg.unit((String)"Target block", (ChatFormatting)ChatFormatting.GREEN, (UnitId)UnitId.from((BlockState)state)) + (String)(state.m_60734_() instanceof BonemealableBlock ? ", type: " + ServerCommand.Msg.colored((String)"growable", (ChatFormatting)ChatFormatting.AQUA) : ""));
        context.sendMessage(Commands.msgPollutant(pollutant) + " impact(" + Args.join((Object[])Arrays.stream(AbstractImpacts.ImpactType.values()).map(impact -> impact.getName() + ": " + Commands.msgAction(impacts.getActionFor(state, pollutant, (AbstractImpacts.ImpactType)((Object)impact)))).toArray()) + ")");
        context.sendMessage(Commands.msgPollutant(pollutant) + " canPassThrough(from " + side.get() + " to " + side.get().m_122424_() + "): " + ServerCommand.Msg.bool((boolean)pollutant.canPassThrough((LevelReader)world, pos, side.get(), side.get().m_122424_())));
        pollutant.tryAffectBlockAt(world, pos, side, type, pollutant.m_49966_());
    }

    public static void emitAt(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        BlockHitResult result = context.rayTraceBlockBeingLookedAt(true).orElse(null);
        if (result == null) {
            return;
        }
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        if (pollutant == null) {
            return;
        }
        BlockPos pos = result.m_82425_();
        BlockEntity tile = world.m_7702_(pos);
        BlockState state = world.m_8055_(pos);
        int quantity = (Integer)context.getArgument("quantity", Integer.TYPE);
        if (tile != null) {
            Set<BlockState> relatedBlocks = AdPother.getInstance().emitters.get(state).map(Emitter::getRelatedBlocks).orElse(Collections.emptySet());
            pollutant.emitFrom(tile, relatedBlocks, quantity);
        } else {
            pollutant.generateAt((Level)world, pos, quantity, 1);
        }
    }

    public static void identifyEmitter(ServerCommand.Context context) {
        Entity entity;
        Emitter emitter;
        Optional info = context.getTargetEntityInfo(false, false, Optional.empty());
        if (info.isPresent() && (emitter = (Emitter)AdPother.getInstance().emitters.get(entity = (Entity)((Pair)info.get()).getKey()).orElse(null)) != null) {
            context.sendMessage(ServerCommand.Msg.emitter((String)((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), (IEmitter)emitter, (boolean)emitter.isActive((INBTSerializable<CompoundTag>)entity)));
            return;
        }
        info = context.getTargetBlockInfo(false);
        if (info.isPresent()) {
            BlockPos pos;
            ServerLevel world = context.getLevel();
            Emitter emitter2 = AdPother.getInstance().emitters.get((LevelReader)world, pos = (BlockPos)((Pair)info.get()).getKey()).orElse(null);
            if (emitter2 != null) {
                context.sendMessage(ServerCommand.Msg.emitter((String)((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), (IEmitter)emitter2, (boolean)emitter2.isActive((LevelReader)world, pos)));
                return;
            }
            Torch torch = AdPother.getInstance().torches.get((LevelReader)world, pos).orElse(null);
            if (torch != null) {
                context.sendMessage(ServerCommand.Msg.emitter((String)((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), (IEmitter)torch, (boolean)torch.isActive((LevelReader)world, pos)));
                return;
            }
        }
        context.sendMessage(ServerCommand.Msg.error((String)"No emitter found"));
    }

    private static ServerCommand.Msg msgFuel(String name, Fuel fuel) {
        return ServerCommand.Msg.of((String)(name + " is " + ServerCommand.Msg.colored((String)fuel.toString(), (ChatFormatting)ChatFormatting.YELLOW)));
    }

    private static ServerCommand.Msg msgAction(Optional<BlockImpactList.AbstractAction> action) {
        if (action.isPresent()) {
            BlockImpactList.ActionType type = action.get().type;
            Percentage threshold = action.get().threshold;
            return ServerCommand.Msg.of((String)((String)(threshold.isGreaterThan((Object)Percentage.ZERO) ? threshold.toColoredText() + " -> " : "") + ServerCommand.Msg.colored((String)type.toString(), (ChatFormatting)type.textColor)));
        }
        return ServerCommand.Msg.colored((String)"NONE", (ChatFormatting)ChatFormatting.GRAY);
    }

    public static void identifyFuel(ServerCommand.Context context) {
        BlockState blockstate;
        BlockPos pos;
        FluidState fluidstate;
        Fuel fuel;
        ServerLevel world = context.getLevel();
        Fuels fuels = AdPother.getInstance().fuels;
        Optional info = context.getTargetFluidInfo(false);
        if (info.isPresent() && (fuel = (Fuel)fuels.get((fluidstate = world.m_6425_(pos = (BlockPos)((Pair)info.get()).getKey())).m_76152_()).orElse(null)) != null) {
            context.sendMessage(Commands.msgFuel(((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), fuel));
            return;
        }
        info = context.getTargetBlockInfo(false);
        if (info.isPresent() && (fuel = (Fuel)fuels.get(blockstate = world.m_8055_(pos = (BlockPos)((Pair)info.get()).getKey())).orElse(null)) != null) {
            context.sendMessage(Commands.msgFuel(((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), fuel));
            return;
        }
        info = context.getHeldItemInfo(InteractionHand.MAIN_HAND, false);
        if (info.isPresent()) {
            Fluid fluid;
            Item item = (Item)((Pair)info.get()).getKey();
            Fuel fuel2 = fuels.get(item).orElse(null);
            if (fuel2 != null) {
                context.sendMessage(Commands.msgFuel(((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), fuel2));
                return;
            }
            if (item instanceof BucketItem && (fuel2 = (Fuel)fuels.get(fluid = ((BucketItem)item).getFluid()).orElse(null)) != null) {
                context.sendMessage(Commands.msgFuel(((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), fuel2));
                return;
            }
        }
        context.sendMessage(ServerCommand.Msg.error((String)"No fuel found"));
    }

    public static void identifyBlock(ServerCommand.Context context) {
        context.getTargetBlockInfo(true).ifPresent(info -> context.sendMessage((ServerCommand.Msg)info.getValue()));
    }

    public static void identifyTile(ServerCommand.Context context) {
        context.getTargetTileInfo(IEmitter.COMMON_ACTIVE_TAG_NAME, true).ifPresent(info -> context.sendMessage((ServerCommand.Msg)info.getValue()));
    }

    public static void identifyEntity(ServerCommand.Context context) {
        context.getTargetEntityInfo(true, true, Optional.of(IEmitter.COMMON_ACTIVE_TAG_NAME)).ifPresent(info -> context.sendMessage((ServerCommand.Msg)info.getValue()));
    }

    public static void identifyFluid(ServerCommand.Context context) {
        Item item;
        Optional info = context.getTargetFluidInfo(false);
        if (info.isPresent()) {
            context.sendMessage((ServerCommand.Msg)((Pair)info.get()).getValue());
            return;
        }
        info = context.getHeldItemInfo(InteractionHand.MAIN_HAND, false);
        if (info.isPresent() && (item = (Item)((Pair)info.get()).getKey()) instanceof BucketItem) {
            Fluid fluid = ((BucketItem)item).getFluid();
            context.sendMessage(((Pair)info.get()).getValue() + " contains " + ServerCommand.Msg.colored((String)UnitId.from((Fluid)fluid, (String)"").toString(), (ChatFormatting)ChatFormatting.AQUA) + " with tags:" + ServerCommand.Msg.colored((String)fluid.getTags().toString(), (ChatFormatting)ChatFormatting.DARK_AQUA));
            return;
        }
        context.sendMessage(ServerCommand.Msg.error((String)"No fluid found"));
    }

    public static void identifyItem(ServerCommand.Context context) {
        Optional info = context.getHeldItemInfo(InteractionHand.MAIN_HAND, true);
        if (info.isPresent()) {
            int burnTime = ForgeHooks.getBurnTime((ItemStack)new ItemStack((ItemLike)((Pair)info.get()).getKey()), null);
            context.sendMessage(Args.join((Object[])new Object[]{((Pair)info.get()).getValue(), ServerCommand.Msg.colored((String)("burnTime: " + burnTime), (ChatFormatting)ChatFormatting.DARK_AQUA), ServerCommand.Msg.colored((String)((double)burnTime / 1600.0 + " of 1xcoal"), (ChatFormatting)ChatFormatting.GRAY)}));
        }
    }

    public static void reloadBreakables(ServerCommand.Context context) {
        AdPother.getInstance().breakables.reloadConfigs();
        context.sendMessage("Configs for breakables reloaded");
    }

    public static void reloadEmitters(ServerCommand.Context context) {
        WorldData.getData((Level)context.getLevel()).reloadEmitters();
        context.sendMessage("Configs for emitters reloaded");
    }

    public static void reloadFuels(ServerCommand.Context context) {
        AdPother.getInstance().fuels.reloadConfigs();
        context.sendMessage("Configs for fuels reloaded");
    }

    public static void reloadImpacts(ServerCommand.Context context) {
        AdPother.getInstance().impacts.reloadConfigs();
        context.sendMessage("Configs for impacts reloaded");
    }

    public static void reloadSources(ServerCommand.Context context) {
        AdPother.getInstance().sources.reloadConfigs();
        context.sendMessage("Configs for sources reloaded");
    }

    public static void reloadTorches(ServerCommand.Context context) {
        WorldData.getData((Level)context.getLevel()).reloadTorches();
        context.sendMessage("Configs for torches reloaded");
    }

    public static void reloadMainConfig(ServerCommand.Context context) {
        AdPother.getInstance().mainConfigInit();
        context.sendMessage("Main config reloaded");
    }

    public static void tickBlock(ServerCommand.Context context) {
        Optional info = context.getTargetBlockInfo(true);
        if (info.isPresent()) {
            ServerLevel world = context.getLevel();
            BlockPos pos = (BlockPos)((Pair)info.get()).getKey();
            BlockState state = world.m_8055_(pos);
            state.m_60735_(world, pos, world.f_46441_);
            context.sendMessage(((Pair)info.get()).getValue() + " randomTick() at " + pos);
        }
    }

    public static void tickFluid(ServerCommand.Context context) {
        Optional info = context.getTargetFluidInfo(true);
        if (info.isPresent()) {
            ServerLevel world = context.getLevel();
            BlockPos pos = (BlockPos)((Pair)info.get()).getKey();
            FluidState state = world.m_6425_(pos);
            state.m_76174_((Level)world, pos, world.f_46441_);
            context.sendMessage(((Pair)info.get()).getValue() + " randomTick() at " + pos);
        }
    }

    private static Optional<Pollutant<?>> getPollutantByName(ServerCommand.Context context) {
        String name = (String)context.getArgument("pollutant", String.class);
        Optional<Pollutant<?>> pollutant = AdPother.getInstance().pollutants.findBy(name);
        if (pollutant.isEmpty()) {
            context.sendMessage(ServerCommand.Msg.error((String)"Pollutant with specified name not found!"));
        }
        return pollutant;
    }

    private static Optional<AbstractImpacts.ImpactType> getImpactType(ServerCommand.Context context) {
        String name = (String)context.getArgument("type", String.class);
        for (AbstractImpacts.ImpactType type2 : AbstractImpacts.ImpactType.values()) {
            if (!type2.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(type2);
        }
        context.sendMessage(ServerCommand.Msg.error((String)("Incorrect impact type! Valid values: " + Args.join((Object[])Arrays.stream(AbstractImpacts.ImpactType.values()).map(type -> type.getName()).toArray()))));
        return Optional.empty();
    }

    private static ServerCommand.Msg msgPollutant(Pollutant<?> pollutant) {
        return ServerCommand.Msg.colored((String)pollutant.getRegistryName().m_135815_(), (ChatFormatting)pollutant.getTextColor());
    }
}

