/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class Minecraft {
    public static final void handleItemEntityDamage(ItemEntity entity, DamageSource source) {
        if (source == DamageSource.f_19308_ || source == DamageSource.f_19305_ || source == DamageSource.f_19307_ || source == DamageSource.f_19323_) {
            Level world = entity.f_19853_;
            BlockPos pos = entity.m_142538_();
            ItemStack stack = entity.m_32055_();
            if (stack.m_41720_() == Items.f_42448_) {
                return;
            }
            if (world.m_6425_(pos).m_76153_((Tag)FluidTags.f_13132_)) {
                pos = pos.m_7494_();
            }
            WorldEvents.onItemBurned(stack, world, pos);
        }
    }

    public static class Campfire
    extends Emitter {
        public static float rate = 1.0f;

        public Campfire(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        public void emitAt(Level level, BlockPos pos) {
            this.emitAt(level, pos, rate);
        }
    }

    public static class Fire
    extends Emitter {
        private final boolean infiniteSourceOnly;

        public Fire(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
            this.infiniteSourceOnly = UnitConfig.getBool((UnitConfig)config, (String)this.getClassCategory(), (String)"infiniteSourceOnly", (boolean)false, (String)"Produce emissions only from a burning infinite source such as netherrack, magma block, etc.");
            this.saveConfig();
        }

        public boolean infiniteSourceOnly() {
            return this.infiniteSourceOnly;
        }

        public boolean isActive(LevelReader world, BlockPos pos) {
            BlockPos sourcePos;
            BlockState state;
            Block block;
            boolean infiniteSource;
            if (this.infiniteSourceOnly() && !(infiniteSource = (block = (state = world.m_8055_(sourcePos = pos.m_7495_())).m_60734_()).isFireSource(state, world, sourcePos, Direction.UP))) {
                return false;
            }
            return super.isActive(world, pos);
        }
    }
}

