/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.AbstractCarrier;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import com.endertech.minecraft.mods.adpother.pollution.CarrierSpawnLimiter;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class GasEntity
extends AbstractCarrier {
    static final long maxExistence = GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.minutes((double)5.0));
    protected final GameTime stuckUpdateInterval = GameTime.seconds((int)3);
    protected static final EntityDataAccessor<Boolean> STUCK = SynchedEntityData.m_135353_(GasEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GasEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public GasEntity(Level world, BlockPos pos, BlockState carriedState) {
        super(AdPother.getInstance().entities.gas, world, pos, carriedState);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STUCK, (Object)false);
        super.m_8097_();
    }

    public boolean isStuck() {
        return (Boolean)this.m_20088_().m_135370_(STUCK);
    }

    public void setStuck(boolean value) {
        boolean old;
        if (this.isServerSide() && this.m_6084_() && value != (old = this.isStuck())) {
            CarrierSpawnLimiter<GasEntity> limiter = WorldData.getData(this.f_19853_).getGasCarrierLimiter();
            if (value) {
                limiter.remove(this);
            } else {
                limiter.add(this);
            }
        }
        this.m_20088_().m_135381_(STUCK, (Object)value);
    }

    public boolean m_6128_() {
        return true;
    }

    public void m_6075_() {
        BlockPos pos;
        Spread spread;
        boolean alignedToBlock;
        ServerLevel serverLevel;
        BlockState newState;
        if (!this.m_6084_()) {
            return;
        }
        if (this.isServerSide() && this.isStuck() && !this.stuckUpdateInterval.pastIn(this.f_19853_)) {
            return;
        }
        if (this.isClientSide() && this.isStuck()) {
            return;
        }
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)level;
            serverLevel2.m_8886_();
            if (!serverLevel2.m_143340_(this.m_142538_())) {
                return;
            }
        }
        BlockState carriedState = this.getCarriedBlockState().orElse(null);
        Pollutant pollutant = this.getPollutant().orElse(null);
        if (carriedState == null || pollutant == null || pollutant == Blocks.f_50016_ || pollutant.getCarriedPollutionAmount(carriedState) <= 0 || this.f_19853_.m_151570_(this.m_142538_())) {
            if (this.isServerSide()) {
                this.m_146870_();
            }
            return;
        }
        if (this.isStuck() && this.isServerSide() && (long)this.f_19797_ > maxExistence && !GameWorld.SmokeContainers.isChimney((LevelReader)this.f_19853_, (BlockPos)this.m_142538_())) {
            ItemStack stack = new ItemStack((ItemLike)pollutant, pollutant.getCarriedPollutionAmount(carriedState));
            if (this.m_19983_(stack) != null) {
                this.m_146870_();
            }
            return;
        }
        Level level2 = this.f_19853_;
        if (level2 instanceof ServerLevel && (newState = pollutant.tryAffectBlockAt(serverLevel = (ServerLevel)level2, this.m_142538_(), Optional.empty(), AbstractImpacts.ImpactType.CONTACT, carriedState)) != carriedState) {
            this.setCarriedBlockState(Optional.of(newState));
            return;
        }
        Optional<Direction> motionFacing = pollutant.getMotionFacing(this.f_19853_, this.m_142538_());
        double motionY = 0.0;
        if (motionFacing.isPresent()) {
            float velocity = pollutant.getMotionVelocityIn(BiomeId.from((LevelAccessor)this.f_19853_, (BlockPos)this.m_142538_()));
            motionY = motionFacing.get() != Direction.DOWN ? (double)velocity : (double)(-velocity);
        }
        this.m_20334_(0.0, motionY, 0.0);
        AABB nextBB = this.getBB(this.getNextPosition());
        BlockPos movePos = new BlockPos(this.m_20185_(), this.m_20184_().f_82480_ < 0.0 ? nextBB.f_82289_ : nextBB.f_82292_, this.m_20189_());
        boolean canPassThrough = motionFacing.isPresent() && pollutant.canPassThrough((LevelReader)this.f_19853_, movePos, motionFacing.get().m_122424_(), motionFacing.get());
        boolean entityCollided = false;
        if (canPassThrough) {
            this.setStuck(false);
            boolean blockSize = true;
            double motionSign = Math.signum(this.m_20184_().f_82480_);
            List collidedEntities = this.getCollidedEntitiesIfMove(GasEntity.getMotion((Entity)this));
            for (Entity entity : collidedEntities) {
                if (!(entity instanceof GasEntity)) continue;
                GasEntity otherGas = (GasEntity)entity;
                if (this.isServerSide() && this.spreadTo(otherGas, 0) && this.spend()) {
                    return;
                }
                if (this.isServerSide() && this.m_20184_().f_82480_ > entity.m_20184_().f_82480_ && !otherGas.carriesSameBlock(this.getPollutant())) {
                    Optional otherState = otherGas.getCarriedBlockState();
                    otherGas.setCarriedBlockState(this.getCarriedBlockState());
                    this.setCarriedBlockState(otherState);
                    return;
                }
                double alignedY = entity.m_20186_() - motionSign * 1.0;
                this.f_19855_ = this.m_20186_();
                this.m_6034_(this.m_20185_(), alignedY, this.m_20189_());
                canPassThrough = false;
                entityCollided = true;
                this.f_19861_ = true;
                break;
            }
        }
        if (canPassThrough) {
            this.f_19861_ = false;
            this.move();
            return;
        }
        this.f_19861_ = true;
        long alignedY = Math.round(this.m_20186_());
        if (!entityCollided) {
            this.m_6034_(this.m_20185_(), alignedY, this.m_20189_());
        }
        boolean bl = alignedToBlock = this.m_20186_() == (double)alignedY;
        if (alignedToBlock) {
            this.setStuck(true);
        }
        if (this.f_19853_ instanceof ServerLevel && alignedToBlock && (spread = pollutant.createSpread((ServerLevel)this.f_19853_, pos = this.m_142538_(), carriedState).to(pos, Integer.MIN_VALUE).overLedge().around(Integer.MIN_VALUE)).completed()) {
            spread.applyTarget();
            this.setCarriedBlockState(Optional.of(spread.getSourceState()));
            return;
        }
    }
}

