/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.compat.Minecraft;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.nio.file.Path;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    public Emitters(AbstractForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    protected void attachToStates() {
        super.attachToStates();
        for (Emitter emitter : this.getAll()) {
            EntityType type;
            UnitId id;
            if (!emitter.getType().isFuel() || !AbstractForgeMod.isLoaded((String)(id = emitter.getRelatedId()).getModId()) || (type = (EntityType)ForgeRegistries.ENTITIES.getValue(id.toResLoc())) == null) continue;
            this.entities.put(type, emitter);
        }
    }

    public Emitter createCustomUnitFrom(UnitConfig config, String name) {
        UnitId id = UnitId.from((Path)config.getConfigFile().toPath());
        return new Emitter(config, (Emitter.Properties<?>)Emitter.Properties.tile("").id(id));
    }

    public Emitter createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        return e.props.factory.orElse(Emitter::new).apply(config, e.props);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        brickfurnace$brick_furnace(Emitter.Properties.fuel("BurnTime")),
        brickfurnace$brick_blast_furnace(Emitter.Properties.fuel("BurnTime")),
        brickfurnace$brick_smoker(Emitter.Properties.fuel("BurnTime")),
        car$blastfurnace(Emitter.Properties.fuel("")),
        car$car(Emitter.Properties.fuel("fuel")),
        create$millstone((Emitter.Properties)((Object)Emitter.Properties.tile("Timer").dust(1.0f))),
        create$blaze_burner((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("burnTimeRemaining").carbon(1.0f))).sulfur(0.1f))),
        create$crushing_wheel_controller((Emitter.Properties)((Object)Emitter.Properties.tile("Inventory/ProcessingTime").dust(4.0f))),
        createaddition$crude_burner(Emitter.Properties.fuel("BurnTime")),
        createaddition$furnace_burner(Emitter.Properties.fuel("BurnTime")),
        futurepack$industrial_furnace((Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("progress").stateLit())).carbon(1.0f))).sulfur(0.1f))),
        futurepack$part_press(Emitter.Properties.fuel("burn")),
        immersiveengineering$alloy_smelter((Emitter.Properties<?>)((Object)Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:alloy_smelter:*"))),
        immersiveengineering$coke_oven((Emitter.Properties<?>)((Object)Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:coke_oven:*"))),
        immersiveengineering$blast_furnace((Emitter.Properties<?>)((Object)Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:blast_furnace:*"))),
        immersiveengineering$advanced_blast_furnace((Emitter.Properties<?>)((Object)Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:advanced_blast_furnace:*"))),
        immersiveengineering$diesel_generator((Emitter.Properties<?>)((Object)Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:diesel_generator:*"))),
        immersivepetroleum$portable_generator((Emitter.Properties)Emitter.Properties.fuel("isActive").id("immersivepetroleum:gas_generator:*")),
        immersivepetroleum$speedboat(Emitter.Properties.fuel("")),
        immersiverailroading$diesel_locomotive((Emitter.Properties)Emitter.Properties.fuel("").id("immersiverailroading:locomotivediesel")),
        immersiverailroading$steam_locomotive((Emitter.Properties)Emitter.Properties.fuel("").id("immersiverailroading:locomotivesteam")),
        industrialforegoing$biofuel_generator(Emitter.Properties.fuel("progressBar/Tick")),
        industrialforegoing$pitiful_generator(Emitter.Properties.fuel("progressBar/Tick")),
        ironfurnaces$iron_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$gold_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$diamond_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$emerald_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$obsidian_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$crystal_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$netherite_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$copper_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$silver_furnace(Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$million_furnace(Emitter.Properties.fuel("BurnTime")),
        mekanism$crusher((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").dust(1.0f))),
        mekanism$basic_crushing_factory((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").dust(2.0f))),
        mekanism$advanced_crushing_factory((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").dust(3.0f))),
        mekanism$elite_crushing_factory((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").dust(4.0f))),
        mekanism$ultimate_crushing_factory((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").dust(5.0f))),
        mekanism$fuelwood_heater((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").carbon(1.5f))).sulfur(0.15f))),
        mekanismgenerators$gas_burning_generator((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").carbon(0.5f))).sulfur(0.05f))),
        mekanismgenerators$bio_generator((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").carbon(0.325f))),
        mekanismgenerators$heat_generator((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("activeState").carbon(100.0f))).sulfur(10.0f))),
        minecraft$furnace(Emitter.Properties.fuel("BurnTime")),
        minecraft$smoker(Emitter.Properties.fuel("BurnTime")),
        minecraft$blast_furnace(Emitter.Properties.fuel("BurnTime")),
        minecraft$furnace_minecart((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.entity("Fuel").carbon(1.0f))).sulfur(0.1f))),
        minecraft$fire((Emitter.Properties<?>)((Object)Emitter.Properties.block().customFactory(Minecraft.Fire::new))),
        minecraft$lava(Emitter.Properties.block()),
        minecraft$campfire((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.block().customFactory(Minecraft.Campfire::new).id("campfire:[lit=true, signal_fire=false]")).carbon(0.5f))).sulfur(0.05f))),
        minecraft$campfire_signal((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.block().customFactory(Minecraft.Campfire::new).id("campfire:[lit=true, signal_fire=true]")).carbon(1.0f))).sulfur(0.1f))),
        minecraft$soul_campfire((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.block().customFactory(Minecraft.Campfire::new).id("soul_campfire:[lit=true, signal_fire=false]")).carbon(0.5f))).sulfur(0.2f))),
        minecraft$soul_campfire_signal((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.block().customFactory(Minecraft.Campfire::new).id("soul_campfire:[lit=true, signal_fire=true]")).carbon(1.0f))).sulfur(0.4f))),
        pneumaticcraft$air_compressor(Emitter.Properties.fuel("burnTime")),
        pneumaticcraft$advanced_air_compressor(Emitter.Properties.fuel("burnTime")),
        silents_mechanisms$basic_crusher((Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("Progress").stateLit())).dust(1.0f))),
        silents_mechanisms$crusher((Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("Progress").stateLit())).dust(1.0f))),
        silents_mechanisms$coal_generator(Emitter.Properties.fuel("BurnTime")),
        silents_mechanisms$diesel_generator(Emitter.Properties.fuel("BurnTime")),
        silents_mechanisms$lava_generator(Emitter.Properties.fuel("BurnTime")),
        simpleplanes$plane(Emitter.Properties.fuel("")),
        simpleplanes$large_plane(Emitter.Properties.fuel("")),
        simpleplanes$helicopter(Emitter.Properties.fuel("")),
        tconstruct$melter((Emitter.Properties<?>)((Object)Emitter.Properties.fuel("fuel").relatedBlocks("#tconstruct:melter_tanks"))),
        tconstruct$smeltery_controller((Emitter.Properties<?>)((Object)Emitter.Properties.fuel("fuel").relatedBlocks("#tconstruct:smeltery/wall", "#tconstruct:smeltery/floor"))),
        thermal$dynamo_stirling((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("Active").carbon(1.0f))).sulfur(0.1f))),
        thermal$dynamo_compression((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("Active").carbon(1.0f))).sulfur(0.1f))),
        thermal$dynamo_magmatic((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("Active").carbon(1.0f))).sulfur(0.4f))),
        vehicle$atv(Emitter.Properties.fuel("")),
        vehicle$dune_buggy(Emitter.Properties.fuel("")),
        vehicle$go_kart(Emitter.Properties.fuel("")),
        vehicle$shopping_cart(Emitter.Properties.fuel("")),
        vehicle$mini_bike(Emitter.Properties.fuel("")),
        vehicle$bumper_car(Emitter.Properties.fuel("")),
        vehicle$jet_ski(Emitter.Properties.fuel("")),
        vehicle$speed_boat(Emitter.Properties.fuel("")),
        vehicle$aluminum_boat(Emitter.Properties.fuel("")),
        vehicle$smart_car(Emitter.Properties.fuel("")),
        vehicle$lawn_mower(Emitter.Properties.fuel("")),
        vehicle$moped(Emitter.Properties.fuel("")),
        vehicle$sports_plane(Emitter.Properties.fuel("")),
        vehicle$golf_cart(Emitter.Properties.fuel("")),
        vehicle$off_roader(Emitter.Properties.fuel("")),
        vehicle$tractor(Emitter.Properties.fuel("")),
        vehicle$mini_bus(Emitter.Properties.fuel("")),
        vehicle$dirt_bike(Emitter.Properties.fuel("")),
        cfm$couch(Emitter.Properties.fuel("")),
        cfm$bath(Emitter.Properties.fuel("")),
        cfm$sofacopter(Emitter.Properties.fuel(""));

        final Emitter.Properties<?> props;

        private BuiltInEmitters(Emitter.Properties<?> props) {
            this.props = (Emitter.Properties)props.emptyToEnumId(this, true);
        }
    }
}

