/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEffect;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class Respirators
extends RelatedUnitsInit<Respirator, BuiltIn> {
    public Respirators(AbstractForgeMod mod) {
        super(mod, BuiltIn.class);
    }

    public Respirator createCustomUnitFrom(UnitConfig config, String name) {
        return new Respirator(config, UnitId.EMPTY, 0, "");
    }

    public Respirator createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
        return e.createRespirator(config, UnitId.from((Enum)e, (String)"*"));
    }

    public RespiratorEffect getEffect() {
        return AdPother.getInstance().effects.respirator;
    }

    public CommonTime.Interval getEffectDurationFor(Respirator respirator, ItemStack stack, int damage) {
        if (damage > 0) {
            IStorage.Content content = respirator.getContent(stack);
            double seconds = content.hasFunctionalFilters() ? (double)(content.getCapacity() - content.getHighestFullness()) : 0.0;
            seconds /= (double)damage;
            seconds = Math.max(2.0, seconds);
            return CommonTime.Interval.seconds((double)seconds);
        }
        return CommonTime.Interval.hours((double)1.0);
    }

    public Optional<Pair<ItemStack, Respirator>> findOn(LivingEntity living, boolean onlyFunctional) {
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)living)) {
            Respirator respirator = this.get(stack).orElse(null);
            if (respirator == null || onlyFunctional && !respirator.isFunctional(stack)) continue;
            return Optional.of(Pair.of((Object)stack, (Object)respirator));
        }
        return Optional.empty();
    }

    public void updateEffectFor(LivingEntity living, int damage) {
        living.m_21195_((MobEffect)this.getEffect());
        this.findOn(living, true).ifPresent(pair -> {
            CommonTime.Interval duration = this.getEffectDurationFor((Respirator)pair.getRight(), (ItemStack)pair.getLeft(), damage);
            living.m_7292_(this.getEffect().createInstance(duration, false));
        });
    }

    static enum BuiltIn implements IForgeEnum
    {
        adpother$iron_respirator(600),
        adpother$gold_respirator(720),
        adpother$diamond_respirator(1440),
        mekanism$scuba_mask(600),
        mekanism$hazmat_mask(600),
        mekanism$mekasuit_helmet(1440);

        public final int durability;
        public final String functionalStateTag;

        private BuiltIn(String functionalStateTag, int durability) {
            this.durability = durability;
            this.functionalStateTag = functionalStateTag;
        }

        private BuiltIn(int durability) {
            this("", durability);
        }

        Respirator createRespirator(UnitConfig config, UnitId id) {
            return new Respirator(config, id, this.durability, this.functionalStateTag);
        }
    }

    public static class Respirator
    extends RelatedUnit
    implements IStorageItem {
        public final int durability;
        protected final boolean allowsEating;
        private final String functionalStateTag;

        public Respirator(UnitConfig config, UnitId id, int durability, String functionalStateTag) {
            super(config, id);
            String category = this.getClassCategory();
            this.durability = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"durability", (int)durability, (IntBounds)GameBounds.DURABILITY.getIntBounds(), (String)"How long (in seconds) this respirator can withstand low-level pollution.");
            this.allowsEating = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"allowsEating", (boolean)false, (String)"Whether or not eating and drinking are allowed while wearing this respirator.");
            this.functionalStateTag = UnitConfig.getStr((UnitConfig)config, (String)category, (String)"functionalStateTag", (String)functionalStateTag, (String)"The name of the NBT tag that stores info about the active state.\nRespirator is considered functional only if the returning value is > 0 or true.\nSet empty string for no checks");
            this.saveConfig();
        }

        public static void setAllowsEatingTag(ItemStack stack, boolean value) {
            stack.m_41784_().m_128379_("allowsEating", true);
        }

        public boolean allowsEating(ItemStack stack) {
            if (this.allowsEating) {
                return true;
            }
            CompoundTag compound = stack.m_41783_();
            return compound != null && compound.m_128471_("allowsEating");
        }

        public boolean isFunctional(ItemStack stack) {
            int value;
            CompoundTag compound;
            if (ForgeItem.isBroken((ItemStack)stack)) {
                return false;
            }
            if (!this.functionalStateTag.isEmpty() && (compound = stack.m_41783_()) != null && (value = compound.m_128451_(this.functionalStateTag)) <= 0) {
                return false;
            }
            return this.getContent(stack).hasFunctionalFilters();
        }

        public String getTagName() {
            return this.functionalStateTag;
        }

        @Override
        public int getInitialCapacity(ItemStack storage) {
            return this.durability;
        }
    }

    public static class RespiratorEffect
    extends ForgeEffect {
        protected RespiratorEffect(AbstractForgeMod mod) {
            super(mod, "respirator", MobEffectCategory.BENEFICIAL, Pollutants.BuiltIn.CARBON.get().getColor());
        }

        public void m_6742_(LivingEntity living, int amplifier) {
        }
    }
}

