/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public abstract class AbstractPollution {
    protected Map<Pollutant<?>, PollutionInfo> infoForPollutant = new ConcurrentHashMap();

    public Stream<PollutionInfo> getInfos() {
        return this.infoForPollutant.values().stream();
    }

    public boolean isEmpty() {
        return this.getInfos().noneMatch(info -> !info.isEmpty());
    }

    @Nonnull
    public PollutionInfo getOrCreateInfoFor(Pollutant<?> pollutant) {
        PollutionInfo info = this.infoForPollutant.get(pollutant);
        if (info == null) {
            info = new PollutionInfo(pollutant);
            this.infoForPollutant.put(pollutant, info);
        }
        return info;
    }

    public Optional<PollutionInfo> getInfoFor(Pollutant<?> pollutant) {
        return Optional.ofNullable(this.infoForPollutant.get(pollutant));
    }

    public void readFrom(CompoundTag compound) {
        if (compound.m_128425_("pollutants", 9)) {
            this.infoForPollutant.clear();
            ListTag list = compound.m_128437_("pollutants", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.m_128728_(i);
                PollutionInfo info = new PollutionInfo(null).readFrom(tag);
                if (info.isEmpty()) continue;
                this.infoForPollutant.put(info.getPollutant(), info);
            }
        }
    }

    public void writeTo(CompoundTag compound) {
        ListTag list = new ListTag();
        this.getInfos().filter(info -> !info.isEmpty()).forEach(info -> {
            CompoundTag tag = info.writeTo(new CompoundTag());
            list.add((Object)tag);
        });
        compound.m_128365_("pollutants", (Tag)list);
    }
}

