/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class Smog {
    public static boolean renderSmog = true;
    public static boolean colorSmog = true;
    private static final CommonTime.Interval updateInterval = GameTime.quaterSecond().getInterval();
    private static final FloatBounds fogEndBounds = FloatBounds.between((Float)Float.valueOf(8.0f), (Float)Float.valueOf(256.0f));
    private static Optional<ColorARGB> color = Optional.empty();
    private static CommonTime.Stamp lastUpdate = CommonTime.Stamp.now();
    private static float currentDensity = 0.0f;
    private static float targetDensity = 0.0f;

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        FloatBounds fogDensity = GameBounds.FOG_DENSITY.getFloatBounds();
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)lastUpdate).moreThan(updateInterval)) {
            Entity entity = event.getCamera().m_90592_();
            EntityPollution pollution = WorldData.getEntityPollution(entity);
            Optional<Pollutant<?>> dominant = pollution.getDominantPollutant(pollutant -> true);
            if (dominant.isPresent()) {
                float factor = pollution.getInfluenceOf(dominant.get()).toFraction();
                color = Optional.of(dominant.get().getColor());
                targetDensity = fogDensity.interpolateUp(factor).floatValue();
            } else {
                color = Optional.empty();
                targetDensity = 0.0f;
            }
            lastUpdate = CommonTime.Stamp.now();
        }
        float changingStep = 3.0E-5f;
        float delta = targetDensity - currentDensity;
        currentDensity = Math.abs(delta) >= Math.abs(changingStep) ? (currentDensity += changingStep * Math.signum(delta)) : targetDensity;
        if (renderSmog) {
            float fogStart = RenderSystem.m_157200_();
            float fogEnd = RenderSystem.m_157199_();
            float targetFogEnd = Smog.getTargetFogEnd();
            if (targetFogEnd < fogEnd) {
                RenderSystem.m_157445_((float)-8.0f);
                RenderSystem.m_157443_((float)targetFogEnd);
            }
        }
    }

    @SubscribeEvent
    public static void onFogColors(EntityViewRenderEvent.FogColors event) {
        float minDensityToColorSmog = 0.07f;
        if (renderSmog && colorSmog && color.isPresent() && currentDensity >= minDensityToColorSmog) {
            event.setRed(color.get().getRed().toFloat());
            event.setGreen(color.get().getGreen().toFloat());
            event.setBlue(color.get().getBlue().toFloat());
        }
    }

    static float getTargetFogEnd() {
        float factor = (float)Math.pow(currentDensity * 10.0f, 0.2);
        return fogEndBounds.interpolateDown(factor).floatValue();
    }
}

