/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.client.renderer.GlassMeterRenderer;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Dependencies;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.network.TileSharedDataMsg;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.Wind;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.SystemUtils;

@Mod(value="forgeendertech")
public class ForgeEndertech
extends AbstractForgeMod {
    public static final String ID = "forgeendertech";
    public static final String NAME = "ForgeEndertech";
    private static final boolean DEVELOPER_ENVIRONMENT = ASMAPI.mapField((String)"f_131106_").equals("obfuscated") && "forgeendertech".indexOf(SystemUtils.getUserHome().getName().toLowerCase()) == 5;
    private static ForgeEndertech instance;
    static ForgeConfigSpec.ConfigValue<Boolean> debug;

    public ForgeEndertech() {
        instance = this;
        UnitConfig config = UnitConfig.in(this.getConfigsDir(), "Wind");
        Wind.randomSeed = config.getInt("Wind", "randomSeed", CommonMath.Random.getInt(), IntBounds.INTEGER, "Random seed");
        Wind.defaultWind = new Wind(config, BiomeId.EMPTY, 0.1f, 0.01f, 0.0015f);
    }

    public static ForgeEndertech getInstance() {
        return instance;
    }

    public static boolean isDebugMode() {
        return (Boolean)debug.get();
    }

    public static void debugMsg(String msg) {
        if (ForgeEndertech.isDebugMode()) {
            ForgeEndertech.getInstance().getLogger().info(msg);
        }
    }

    public static void developMsg(String msg) {
        if (DEVELOPER_ENVIRONMENT) {
            ForgeEndertech.debugMsg(msg);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public AbstractForgeMod.RequiredSide getRequiredSide() {
        return AbstractForgeMod.RequiredSide.SERVER;
    }

    @Override
    public void commonInit() {
        GameWorld.isWeather2Loaded = ForgeEndertech.isLoaded("weather2");
        this.registerNetMessage(TileSharedDataMsg::new);
        this.registerNetMessage(Wind.WindMsg::new);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        Dependencies.checkIntegrityOnce();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
        GlassMeterRenderer.RENDER_TYPE = RenderType.m_110473_((ResourceLocation)GameRendering.EMPTY_TEXTURE);
    }

    @Override
    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        value.push("SmokeContainers");
        GameWorld.SmokeContainers.maxVentPipeLength = value.comment("Maximum length of the vent pipe for smoke or gas transmition").defineInRange("maxVentPipeLength", 32, IntBounds.between(1, 64));
        GameWorld.SmokeContainers.ventInhaleDistance = value.comment("Maximum distance from vent to the gas block to inhale").defineInRange("ventInhaleDistance", 4, IntBounds.between(1, 16));
        GameWorld.SmokeContainers.maxBlocksInMultiblock = value.comment("Maximum amount of blocks that will be checked when searching for multiblock boundaries.").defineInRange("maxBlocksInMultiblock", 81, IntBounds.between(1, 512));
        value.pop();
        debug = value.comment("Enable/Disable debug mode").define("debug", false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
    }

    @Override
    public void commonPostInit() {
    }

    @Override
    public void registerArgumentTypes() {
        ArgumentTypes.m_121601_((String)this.getNamespace().resolve("int_bounds"), ServerCommand.IntBoundsArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(ServerCommand.IntBoundsArgument::integer));
        ArgumentTypes.m_121601_((String)this.getNamespace().resolve("float_bounds"), ServerCommand.FloatBoundsArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(ServerCommand.FloatBoundsArgument::unbounded));
        ArgumentTypes.m_121601_((String)this.getNamespace().resolve("color_argb"), ServerCommand.ColorARGBArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(ServerCommand.ColorARGBArgument::new));
    }
}

