/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.core;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.Namespace;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.network.Connection;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractForgeMod {
    protected final List<Runnable> postInitRunnables = new ArrayList<Runnable>();
    private final Logger logger = LogManager.getLogger((String)this.getId());
    private final Connection connection = new Connection(this.getId(), this.getRequiredSide());
    private final Namespace namespace = Namespace.of(this.getId());

    public abstract String getId();

    protected AbstractForgeMod() {
        IEventBus modEventBus = this.getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(event -> this.commonInit());
        modEventBus.addListener(event -> event.enqueueWork(this::registerArgumentTypes));
        modEventBus.addListener(event -> event.enqueueWork(this::commonPostInit));
        forgeEventBus.addListener(event -> this.updateReloadedTags());
        this.registerConfig(ModConfig.Type.COMMON, this::commonConfigInit);
        forgeEventBus.addListener(event -> this.serverAboutToStart(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStarting(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStopped(event.getServer()));
        forgeEventBus.addListener(event -> this.registerCommands(ServerCommand.createFor(this, (CommandDispatcher<CommandSourceStack>)event.getDispatcher())));
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(event -> this.clientInit());
            modEventBus.addListener(event -> this.clientReplaceModels(new ItemModel.RegistryWrapper(event.getModelRegistry())));
            modEventBus.addListener(event -> this.clientRegisterParticleFactories(Minecraft.m_91087_().f_91061_));
            modEventBus.addListener(event -> event.enqueueWork(() -> this.clientRegisterItemModelProperties(ItemModel.Properties.of(this))));
            modEventBus.addListener(event -> this.clientAddRenderLayers());
            modEventBus.addListener(event -> this.clientRegisterRenderers());
            this.registerConfig(ModConfig.Type.CLIENT, this::clientConfigInit);
        }
    }

    public IEventBus getModEventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }

    public abstract void commonInit();

    public void commonPostInit() {
        this.postInitRunnables.forEach(action -> action.run());
    }

    public void commonConfigInit(ConfigValueBuilder value) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(ConfigValueBuilder value) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientAddRenderLayers() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterRenderers() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterParticleFactories(ParticleEngine manager) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
    }

    public void registerArgumentTypes() {
    }

    public void registerCommands(ServerCommand command) {
    }

    public void updateReloadedTags() {
    }

    protected void serverAboutToStart(MinecraftServer server) {
    }

    protected void serverStarting(MinecraftServer server) {
    }

    protected void serverStopped(MinecraftServer server) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public RequiredSide getRequiredSide() {
        return RequiredSide.BOTH;
    }

    public void runDuringPostInit(Runnable method) {
        this.postInitRunnables.add(method);
    }

    protected <MSG extends ForgeNetMsg<MSG>> void registerNetMessage(Supplier<MSG> factory) {
        this.getConnection().registerNetMessage((ForgeNetMsg)factory.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends Entity> void registerEntityRender(EntityType<T> entityType, EntityRendererProvider<? super T> rendererProvider) {
        EntityRenderers.m_174036_(entityType, rendererProvider);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends BlockEntity> void registerTileRenderer(BlockEntityType<T> tileEntityType, BlockEntityRendererProvider<? super T> rendererProvider) {
        BlockEntityRenderers.m_173590_(tileEntityType, rendererProvider);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <M extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<? extends M> type, MenuScreens.ScreenConstructor<M, U> factory) {
        MenuScreens.m_96206_(type, factory);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderLayer(Block block, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderLayer(Fluid fluid, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addPlayerRenderLayer(Function<PlayerRenderer, RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>> renderLayerFactory) {
        Collection renderers = Minecraft.m_91087_().m_91290_().getSkinMap().values();
        renderers.forEach(renderer -> {
            if (renderer instanceof PlayerRenderer) {
                PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
                playerRenderer.m_115326_((RenderLayer)renderLayerFactory.apply(playerRenderer));
            }
        });
    }

    public static boolean isLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public Path getConfigsDir() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getId());
    }

    protected void registerConfig(ModConfig.Type type, Consumer<ConfigValueBuilder> init) {
        ConfigValueBuilder value = new ConfigValueBuilder();
        init.accept(value);
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)value.builder.build());
    }

    public static enum RequiredSide {
        SERVER,
        CLIENT,
        BOTH;

    }

    public static class ConfigValueBuilder {
        public final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();

        public ConfigValueBuilder push(String path) {
            this.builder.push(path);
            return this;
        }

        public ConfigValueBuilder pop() {
            this.builder.pop();
            return this;
        }

        public ConfigValueBuilder comment(String comment) {
            this.builder.comment(comment);
            return this;
        }

        public ForgeConfigSpec.ConfigValue<Boolean> define(String path, boolean defaultValue) {
            return this.builder.define(path, defaultValue);
        }

        public ForgeConfigSpec.ConfigValue<Integer> define(String path, ColorARGB defaultValue) {
            return this.builder.define(path, (Object)defaultValue.getARGB());
        }

        public ForgeConfigSpec.ConfigValue<Integer> defineInRange(String path, int defaultValue, IntBounds bounds) {
            return this.builder.defineInRange(path, defaultValue, bounds.getMin().intValue(), bounds.getMax().intValue());
        }

        public ForgeConfigSpec.ConfigValue<Double> defineInRange(String path, float defaultValue, FloatBounds bounds) {
            return this.builder.defineInRange(path, (double)defaultValue, (double)bounds.getMin().floatValue(), (double)bounds.getMax().floatValue());
        }
    }
}

