/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public final class Biomes {
    public static final String BIOMES_LIST_SYNTAX = "Biome is specified by its registry name (case-insensitive) or by its tag with '#' prefix.\nExamples: minecraft:forest, #snowy\nEach biome must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.";

    public static Collection<Biome> getAll() {
        return ForgeRegistries.BIOMES.getValues();
    }

    public static UnitConfig createConfigFor(AbstractForgeMod mod, BiomeId biome, boolean enabled) {
        String biomeName = biome.toString();
        String fileName = UnitId.from(biomeName).toConfigName();
        UnitConfig config = UnitConfig.in(Biomes.getConfigsBaseDir(mod), fileName);
        Biomes.readBiomeName(config, biomeName);
        UnitConfig.readConfigEnabled(config, enabled);
        return config;
    }

    public static Path getConfigsBaseDir(AbstractForgeMod mod) {
        return mod.getConfigsDir().resolve(Biomes.class.getSimpleName());
    }

    protected static String readBiomeName(UnitConfig config, String defaultName) {
        String name = UnitConfig.getStr(config, "Biome", "name", defaultName, "Biome registry name");
        return name;
    }

    public static BiomeId readBiomeId(UnitConfig config) {
        String name = Biomes.readBiomeName(config, "");
        if (name.isEmpty()) {
            return BiomeId.EMPTY;
        }
        return Biomes.getByName(name);
    }

    public static BiomeId getByName(String biomeName) {
        try {
            return BiomeId.from(new ResourceLocation(biomeName));
        }
        catch (Exception e) {
            ForgeEndertech.getInstance().getLogger().error("Invalid biome name: '{}'", (Object)biomeName);
            return BiomeId.EMPTY;
        }
    }

    public static Set<BiomeId> getByTag(String biomeTag) {
        String typeName = biomeTag.startsWith("#") ? biomeTag.replaceFirst("#", "") : biomeTag;
        typeName = typeName.toUpperCase(Locale.ROOT);
        for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
            if (!type.getName().equals(typeName)) continue;
            return BiomeDictionary.getBiomes((BiomeDictionary.Type)type).stream().map(key -> BiomeId.from((ResourceKey<Biome>)key)).collect(Collectors.toSet());
        }
        ForgeEndertech.getInstance().getLogger().error("Invalid biome type: '{}'", (Object)biomeTag);
        return Collections.emptySet();
    }

    public static boolean isConfigEnabled(UnitConfig config) {
        return UnitConfig.readConfigEnabled(config, false);
    }

    public static CommonCollect.BlackWhiteList<BiomeId> from(UnitConfig config, String category, String comment) {
        category = IHaveConfig.expandClassCategory(Biomes.class, category);
        if (config != null) {
            config.setCategoryComment(category, comment + "\nBiome is specified by its registry name (case-insensitive) or by its tag with '#' prefix.\nExamples: minecraft:forest, #snowy\nEach biome must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.");
        }
        ArrayList<BiomeId> black = new ArrayList<BiomeId>(Biomes.readFrom(config, category, "blackList", ""));
        ArrayList<BiomeId> white = new ArrayList<BiomeId>(Biomes.readFrom(config, category, "whiteList", ""));
        return new CommonCollect.BlackWhiteList<BiomeId>(black, white);
    }

    public static Set<BiomeId> readFrom(UnitConfig config, String category, String key, String comment) {
        if (config == null) {
            return Collections.emptySet();
        }
        String[] strArray = config.getStrArray(category, key, new String[0], comment);
        HashSet<BiomeId> biomes = new HashSet<BiomeId>();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            if (str.startsWith("#")) {
                biomes.addAll(Biomes.getByTag(str));
                continue;
            }
            biomes.add(Biomes.getByName(str));
        }
        return biomes;
    }
}

