/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

public final class GameWorld {
    public static boolean isWeather2Loaded = false;

    public static boolean isBlockLoaded(LevelReader level, BlockPos pos) {
        return level.m_46805_(pos);
    }

    public static boolean isAirBlock(LevelReader level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_();
    }

    public static boolean isWaterBlock(LevelReader level, BlockPos pos) {
        return level.m_6425_(pos).m_76152_().m_76108_((Tag)FluidTags.f_13131_);
    }

    public static boolean isWaterSource(LevelReader level, BlockPos pos) {
        FluidState state = level.m_6425_(pos);
        return state.m_76170_() && state.m_76152_().m_76108_((Tag)FluidTags.f_13131_);
    }

    public static boolean isLavaBlock(LevelReader level, BlockPos pos) {
        return level.m_6425_(pos).m_76152_().m_76108_((Tag)FluidTags.f_13132_);
    }

    public static boolean isLavaSource(LevelReader level, BlockPos pos) {
        FluidState state = level.m_6425_(pos);
        return state.m_76170_() && state.m_76152_().m_76108_((Tag)FluidTags.f_13132_);
    }

    public static boolean isOreBlock(LevelReader level, BlockPos pos, BlockState state) {
        return state.m_60620_((Tag)Tags.Blocks.ORES);
    }

    public static IWind getWindAt(Level level, BlockPos pos) {
        WorldData data = GameWorld.getData((LevelAccessor)level);
        BiomeId biome = BiomeId.from((LevelAccessor)level, pos);
        return data.getWind(biome);
    }

    public static void explodeBlock(ServerLevel level, BlockPos pos, float explosionSize, boolean causesFire, Explosion.BlockInteraction mode, boolean dropBlock, @Nullable Entity exploder) {
        BlockState state = level.m_8055_(pos);
        if (dropBlock) {
            BlockEntity tile = state.m_60734_() instanceof EntityBlock ? level.m_7702_(pos) : null;
            Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)tile);
        }
        level.m_46518_(exploder, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), explosionSize, causesFire, mode);
        level.m_7471_(pos, false);
    }

    public static void scheduleBlockExplosion(ServerLevel level, BlockPos pos, CommonTime.Interval delay, float size, boolean fire, Explosion.BlockInteraction mode, boolean dropAsItem, @Nullable Entity exploder) {
        WorldData data = GameWorld.getData((LevelAccessor)level);
        ScheduledExplosion explosion = new ScheduledExplosion(level, pos, delay, size, fire, mode, dropAsItem, exploder);
        data.scheduledExplosions.put(pos, explosion);
    }

    public static boolean isServerSide(LevelReader level) {
        return !level.m_5776_();
    }

    public static boolean isClientSide(LevelReader level) {
        return level.m_5776_();
    }

    public static Optional<Entity> getEntity(Level level, int id) {
        return level != null ? Optional.ofNullable(level.m_6815_(id)) : Optional.empty();
    }

    public static Vect3d getBlockCenter(BlockPos pos) {
        return Vect3d.from(pos).add(GameMath.getBBCenter(ForgeBlock.FULL_BLOCK_AABB));
    }

    public static LevelChunk getChunk(Level level, ChunkPos pos) {
        return level.m_6325_(pos.f_45578_, pos.f_45579_);
    }

    public static boolean setBlockState(LevelWriter level, BlockPos pos, BlockState state) {
        return level.m_7731_(pos, state, 3);
    }

    public static void spawnParticle(Level level, Vect3d pos, Vect3d motion, ParticleOptions particleData) {
        level.m_7106_(particleData, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
    }

    public static Optional<BlockHitResult> rayTraceBlocks(Level level, Vect3d start, Vect3d end, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, Entity entity) {
        ClipContext context = new ClipContext(start.toVector3d(), end.toVector3d(), blockMode, fluidMode, entity);
        BlockHitResult hit = level.m_45547_(context);
        return hit != null && hit.m_6662_() != HitResult.Type.MISS ? Optional.of(hit) : Optional.empty();
    }

    @Nonnull
    public static WorldData getData(LevelAccessor level) {
        WorldData data = WorldData.DATA_MAP.get(level);
        if (data == null) {
            data = new WorldData(level);
            WorldData.DATA_MAP.put(level, data);
        }
        return data;
    }

    @Mod.EventBusSubscriber
    public static class WorldData {
        static final Map<LevelAccessor, WorldData> DATA_MAP = new ConcurrentHashMap<LevelAccessor, WorldData>();
        public int smokeParticlesCount = 0;
        protected final Map<BiomeId, Wind> biomeWindMap = new ConcurrentHashMap<BiomeId, Wind>();
        protected final Map<BlockPos, ScheduledExplosion> scheduledExplosions = new ConcurrentHashMap<BlockPos, ScheduledExplosion>();
        protected final Deque<LevelChunk> freshlyLoadedChunks = new ConcurrentLinkedDeque<LevelChunk>();
        private final LevelAccessor level;

        public WorldData(LevelAccessor level) {
            this.level = level;
        }

        public LevelAccessor getLevel() {
            return this.level;
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            LevelAccessor level = event.getWorld();
            if (GameWorld.isServerSide((LevelReader)level)) {
                WorldData data = GameWorld.getData(level);
                data.initBiomesWinds();
            }
        }

        @SubscribeEvent
        public static void onWorldUnload(WorldEvent.Unload event) {
            LevelAccessor level = event.getWorld();
            DATA_MAP.remove(level);
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.WorldTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            Level level = event.world;
            WorldData data = GameWorld.getData((LevelAccessor)level);
            Wind.defaultWind.update(level);
            for (Wind wind : data.biomeWindMap.values()) {
                wind.update(level);
            }
            if (level instanceof ServerLevel) {
                Iterator<Object> iterator = data.freshlyLoadedChunks.iterator();
                while (iterator.hasNext()) {
                    LevelChunk chunk = iterator.next();
                    ChunkPos chunkPos = chunk.m_7697_();
                    if (!level.m_7726_().m_5563_(chunkPos.f_45578_, chunkPos.f_45579_)) continue;
                    ChunkFullyLoadedEvent.onChunkFullyLoaded((ServerLevel)level, chunk);
                    iterator.remove();
                }
                iterator = data.scheduledExplosions.values().iterator();
                while (iterator.hasNext()) {
                    ScheduledExplosion explosion = (ScheduledExplosion)iterator.next();
                    if (!explosion.timePast()) continue;
                    GameWorld.explodeBlock((ServerLevel)level, explosion.pos, explosion.size, explosion.fire, explosion.mode, explosion.dropAsItem, explosion.exploder);
                    iterator.remove();
                    break;
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getPlayer();
            Level level = player.f_19853_;
            if (GameWorld.isServerSide((LevelReader)level) && player instanceof ServerPlayer) {
                WorldData data = GameWorld.getData((LevelAccessor)level);
                for (Wind wind : data.biomeWindMap.values()) {
                    Wind.WindMsg message = new Wind.WindMsg(wind);
                    ForgeEndertech.getInstance().getConnection().sendToPlayer(message, (ServerPlayer)player);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            Level level = event.player.f_19853_;
            if (GameWorld.isClientSide((LevelReader)level)) {
                Wind.defaultWind.update(level);
                WorldData data = GameWorld.getData((LevelAccessor)level);
                for (Wind wind : data.biomeWindMap.values()) {
                    wind.update(level);
                }
            }
        }

        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load event) {
            LevelChunk chunk;
            Level level;
            ChunkAccess chunkAccess = event.getChunk();
            if (chunkAccess instanceof LevelChunk && (level = (chunk = (LevelChunk)chunkAccess).m_62953_()) instanceof ServerLevel) {
                GameWorld.getData((LevelAccessor)level).freshlyLoadedChunks.addLast(chunk);
            }
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload event) {
            LevelChunk chunk;
            Level level;
            ChunkAccess chunkAccess = event.getChunk();
            if (chunkAccess instanceof LevelChunk && (level = (chunk = (LevelChunk)chunkAccess).m_62953_()) instanceof ServerLevel) {
                GameWorld.getData((LevelAccessor)level).freshlyLoadedChunks.removeAll(Collections.singleton(chunk));
            }
        }

        protected void initBiomesWinds() {
            ForgeRegistries.BIOMES.getEntries().stream().findFirst().map(entry -> BiomeId.from((ResourceKey<Biome>)((ResourceKey)entry.getKey()))).ifPresent(biome -> Wind.from(Biomes.createConfigFor(ForgeEndertech.getInstance(), biome, false), biome));
            for (Path path : UnitConfig.listCustomConfigs(Biomes.getConfigsBaseDir(ForgeEndertech.getInstance()), null)) {
                UnitConfig config = new UnitConfig(path.toFile());
                BiomeId biome2 = Biomes.readBiomeId(config);
                boolean enabled = Biomes.isConfigEnabled(config);
                Wind wind = Wind.from(config, biome2);
                if (!enabled || biome2.isEmpty() || wind.equalsDefault()) continue;
                this.biomeWindMap.put(biome2, wind);
            }
        }

        @Nonnull
        public Wind getWind(BiomeId biome) {
            return this.biomeWindMap.getOrDefault(biome, Wind.defaultWind);
        }
    }

    public static class ScheduledExplosion {
        public final ServerLevel level;
        public final BlockPos pos;
        public final CommonTime.Interval delay;
        public final float size;
        public final boolean fire;
        public final boolean dropAsItem;
        public final Explosion.BlockInteraction mode;
        @Nullable
        public final Entity exploder;
        protected final CommonTime.Stamp stamp = CommonTime.Stamp.now();

        public ScheduledExplosion(ServerLevel level, BlockPos pos, CommonTime.Interval delay, float size, boolean fire, Explosion.BlockInteraction mode, boolean dropAsItem, @Nullable Entity exploder) {
            this.level = level;
            this.pos = pos;
            this.delay = delay;
            this.size = size;
            this.fire = fire;
            this.dropAsItem = dropAsItem;
            this.exploder = exploder;
            this.mode = mode;
        }

        public boolean timePast() {
            return CommonTime.Interval.passedFrom(this.stamp).moreThan(this.delay);
        }
    }

    public static class SmokeContainers<C extends ISmokeContainer> {
        public static ForgeConfigSpec.ConfigValue<Integer> maxVentPipeLength;
        public static ForgeConfigSpec.ConfigValue<Integer> ventInhaleDistance;
        public static ForgeConfigSpec.ConfigValue<Integer> maxBlocksInMultiblock;

        public static boolean isChimney(LevelReader level, BlockPos pos) {
            Block block = level.m_8055_(pos).m_60734_();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.CHIMNEY);
        }

        public static boolean isVent(LevelReader level, BlockPos pos) {
            Block block = level.m_8055_(pos).m_60734_();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.VENT);
        }

        public static boolean isPump(LevelReader level, BlockPos pos) {
            Block block = level.m_8055_(pos).m_60734_();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.PUMP);
        }

        public static boolean isActive(LevelReader level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).isActive((BlockGetter)level, pos);
        }

        public static boolean isActivePump(LevelReader level, BlockPos pos) {
            return SmokeContainers.isPump(level, pos) && SmokeContainers.isActive(level, pos);
        }

        public static boolean isCoveredByChimney(LevelReader level, BlockPos pos) {
            return SmokeContainers.isChimney(level, pos.m_7494_());
        }

        public static BlockPos getTopmostChimney(LevelReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isChimney, Direction.UP);
        }

        public static BlockPos getBottommostChimney(LevelReader level, BlockPos startPos) {
            return Positions.getLastInLine(level, startPos, SmokeContainers::isChimney, Direction.DOWN);
        }

        public static List<BlockPos> getVentsAround(LevelReader level, BlockPos centerPos) {
            ArrayList<BlockPos> vents = new ArrayList<BlockPos>();
            for (BlockPos pos : Positions.getAroundHoriz(centerPos, false, new BlockPos[0])) {
                if (!SmokeContainers.isVent(level, pos)) continue;
                vents.add(pos);
            }
            return vents;
        }
    }

    public static class Positions {
        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, boolean includeCorners, BlockPos ... positions) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            blocks.add(centerPos.m_142125_());
            blocks.add(centerPos.m_142126_());
            blocks.add(centerPos.m_142127_());
            blocks.add(centerPos.m_142128_());
            if (includeCorners) {
                blocks.add(centerPos.m_142125_().m_142127_());
                blocks.add(centerPos.m_142125_().m_142128_());
                blocks.add(centerPos.m_142126_().m_142127_());
                blocks.add(centerPos.m_142126_().m_142128_());
            }
            blocks.addAll(Arrays.asList(positions));
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, boolean includeCorners, ChunkPos ... positions) {
            List<BlockPos> blocks = Positions.getAroundHoriz(new BlockPos(centerPos.f_45578_, 0, centerPos.f_45579_), includeCorners, new BlockPos[0]);
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.m_123341_(), pos.m_123343_()));
            }
            chunks.addAll(Arrays.asList(positions));
            return chunks;
        }

        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            if (radius > 0) {
                int diameter = radius * 2 + (!includeCorners ? 1 : 0);
                blocks.addAll(Positions.getLine(centerPos.m_142386_(radius).m_142390_(radius), Direction.EAST, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.m_142390_(radius).m_142385_(radius), Direction.SOUTH, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.m_142385_(radius).m_142383_(radius), Direction.WEST, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.m_142383_(radius).m_142386_(radius), Direction.NORTH, diameter, !includeCorners));
            } else {
                blocks.add(centerPos);
            }
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, int radius, boolean includeCorners) {
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            List<BlockPos> blocks = Positions.getAroundHoriz(new BlockPos(centerPos.f_45578_, 0, centerPos.f_45579_), radius, includeCorners);
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.m_123341_(), pos.m_123343_()));
            }
            return chunks;
        }

        public static List<BlockPos> getLine(BlockPos startPos, Direction direction, int length, boolean excludeEnds) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int i = 0; i < length; ++i) {
                if (excludeEnds && (i == 0 || i == length - 1)) continue;
                BlockPos pos = startPos.m_5484_(direction, i);
                blocks.add(pos);
            }
            return blocks;
        }

        public static List<BlockPos> getHorizPlane(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int r = radius; r >= 1; --r) {
                blocks.addAll(Positions.getAroundHoriz(centerPos, r, includeCorners));
            }
            blocks.add(centerPos);
            return blocks;
        }

        public static List<BlockPos> getAroundCube(BlockPos startPos) {
            return Positions.getAroundHoriz(startPos, false, startPos.m_7494_(), startPos.m_7495_());
        }

        public static List<BlockPos> getAroundCube(Level level, BlockPos centerPos, BiPredicate<Level, BlockPos> validPos) {
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            for (BlockPos pos : Positions.getAroundCube(centerPos)) {
                if (!validPos.test(level, pos)) continue;
                validPositions.add(pos);
            }
            return validPositions;
        }

        public static List<BlockPos> getAroundCube(BlockPos centerPos, int radius, boolean includeEdges) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int offset = -radius; offset <= radius; ++offset) {
                BlockPos pos = centerPos.m_5484_(Direction.UP, offset);
                if (Math.abs(offset) == Math.abs(radius)) {
                    blocks.addAll(Positions.getHorizPlane(pos, radius, includeEdges));
                    continue;
                }
                blocks.addAll(Positions.getAroundHoriz(pos, radius, includeEdges));
            }
            return blocks;
        }

        public static double getDistance(BlockPos posA, BlockPos posB) {
            return Vect3d.distance(Vect3d.from(posA), Vect3d.from(posB));
        }

        public static BlockPos getLastInLine(LevelReader level, BlockPos startPos, BiPredicate<LevelReader, BlockPos> validation, Direction direction) {
            int offset = 1;
            while (validation.test(level, startPos.m_5484_(direction, offset))) {
                ++offset;
            }
            return startPos.m_5484_(direction, offset - 1);
        }

        public static BlockPos withY(BlockPos pos, int y) {
            return new BlockPos(pos.m_123341_(), y, pos.m_123343_());
        }

        public static BlockPos withY(BlockPos pos, double y) {
            return new BlockPos((double)pos.m_123341_(), y, (double)pos.m_123343_());
        }
    }

    public static class Directions {
        public static final Direction[] CLOCKWISE_HORIZONTALS = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
        protected final List<Direction> directions = new ArrayList<Direction>();

        public static Directions of() {
            return new Directions();
        }

        public Directions add(Direction direction) {
            this.directions.add(direction);
            return this;
        }

        public Directions add(Direction ... directions) {
            this.directions.addAll(Arrays.asList(directions));
            return this;
        }

        public Directions remove(Direction ... directions) {
            for (Direction dir : directions) {
                this.directions.remove(dir);
            }
            return this;
        }

        public Directions all() {
            return this.add(Direction.values());
        }

        public Directions up() {
            return this.add(Direction.UP);
        }

        public Directions down() {
            return this.add(Direction.DOWN);
        }

        public Directions east() {
            return this.add(Direction.EAST);
        }

        public Directions west() {
            return this.add(Direction.WEST);
        }

        public Directions north() {
            return this.add(Direction.NORTH);
        }

        public Directions south() {
            return this.add(Direction.SOUTH);
        }

        public Directions shuffle() {
            Collections.shuffle(this.directions);
            return this;
        }

        public Directions horizontals() {
            return this.add(CLOCKWISE_HORIZONTALS);
        }

        public Directions verticals() {
            return this.add(Direction.UP, Direction.DOWN);
        }

        public List<Direction> toList() {
            return new ArrayList<Direction>(this.directions);
        }

        public Stream<Direction> toStream() {
            return this.directions.stream();
        }

        public Direction[] toArray() {
            return this.directions.toArray(new Direction[0]);
        }
    }
}

