function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/simibubi/create/content/contraptions/components/fan/AirCurrent',
		'methodName' : 'findAffectedHandlers', 
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/minecraft/core/BlockPos',
		'methodName' : resolveName('m_6625_'), // below
		'methodDesc' : '(I)Lnet/minecraft/core/BlockPos;'
	}

	var direction = {
		'class' : 'com/simibubi/create/content/contraptions/components/fan/AirCurrent',
		'fieldName' : 'direction', 
		'fieldDesc' : 'Lnet/minecraft/core/Direction;'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Create',
		'methodName' : 'handleAirCurrent',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)V'
	}

	var instructions = [ 
		insnDup("pos"),
		insnLoadObj(1, "world"),
		insnSwap("world, pos"),
		insnLoadThis("air current"),
		insnGetField(direction),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}