function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'blusunrize/immersiveengineering/common/blocks/stone/FurnaceLikeBlockEntity',
		'methodName' : 'tickServer',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'blusunrize/immersiveengineering/common/util/Utils',
		'methodName' : 'modifyInvStackSize',
		'methodDesc' : '(Lnet/minecraft/core/NonNullList;II)V'
	}

	var inventory = {
		'class' : 'blusunrize/immersiveengineering/common/blocks/stone/FurnaceLikeBlockEntity',
		'fieldName' : 'inventory',
		'fieldDesc' : 'Lnet/minecraft/core/NonNullList;'
	}

	var listGet = {
		'class' : 'net/minecraft/core/NonNullList',
		'methodName' : resolveName('get'), // get
		'methodDesc' : '(I)Ljava/lang/Object;'
	}

	var fuelSlot = {
		'class' : 'blusunrize/immersiveengineering/common/blocks/stone/FurnaceLikeBlockEntity',
		'fieldName' : 'fuelSlot',
		'fieldDesc' : 'I'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnLoadThis("tile"),
		insnGetField(inventory),
		insnLoadThis("tile"),
		insnGetField(fuelSlot),
		insnInvokeVirtual(listGet),
		insnCheckCast("net/minecraft/world/item/ItemStack"),
		insnPushValue(1, "set fuel amount"),
		insnLoadThis("furnace like tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}