function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/entity/animal/horse/AbstractHorse',
		'methodName' : resolveName('m_30580_'), // fedFood
		'methodDesc' : '(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/InteractionResult;'
	}

    var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : resolveName('m_41774_'), // shrink
		'methodDesc' : '(I)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFoodConsumed',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/animal/Animal;)V'
	}

	var instructions = [ 
		insnLoadThis("horse"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, [].concat(instructionsDupValue2("food stack"), instructions));
				return method;
			}
		}
	}
}