/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.events;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public abstract class RandomTickEvent<T>
extends Event {
    private final ServerLevel level;
    private final BlockPos pos;
    private final T state;

    public RandomTickEvent(ServerLevel level, BlockPos pos, T state) {
        this.level = level;
        this.pos = pos;
        this.state = state;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public T getState() {
        return this.state;
    }

    public static final boolean onRandomTickBlock(ServerLevel level, BlockPos pos, BlockState state) {
        return MinecraftForge.EVENT_BUS.post((Event)new Block(level, pos, state));
    }

    public static final boolean onRandomTickFluid(Level level, BlockPos pos, FluidState state) {
        return level instanceof ServerLevel && MinecraftForge.EVENT_BUS.post((Event)new Fluid((ServerLevel)level, pos, state));
    }

    @Cancelable
    public static class Block
    extends RandomTickEvent<BlockState> {
        public Block(ServerLevel level, BlockPos pos, BlockState state) {
            super(level, pos, state);
        }
    }

    @Cancelable
    public static class Fluid
    extends RandomTickEvent<FluidState> {
        public Fluid(ServerLevel level, BlockPos pos, FluidState state) {
            super(level, pos, state);
        }
    }
}

