/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;

public class Create {
    public static boolean inWorldProcessingEmissions = true;

    public static final void handleInWorldProcessing(ItemEntity entity, int type) {
        if (!inWorldProcessingEmissions) {
            return;
        }
        if (type == 0 || type == 1) {
            WorldEvents.onItemBurned(entity.m_32055_(), entity.f_19853_, entity.m_142538_());
        }
    }

    public static final void handleAirCurrent(Level worldIn, BlockPos pos, Direction airDirection) {
        ServerLevel world;
        BlockState state;
        Block block;
        if (worldIn instanceof ServerLevel && (block = (state = (world = (ServerLevel)worldIn).m_8055_(pos)).m_60734_()) instanceof AbstractGas) {
            AbstractGas gas = (AbstractGas)block;
            Spread spread = gas.createSpread(world, pos, state);
            int delta = Integer.MIN_VALUE;
            spread.in(airDirection, delta);
            if (!spread.completed()) {
                for (Direction direction : GameWorld.Directions.of().all().remove(new Direction[]{airDirection, airDirection.m_122424_()}).shuffle().toArray()) {
                    spread.in(direction, delta);
                    if (spread.completed()) break;
                }
            }
            spread.apply();
        }
    }

    public static class Millstone
    extends Emitter {
        public Millstone(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
            if (nbtSource != null && super.isActive(nbtSource)) {
                CompoundTag compound = TagHelper.serialize(nbtSource);
                float speed = compound.m_128457_("Speed");
                if (speed == 0.0f) {
                    return false;
                }
                CompoundTag inventoryTag = TagHelper.getNestedCompound((CompoundTag)compound, (String)"InputInventory");
                int itemsCount = inventoryTag != null ? inventoryTag.m_128437_("Items", 10).size() : 0;
                return itemsCount > 0;
            }
            return false;
        }
    }
}

