/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class Weather2 {
    private static Weather2 instance;
    protected final Class<?> serverTickHandler;
    protected final Class<?> clientTickHandler;
    protected final Class<?> weatherManager;
    protected final Class<?> windManager;
    protected final Method getServerWeatherManager;
    protected final Method getClientWeatherManager;
    protected final Method getWindManager;
    protected final Method getWindForce;

    private Weather2() throws ClassNotFoundException, NoSuchMethodException {
        boolean isClient = FMLEnvironment.dist.isClient();
        this.serverTickHandler = Class.forName("weather2.ServerTickHandler");
        this.getServerWeatherManager = this.serverTickHandler.getMethod("getWeatherManagerFor", ResourceKey.class);
        this.clientTickHandler = isClient ? Class.forName("weather2.ClientTickHandler") : null;
        this.getClientWeatherManager = isClient ? this.clientTickHandler.getMethod("getClientWeather", new Class[0]) : null;
        this.weatherManager = Class.forName("weather2.weathersystem.WeatherManager");
        this.getWindManager = this.weatherManager.getMethod("getWindManager", new Class[0]);
        this.windManager = Class.forName("weather2.weathersystem.wind.WindManager");
        this.getWindForce = this.windManager.getMethod("getWindForce", new Class[0]);
    }

    public static void initialize() {
        if (instance == null && ModList.get().isLoaded("weather2")) {
            try {
                instance = new Weather2();
            }
            catch (Exception e) {
                ForgeEndertech.getInstance().getLogger().error(e.toString());
            }
        }
    }

    public static boolean isLoaded() {
        return instance != null;
    }

    protected Vec3 getWindForce(Level level) throws InvocationTargetException, IllegalAccessException {
        Object weatherManager = level.m_5776_() ? this.getClientWeatherManager.invoke(null, new Object[0]) : this.getServerWeatherManager.invoke(null, level.m_46472_());
        Object windManager = this.getWindManager.invoke(weatherManager, new Object[0]);
        return (Vec3)this.getWindForce.invoke(windManager, new Object[0]);
    }

    public static Optional<IWind> getWindAt(Level level, BlockPos pos) {
        if (instance != null && level != null && pos != null) {
            try {
                Vec3 windForce = instance.getWindForce(level);
                Wind.StaticWind wind = new Wind.StaticWind(Vect3d.from((Vec3)windForce));
                return Optional.of(wind);
            }
            catch (Exception e) {
                ForgeEndertech.debugMsg((String)e.toString());
            }
        }
        return Optional.empty();
    }
}

