/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerEvents {
    private static final GameTime PLAYER_UPDATE_INTERVAL = GameTime.quaterSecond();
    private static final GameTime IGNITION_FROM_TORCH_CHECK_INTERVAL = GameTime.second();

    static Optional<Player> getServerPlayer(LivingEvent event) {
        Entity entity = event.getEntity();
        if (!event.isCanceled() && entity instanceof Player && ForgeEntity.isServerSide((Entity)entity)) {
            return Optional.of((Player)entity);
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().m_8055_(event.getPos()).m_60734_();
        if (block == Blocks.f_50145_) {
            AdPother.getInstance().respirators.findOn(event.getEntityLiving(), false).ifPresent(pair -> {
                ItemStack stack = (ItemStack)pair.getLeft();
                Respirators.Respirator respirator = (Respirators.Respirator)pair.getRight();
                if (!respirator.allowsEating(stack)) {
                    event.setUseBlock(Event.Result.DENY);
                } else {
                    Player player = PlayerEvents.getServerPlayer((LivingEvent)event).orElse(null);
                    if (player != null && player.m_36391_(false)) {
                        AdPother.getInstance().sources.playerEating.get().emitFrom(player, 2.0f);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        LivingEntity living = event.getEntityLiving();
        AdPother.getInstance().respirators.findOn(living, false).ifPresent(pair -> {
            ItemStack heldStack;
            Respirators.Respirator respirator = (Respirators.Respirator)pair.getRight();
            if (!(respirator.allowsEating((ItemStack)pair.getLeft()) || (heldStack = event.getItemStack()).m_41780_() != UseAnim.DRINK && heldStack.m_41780_() != UseAnim.EAT)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.FAIL);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (stack.m_41780_() == UseAnim.EAT) {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> AdPother.getInstance().sources.playerEating.get().emitFrom((Player)player, stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeath(LivingDeathEvent event) {
        Sources sources = AdPother.getInstance().sources;
        if (event.getSource().m_19384_()) {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> sources.playerBurning.get().emitFrom(player, 1.0f));
        } else {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> sources.playerDeath.get().emitFrom(player, 1.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getPlayer();
        if (player == null || stack.m_41619_()) {
            return;
        }
        Respirators.Respirator respirator = AdPother.getInstance().respirators.get(stack).orElse(null);
        if (respirator != null && player.f_19853_ != null) {
            respirator.appendHoverText(stack, player.f_19853_, event.getToolTip(), event.getFlags());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerBreaksBlock(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getPlayer().m_7500_()) {
            return;
        }
        Level level = player.f_19853_;
        if (level == null || !GameWorld.isServerSide((LevelReader)level)) {
            return;
        }
        int silkLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
        if (silkLevel > 0) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        WorldEvents.onBlockBroken(level, pos, state);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.side.isServer()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level world = player.f_19853_;
        if (world == null) {
            return;
        }
        if (IGNITION_FROM_TORCH_CHECK_INTERVAL.pastIn(world)) {
            GasExplosion.fromHeldTorch(player).tryExplode();
        }
        if (!PLAYER_UPDATE_INTERVAL.pastIn(world)) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        pollution.update();
        boolean explosionRisk = GasExplosion.in(world).positions(GasExplosion.getIgnitablePositionsAround(player, EnumSet.allOf(InteractionHand.class))).tryTrigger();
        pollution.setExplosionRisk(explosionRisk);
        if (world instanceof ServerLevelAccessor) {
            new EntityPollution.NetMsg(pollution).sendToAllAround((ServerLevelAccessor)world, player.m_142538_(), 64);
        }
    }
}

