/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.events.BlockStateChangeEvent;
import com.endertech.minecraft.forge.events.RandomTickEvent;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;

@Mod.EventBusSubscriber
public class WorldEvents {
    public static boolean loggingFuelConsumption = false;
    public static boolean loggingFoodConsumption = false;
    public static boolean furnaceEmissions = true;
    public static boolean burntBlockEmissions = true;
    public static float burntItemEmissionRate = 1.0f;

    @SubscribeEvent
    public static void onWorldLoaded(WorldEvent.Load event) {
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        WorldData.removeDataFor(event.getWorld());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Level world = event.world;
        if (GameWorld.isServerSide((LevelReader)world)) {
            WorldData data = WorldData.getData(world);
            data.tick();
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Level level = event.getWorld();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Entity entity = event.getEntity();
            WorldData data = WorldData.getData((Level)level2);
            data.addIfDroppedTorch(level2, entity);
            data.addIfEmitter(level2, entity);
        }
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveWorldEvent event) {
        Entity entity = event.getEntity();
        Level level = event.getWorld();
        WorldData data = WorldData.getData(level);
        data.removePollutionInfoFor(entity);
        if (GameWorld.isServerSide((LevelReader)level)) {
            data.removePeriodicEmissionFor(entity);
            data.removeIfDroppedTorch(entity);
        }
    }

    @SubscribeEvent
    public static void onBlockChange(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            BlockEntity tile = level.m_7702_(pos);
            BlockState state = event.getState();
            if (tile != null) {
                WorldData.getData((Level)level).addIfEmitter(level, pos, state, tile);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockStateChange(BlockStateChangeEvent event) {
        WorldData.tryChangePollutionLevelBy(event.getLevel(), event.getPos(), event.getOldState(), -1);
        WorldData.tryChangePollutionLevelBy(event.getLevel(), event.getPos(), event.getNewState(), 1);
    }

    @SubscribeEvent
    public static void onBlockRandomTick(RandomTickEvent.Block event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = (BlockState)event.getState();
        AdPother mod = AdPother.getInstance();
        if (Torch.rate > 0.0f) {
            mod.torches.get(state).ifPresent(torch -> torch.emitAt(level, pos));
        }
        mod.emitters.get((LevelReader)level, pos).ifPresent(emitter -> {
            if (emitter.getType().isBlock() && emitter.isActive((LevelReader)level, pos)) {
                emitter.emitAt(level, pos);
            }
        });
    }

    @SubscribeEvent
    public static void onFluidRandomTick(RandomTickEvent.Fluid event) {
        AdPother.getInstance().impacts.fluidImpacts.get().doImpacts((FluidState)event.getState(), event.getLevel(), event.getPos());
    }

    public static final void onBlockBroken(Level world, BlockPos pos, BlockState state) {
        AdPother.getInstance().breakables.get(state).ifPresent(breakable -> breakable.emitAt(world, pos));
    }

    public static final void onFoodConsumed(ItemLike food, int amount, Entity entity) {
        WorldEvents.onFoodConsumed(new ItemStack(food, 1), amount, entity);
    }

    public static final void onFoodConsumed(ItemStack food, int amount, Entity entity) {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            if (!entity.m_183503_().m_5776_()) {
                WorldEvents.logConsumedFood(food.m_41720_(), amount, entity.m_6095_());
                AdPother.getInstance().sources.animalFeeding.get().emitFrom(animal, food, amount);
            }
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, BlockEntity tile) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack, stack.getAmount(), tile);
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, int amount, BlockEntity tile) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack.getFluid(), amount, tile);
        }
    }

    public static final void onFuelBurned(@Nullable Fluid fluid, int amount, BlockEntity tile) {
        if (fluid != null) {
            Optional<Fuel> fuel = WorldEvents.asFuel(fluid);
            WorldEvents.logConsumedFuel(fluid, fuel, amount, tile.m_58903_());
            if (fuel.isPresent()) {
                WorldEvents.onFuelBurned(fuel.get(), amount, tile);
            }
        }
    }

    private static Optional<Fuel> asFuel(@Nullable Fluid fluid) {
        return fluid != null ? AdPother.getInstance().fuels.get(fluid) : Optional.empty();
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, Entity entity, Alignment alignment) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack, stack.getAmount(), entity, alignment);
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, int amount, Entity entity, Alignment alignment) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack.getFluid(), amount, entity, alignment);
        }
    }

    public static final void onFuelBurned(@Nullable Fluid fluid, int amount, Entity entity, Alignment alignment) {
        if (fluid != null) {
            Optional<Fuel> fuel = WorldEvents.asFuel(fluid);
            WorldEvents.logConsumedFuel(fluid, fuel, amount, entity.m_6095_());
            if (fuel.isPresent()) {
                WorldEvents.onFuelBurned(fuel.get(), amount, entity, alignment);
            }
        }
    }

    private static Optional<Fuel> asFuel(ItemStack stack) {
        return AdPother.getInstance().fuels.get(stack);
    }

    public static final void onFuelBurned(ItemStack stack, int amount, BlockEntity tile) {
        Optional<Fuel> fuel = WorldEvents.asFuel(stack);
        WorldEvents.logConsumedFuel(stack.m_41720_(), fuel, amount, tile.m_58903_());
        if (fuel.isPresent()) {
            WorldEvents.onFuelBurned(fuel.get(), amount, tile);
        }
    }

    private static void logConsumedFuel(ForgeRegistryEntry<?> consumable, Optional<Fuel> fuel, int amount, ForgeRegistryEntry<?> consumer) {
        if (loggingFuelConsumption) {
            AdPother.getInstance().getLogger().info(consumer.getRegistryName() + " consumed " + amount + "x " + consumable.getRegistryName() + " (" + fuel.map(f -> f.getRelatedId().toString()).orElse("no fuel") + ")");
        }
    }

    private static void logConsumedFood(ForgeRegistryEntry<?> consumable, int amount, ForgeRegistryEntry<?> consumer) {
        if (loggingFoodConsumption) {
            AdPother.getInstance().getLogger().info(consumer.getRegistryName() + " consumed " + amount + "x " + consumable.getRegistryName());
        }
    }

    private static void logNoEmitter(ForgeRegistryEntry<?> consumer) {
        if (loggingFuelConsumption) {
            AdPother.getInstance().getLogger().info("Emitter not found for " + consumer.getRegistryName() + " (no config or incorrect ID)");
        }
    }

    public static final void onFuelBurned(ItemStack stack, int amount, Entity entity, Alignment alignment) {
        Optional<Fuel> fuel = WorldEvents.asFuel(stack);
        WorldEvents.logConsumedFuel(stack.m_41720_(), fuel, amount, entity.m_6095_());
        if (fuel.isPresent()) {
            WorldEvents.onFuelBurned(fuel.get(), amount, entity, alignment);
        }
    }

    public static final void onFuelBurned(Fuel fuel, int amount, BlockEntity tile) {
        Level level = tile.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos pos = tile.m_58899_();
            Emitter emitter = AdPother.getInstance().emitters.get((LevelReader)level2, pos).orElse(null);
            if (emitter != null) {
                ChunkPollution pollution = WorldData.getChunkPollution((Level)level2, pos);
                pollution.increaseBy(emitter, IEmitter.Type.TILE, level2, pos, fuel, amount);
            } else {
                WorldEvents.logNoEmitter(tile.m_58903_());
            }
        }
    }

    public static final void onFuelBurned(Fuel fuel, int amount, Entity entity, Alignment alignment) {
        Level level = entity.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Emitter emitter = AdPother.getInstance().emitters.get(entity).orElse(null);
            if (emitter != null) {
                BlockPos pos = new BlockPos(alignment.getPositionVec(entity));
                ChunkPollution pollution = WorldData.getChunkPollution((Level)level2, pos);
                pollution.increaseBy(emitter, IEmitter.Type.ENTITY, level2, pos, fuel, amount);
            } else {
                WorldEvents.logNoEmitter(entity.m_6095_());
            }
        }
    }

    @SubscribeEvent
    public static void onLavaTouchedWater(BlockEvent.FluidPlaceBlockEvent event) {
        BlockPos blockpos;
        Predicate<BlockPos> isWaterOrLava;
        LevelAccessor level = event.getWorld();
        if (level instanceof ServerLevel && (isWaterOrLava = pos -> {
            FluidState state = level.m_6425_(pos);
            return state.m_205070_(FluidTags.f_13131_) || state.m_205070_(FluidTags.f_13132_);
        }).test(blockpos = event.getPos()) && isWaterOrLava.test(event.getLiquidPos())) {
            AdPother.getInstance().sources.lavaTouchingWater.get().emitAt((Level)((ServerLevel)level), blockpos.m_7494_());
        }
    }

    public static final void onBlockExploded(Level world, BlockPos pos, BlockState state, Explosion explosion) {
        if (!GameWorld.isServerSide((LevelReader)world)) {
            return;
        }
        AdPother.getInstance().sources.explosion.get().emitAt(world, pos);
        WorldEvents.onBlockBroken(world, pos, state);
        if (state.isFlammable((BlockGetter)world, pos, Direction.UP)) {
            WorldEvents.onBlockBurned(state, world, pos);
        }
    }

    public static final void onFurnaceFuelBurned(ItemStack stack, int amount, BlockEntity tile) {
        if (!furnaceEmissions) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof BucketItem) {
            Fluid fluid = ((BucketItem)item).getFluid();
            WorldEvents.onFuelBurned(fluid, 1000 * amount, tile);
        } else {
            WorldEvents.onFuelBurned(stack, amount, tile);
        }
    }

    public static final void onBlockBurned(BlockState state, Level world, BlockPos pos) {
        if (burntBlockEmissions && GameWorld.isServerSide((LevelReader)world)) {
            AdPother.getInstance().fuels.get(state).ifPresent(fuel -> fuel.emitAt(world, pos));
        }
    }

    public static final void onItemBurned(ItemStack stack, Level world, BlockPos pos) {
        Optional<Fuel> fuel;
        if (burntItemEmissionRate > 0.0f && GameWorld.isServerSide((LevelReader)world) && (fuel = WorldEvents.asFuel(stack)).isPresent()) {
            fuel.get().emitAt(world, pos, (float)stack.m_41613_() * burntItemEmissionRate);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Alignment {
        TOP{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_142469_().m_82399_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            }
        }
        ,
        CENTER{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_142469_().m_82399_();
            }
        }
        ,
        BOTTOM{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_142469_().m_82399_().m_82492_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            }
        }
        ,
        FRONT{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_142469_().m_82399_().m_82549_(entity.m_20154_().m_82490_((double)(entity.m_20206_() / 2.0f)));
            }
        }
        ,
        BACK{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_142469_().m_82399_().m_82546_(entity.m_20154_().m_82490_((double)(entity.m_20205_() / 2.0f)));
            }
        };


        public abstract Vec3 getPositionVec(Entity var1);
    }
}

