/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.Weather2;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.emissions.DelayedTileEmission;
import com.endertech.minecraft.mods.adpother.emissions.PeriodicEntityEmission;
import com.endertech.minecraft.mods.adpother.emissions.PeriodicTileEmission;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.AbstractPollution;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.Stats;
import com.endertech.minecraft.mods.adpother.sources.DroppedTorch;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldData {
    public static IntBounds altitudeBounds = GameBounds.HEIGHT.getIntBounds();
    private static final Map<Level, WorldData> DATA_FOR_WORLD = new ConcurrentHashMap<Level, WorldData>();
    protected final Map<ChunkLoc, ChunkPollution> pollutionForChunk = new ConcurrentHashMap<ChunkLoc, ChunkPollution>();
    protected final Map<Entity, EntityPollution> pollutionForEntity = new ConcurrentHashMap<Entity, EntityPollution>();
    protected final Map<BlockEntity, DelayedTileEmission> delayedTileEmissions = new ConcurrentHashMap<BlockEntity, DelayedTileEmission>();
    protected final Map<BlockEntity, PeriodicTileEmission> periodicTileEmissions = new ConcurrentHashMap<BlockEntity, PeriodicTileEmission>();
    protected final Map<Entity, PeriodicEntityEmission> periodicEntityEmissions = new ConcurrentHashMap<Entity, PeriodicEntityEmission>();
    protected final Map<ItemEntity, DroppedTorch> droppedTorches = new ConcurrentHashMap<ItemEntity, DroppedTorch>();
    public final Level level;
    private CommonTime.Stamp lastEmptyInfoCleanup = CommonTime.Stamp.now();

    protected WorldData(Level level) {
        this.level = level;
    }

    @Nonnull
    public static WorldData getData(Level level) {
        return DATA_FOR_WORLD.computeIfAbsent(level, WorldData::new);
    }

    @Nonnull
    public static ChunkPollution getChunkPollution(Level level, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkLoc location = ChunkLoc.from((Level)level, (ChunkPos)chunkPos);
        return WorldData.getChunkPollution(level, location);
    }

    @Nonnull
    public static ChunkPollution getChunkPollution(Level world, ChunkLoc location) {
        WorldData data = WorldData.getData(world);
        ChunkPollution pollution = data.pollutionForChunk.computeIfAbsent(location, ChunkPollution::new);
        return pollution;
    }

    public static IWind getWindAt(Level level, BlockPos pos) {
        Optional<IWind> wind;
        if (Weather2.isLoaded() && (wind = Weather2.getWindAt(level, pos)).isPresent()) {
            return wind.get();
        }
        return GameWorld.getWindAt((Level)level, (BlockPos)pos);
    }

    @Nonnull
    public static EntityPollution getEntityPollution(Entity entity) {
        Level world = entity.f_19853_;
        WorldData data = WorldData.getData(world);
        return data.pollutionForEntity.computeIfAbsent(entity, EntityPollution::of);
    }

    public static void initBiomeConfigs() {
        AdPother mod = AdPother.getInstance();
        ForgeRegistries.BIOMES.getEntries().stream().map(entry -> BiomeId.from((ResourceKey)((ResourceKey)entry.getKey()))).forEach(biomeId -> Biomes.createConfigFor((AbstractForgeMod)mod, (BiomeId)biomeId, (boolean)false).save());
        for (Path path : UnitConfig.listCustomConfigs((Path)Biomes.getConfigsBaseDir((AbstractForgeMod)mod), null)) {
            UnitConfig config = new UnitConfig(path.toFile());
            BiomeId biomeId2 = Biomes.readBiomeId((UnitConfig)config);
            boolean enabled = Biomes.isConfigEnabled((UnitConfig)config);
            if (!biomeId2.isEmpty()) {
                for (Pollutant pollutant : AdPother.getInstance().pollutants.streamAll().toList()) {
                    pollutant.getBiomeProperties().forEach(prop -> prop.putValueFrom(config, (Object)biomeId2, enabled));
                }
            }
            config.save();
        }
    }

    public static void removeDataFor(LevelAccessor world) {
        DATA_FOR_WORLD.remove(world);
    }

    public static void scheduleEmissionFor(BlockEntity tile, Emitter emitter, Pollutant<?> pollutant, int amount) {
        Level world = tile.m_58904_();
        if (world != null && GameWorld.isServerSide((LevelReader)world)) {
            WorldData data = WorldData.getData(world);
            DelayedTileEmission emission = data.delayedTileEmissions.get(tile);
            if (emission != null && emission.exists()) {
                emission.add(pollutant, amount);
            } else {
                emission = DelayedTileEmission.of(tile, emitter, pollutant, amount);
                data.delayedTileEmissions.put(tile, emission);
            }
        }
    }

    public static void tryChangePollutionLevelBy(ServerLevel level, BlockPos pos, BlockState state, int amount) {
        if (state != null && state.m_60734_() instanceof Pollutant) {
            WorldData.getChunkPollution((Level)level, pos).increaseBy(level, pos, state, amount);
        }
    }

    public void addIfEmitter(ServerLevel level, BlockPos pos, BlockState state, BlockEntity tile) {
        Emitter emitter = AdPother.getInstance().emitters.get(state).orElse(null);
        if (emitter != null && emitter.getType().isTile() && emitter.isIdentified((INBTSerializable)tile)) {
            this.periodicTileEmissions.put(tile, PeriodicTileEmission.of(tile, emitter));
        }
    }

    public void addIfEmitter(ServerLevel level, Entity entity) {
        Emitter emitter = AdPother.getInstance().emitters.get(entity).orElse(null);
        if (emitter != null && emitter.getType().isEntity() && emitter.isIdentified((INBTSerializable)entity)) {
            this.periodicEntityEmissions.put(entity, PeriodicEntityEmission.of(entity, emitter));
        }
    }

    public void addIfDroppedTorch(ServerLevel level, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            AdPother.getInstance().torches.get(itemEntity.m_32055_()).ifPresent(torch -> this.droppedTorches.put(itemEntity, DroppedTorch.of(itemEntity, torch)));
        }
    }

    public static boolean isIgnitionSource(Level level, BlockPos pos) {
        AdPother mod = AdPother.getInstance();
        BlockState state = level.m_8055_(pos);
        if (state.m_204336_(BlockTags.f_13076_)) {
            return true;
        }
        if (state.m_60819_().m_205070_(FluidTags.f_13132_)) {
            return true;
        }
        if (mod.torches.get(state).isPresent()) {
            return true;
        }
        Emitter emitter = mod.emitters.get((LevelReader)level, pos).orElse(null);
        return emitter != null && emitter.isActive((LevelReader)level, pos) && (emitter.getType() == IEmitter.Type.FUEL || emitter.getEmissionOf(Pollutants.BuiltIn.CARBON.get()) > 0.0f || emitter.getEmissionOf(Pollutants.BuiltIn.SULFUR.get()) > 0.0f);
    }

    public void removePeriodicEmissionFor(Entity entity) {
        this.periodicEntityEmissions.remove(entity);
    }

    public void removeTileEmissionsIn(LevelChunk chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        Consumer<Collection> removeIfInChunk = collection -> {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BlockEntity tile = (BlockEntity)iterator.next();
                ChunkPos tilePos = new ChunkPos(tile.m_58899_());
                if (!chunkPos.equals((Object)tilePos)) continue;
                iterator.remove();
            }
        };
        removeIfInChunk.accept(this.periodicTileEmissions.keySet());
        removeIfInChunk.accept(this.delayedTileEmissions.keySet());
    }

    public void tick() {
        AbstractEntityEmission emission;
        Iterator<Object> iterator = this.delayedTileEmissions.values().iterator();
        while (iterator.hasNext()) {
            emission = iterator.next();
            if (emission.exists()) {
                emission.tick();
                continue;
            }
            iterator.remove();
        }
        iterator = this.periodicTileEmissions.values().iterator();
        while (iterator.hasNext()) {
            emission = (PeriodicTileEmission)iterator.next();
            if (emission.exists()) {
                emission.tick();
                continue;
            }
            iterator.remove();
        }
        iterator = this.periodicEntityEmissions.values().iterator();
        while (iterator.hasNext()) {
            emission = (PeriodicEntityEmission)iterator.next();
            if (emission.exists()) {
                emission.tick();
                continue;
            }
            iterator.remove();
        }
        iterator = this.droppedTorches.values().iterator();
        while (iterator.hasNext()) {
            DroppedTorch torch = (DroppedTorch)iterator.next();
            if (torch.exists()) {
                torch.tick();
                continue;
            }
            iterator.remove();
        }
        iterator = this.pollutionForEntity.values().iterator();
        while (iterator.hasNext()) {
            EntityPollution pollution = (EntityPollution)iterator.next();
            if (pollution.exists()) {
                pollution.tick();
                continue;
            }
            iterator.remove();
        }
    }

    public void reloadEmitters() {
        ArrayList<PeriodicTileEmission> savedTileEmissions = new ArrayList<PeriodicTileEmission>(this.periodicTileEmissions.values());
        ArrayList<PeriodicEntityEmission> savedEntityEmissions = new ArrayList<PeriodicEntityEmission>(this.periodicEntityEmissions.values());
        this.periodicTileEmissions.clear();
        this.periodicEntityEmissions.clear();
        AdPother.getInstance().emitters.reloadConfigs();
        for (PeriodicTileEmission periodicTileEmission : savedTileEmissions) {
            BlockEntity tile = (BlockEntity)periodicTileEmission.getEntity();
            if (this.level != tile.m_58904_() || !(this.level instanceof ServerLevel)) continue;
            this.addIfEmitter((ServerLevel)this.level, tile.m_58899_(), tile.m_58900_(), tile);
        }
        for (PeriodicEntityEmission periodicEntityEmission : savedEntityEmissions) {
            Entity entity = (Entity)periodicEntityEmission.getEntity();
            if (this.level != entity.f_19853_ || !(this.level instanceof ServerLevel)) continue;
            this.addIfEmitter((ServerLevel)this.level, entity);
        }
    }

    public void reloadTorches() {
        ArrayList<DroppedTorch> savedTorches = new ArrayList<DroppedTorch>(this.droppedTorches.values());
        this.droppedTorches.clear();
        AdPother.getInstance().torches.reloadConfigs();
        for (DroppedTorch torch : savedTorches) {
            ItemEntity entity = (ItemEntity)torch.getEntity();
            if (this.level != entity.f_19853_ || !(this.level instanceof ServerLevel)) continue;
            this.addIfDroppedTorch((ServerLevel)this.level, (Entity)entity);
        }
    }

    public void removeIfDroppedTorch(Entity entity) {
        if (entity instanceof ItemEntity) {
            this.droppedTorches.remove(entity);
        }
    }

    public void removePollutionInfoAt(ChunkLoc location) {
        this.pollutionForChunk.remove(location);
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastEmptyInfoCleanup).moreThan(CommonTime.Interval.minutes((double)3.0))) {
            this.lastEmptyInfoCleanup = CommonTime.Stamp.now();
            this.pollutionForChunk.values().removeIf(pollution -> pollution.isEmpty());
        }
    }

    public void removePollutionInfoFor(Entity entity) {
        this.pollutionForEntity.remove(entity);
    }

    public Stats getStats(ChatFormatting textColor, ChatFormatting valueColor) {
        Stats stats = Stats.of(textColor, valueColor);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            EntityTypeTest typeTest = EntityTypeTest.m_156916_(GasEntity.class);
            stats.group("GasEntities").value("stuck", server.m_143280_(typeTest, GasEntity::isStuck).size()).value("lost", server.m_143280_(typeTest, gas -> !server.m_143340_(gas.m_142538_())).size()).value("total", server.m_143280_(typeTest, gas -> true).size());
        }
        stats.group("TileEmissions").value("periodic", this.periodicTileEmissions.size()).value("delayed", this.delayedTileEmissions.size());
        stats.group("EntityEmissions").value("periodic", this.periodicEntityEmissions.size());
        stats.group("Torches").value("dropped", this.droppedTorches.size());
        stats.group("PollutionData").value("chunk", this.pollutionForChunk.size()).value("entity", this.pollutionForEntity.size()).value("empty", this.pollutionForChunk.values().stream().filter(AbstractPollution::isEmpty).mapToInt(p -> 1).sum());
        stats.group("ScheduledUpdates");
        stats.value("block", this.level.m_183326_().m_183574_());
        stats.value("fluid", this.level.m_183324_().m_183574_());
        return stats;
    }
}

