/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adpother.config.EntityBlackWhiteList;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class LivingSourceBase<E extends LivingEntity>
extends SourceBase
implements IPostInit {
    protected final Optional<EntityBlackWhiteList> livings;

    public LivingSourceBase(UnitConfig config, Properties<?> props) {
        super(config, props);
        this.livings = props.livingsListName.isEmpty() ? Optional.empty() : Optional.of(new EntityBlackWhiteList(config, this.getClassCategory(), props.livingsListName));
    }

    public void emitFrom(E living, float factor) {
        if (this.livings.isPresent() && !this.livings.get().isAllowed((Entity)living)) {
            return;
        }
        float weight = ForgeEntity.getWeight(living, (boolean)false);
        float amount = factor * weight;
        if (CommonMath.isAlmostZero((double)amount)) {
            return;
        }
        this.emitAt(((LivingEntity)living).f_19853_, this.getOutletPosition(living), amount);
    }

    public BlockPos getOutletPosition(E living) {
        ServerLevel level;
        Direction facing = living.m_6350_().m_122424_();
        BlockPos livingPos = living.m_142538_();
        BlockPos behindPos = livingPos.m_142300_(facing);
        Level level2 = ((LivingEntity)living).f_19853_;
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).m_143340_(behindPos) && level.m_46859_(behindPos)) {
            return behindPos;
        }
        return livingPos;
    }

    public void onPostInit() {
        if (this.livings.isPresent()) {
            this.livings.get().loadData();
            this.saveConfig();
        }
    }

    public static class Properties<T extends Properties<T>>
    extends SourceBase.Properties<T> {
        public String livingsListName = "";

        public static Properties<?> of() {
            return new Properties<Properties>(Properties.class);
        }

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T livingsList(String name) {
            this.livingsListName = name;
            return (T)((Object)((Properties)this.self));
        }
    }
}

