function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'dev/alexnijjar/extractinator/blocks/ExtractinatorBlockEntity',
		'methodName' : 'extractBlockAbove',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/minecraft/world/level/Level',
		'methodName' : resolveName('m_46961_'), // destroyBlock
		'methodDesc' : '(Lnet/minecraft/core/BlockPos;Z)Z'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Extractinator',
		'methodName' : 'onExtraction',
		'methodDesc' : '(Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnLoadThis("extractinator"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}