/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.world.Wind;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;

abstract class UserAgent
implements CommonCollect.IWeighted {
    static final String NONE = "";
    static final String KHTML_LIKE_GECKO = "KHTML, like Gecko";
    protected final String mozillaVersion;
    protected final String agentVersion;
    protected final String platformVersion;

    static UserAgent get(IntBounds firefox, String ... chrome) {
        CommonCollect.WeightedList agents = new CommonCollect.WeightedList();
        Random rand = new Random(Wind.randomSeed);
        UserAgent.listFirefox(firefox).forEach(agents::add);
        UserAgent.listChrome(chrome).forEach(agents::add);
        return (UserAgent)agents.getRandom(rand::nextDouble).orElseThrow();
    }

    private static List<UserAgent> listChrome(String ... versions) {
        return Stream.of(versions).map(ver -> new UserAgent("5.0", (String)ver, "537.36"){

            @Override
            protected String systemDetails() {
                return this.isOsLinux() ? this.systemLinux(UserAgent.NONE) : this.systemWindowsNT(true);
            }

            @Override
            protected String platform() {
                return this.platformAppleWebKit();
            }

            @Override
            protected String platformDetails() {
                return UserAgent.KHTML_LIKE_GECKO;
            }

            @Override
            protected String extensions() {
                return this.joinMain(this.extensionChrome(this.agentVersion), this.extensionSafari(this.platformVersion));
            }

            @Override
            public int getWeight() {
                return 2800000;
            }
        }).collect(Collectors.toList());
    }

    private static List<UserAgent> listFirefox(IntBounds versions) {
        return Lists.reverse(IntStream.rangeClosed(versions.getMin(), versions.getMax()).mapToObj(version -> new UserAgent("5.0", version + ".0", "20100101"){

            @Override
            protected String systemDetails() {
                return this.joinDetails(this.isOsLinux() ? this.systemLinux(UserAgent.NONE) : this.systemWindowsNT(true), this.revision(this.agentVersion));
            }

            @Override
            protected String platform() {
                return this.platformGecko();
            }

            @Override
            protected String platformDetails() {
                return UserAgent.NONE;
            }

            @Override
            protected String extensions() {
                return this.extensionFirefox(this.agentVersion);
            }

            @Override
            public int getWeight() {
                return 411000;
            }
        }).collect(Collectors.toList()));
    }

    static boolean isChrome(String userAgent) {
        return UserAgent.getChromeMajorVersion(userAgent).isPresent();
    }

    static Optional<Integer> getChromeMajorVersion(String userAgent) {
        Matcher matcher = Pattern.compile("Chrome/(\\d+?)\\.").matcher(userAgent);
        return matcher.find() ? Optional.of(Integer.valueOf(matcher.group(1))) : Optional.empty();
    }

    static Optional<String> getSecChUA(String userAgent) {
        Integer version = UserAgent.getChromeMajorVersion(userAgent).orElse(null);
        if (version == null) {
            return Optional.empty();
        }
        BiFunction<String, Integer, String> join = (name, ver) -> CommonString.doubleQuoted(name) + ";v=" + CommonString.doubleQuoted(String.valueOf(ver));
        String brand = CommonString.replaceRandom(" Not A Brand", " ", ";");
        List<String> parts = Arrays.asList(join.apply(brand, 99), join.apply("Chromium", version), join.apply("Google Chrome", version));
        Collections.shuffle(parts);
        String value = String.join((CharSequence)", ", parts);
        return Optional.of(value);
    }

    UserAgent(String mozillaVersion, String agentVersion, String platformVersion) {
        this.mozillaVersion = mozillaVersion;
        this.agentVersion = agentVersion;
        this.platformVersion = platformVersion;
    }

    protected abstract String systemDetails();

    protected abstract String platform();

    protected abstract String platformDetails();

    protected abstract String extensions();

    protected String bracketedOrEmpty(String string) {
        return string.isEmpty() ? string : "(" + string + ")";
    }

    protected boolean isOsLinux() {
        return SystemUtils.IS_OS_LINUX;
    }

    protected boolean isOsWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    protected String systemLinux(String name) {
        return this.joinDetails("X11", name, "Linux x86_64");
    }

    protected String systemWindowsNT(boolean x64) {
        String os = this.joinMain("Windows", "NT", SystemUtils.OS_VERSION);
        return x64 ? this.joinDetails(os, "Win64", "x64") : os;
    }

    protected String platformAppleWebKit() {
        return "AppleWebKit/" + this.platformVersion;
    }

    protected String platformGecko() {
        return "Gecko/" + this.platformVersion;
    }

    protected String extensionChrome(String version) {
        return "Chrome/" + version;
    }

    protected String extensionSafari(String version) {
        return "Safari/" + version;
    }

    protected String extensionFirefox(String version) {
        return "Firefox/" + version;
    }

    protected String revision(String version) {
        return "rv:" + version;
    }

    protected String joinMain(String ... elements) {
        return CommonString.Joiner.with(" ").join(elements);
    }

    protected String joinDetails(String ... details) {
        return CommonString.Joiner.with("; ").join(details);
    }

    public String toString() {
        return this.joinMain("Mozilla/" + this.mozillaVersion, this.bracketedOrEmpty(this.systemDetails()), this.platform(), this.bracketedOrEmpty(this.platformDetails()), this.extensions());
    }
}

