/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Counters;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractGas
extends Pollutant<GasEntity> {
    public static GameTime spreadIntoWorldInterval = GameTime.seconds((int)3);
    private final MultiConfigProperty.IntProperty<BiomeId> cloudHeight;
    private final MultiConfigProperty.BoolProperty<BiomeId> affectedByWind;
    private final int lowerExplosiveLimit;

    public AbstractGas(UnitConfig config, Properties<?> props) {
        super(config, props, GasEntity.class);
        String category = props.name;
        this.cloudHeight = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"cloudHeight", (int)props.cloudHeight, (IntBounds)GameBounds.HEIGHT.getIntBounds(), (String)"Only pollutant blocks within this height around concentration altitude will affect the level of pollution in the current chunk.\nRequired for pollutants capture and storage.");
        this.lowerExplosiveLimit = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"lowerExplosiveLimit", (int)props.lowerExplosiveLimit, (IntBounds)IntBounds.between((Integer)0, (Integer)512), (String)"The lowest number of adjacent gas blocks capable of producing an explosion in the presence of an ignition source.\nSet to zero to disable explosions.");
        this.affectedByWind = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)category, (String)"affectedByWind", (boolean)props.affectedByWind, (String)"Defines whether wind affects this pollutant or not.");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.cloudHeight, this.affectedByWind});
    }

    public static boolean isGasBlock(Level world, BlockPos pos) {
        Block block = world.m_8055_(pos).m_60734_();
        return block instanceof AbstractGas;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f - (float)this.getCarriedPollutionAmount(state) * 0.1f;
    }

    protected BlockState affectUnderlyingBlock(ServerLevel world, BlockPos sourcePos, BlockState sourceState) {
        BlockPos targetPos = this.getFirstUnderlyingBlock((LevelReader)world, sourcePos);
        boolean directContact = Math.abs(targetPos.m_123342_() - sourcePos.m_123342_()) <= 1;
        Optional<Direction> side = Optional.of(Direction.UP);
        BlockState newState = sourceState;
        if (directContact && (newState = this.tryAffectBlockAt(world, targetPos, side, AbstractImpacts.ImpactType.CONTACT, sourceState)) != sourceState) {
            return newState;
        }
        if (this.isUnderRainOrStorm((LevelAccessor)world, targetPos) && (newState = this.tryAffectBlockAt(world, targetPos, side, AbstractImpacts.ImpactType.RAIN, sourceState)) != sourceState) {
            return newState;
        }
        return this.tryAffectBlockAt(world, targetPos, side, AbstractImpacts.ImpactType.AIR, sourceState);
    }

    public boolean affectsPollutionLevel(LevelAccessor level, BlockPos pos, BlockState state) {
        return this.getCloudVertBounds(level, pos).encloses(Integer.valueOf(pos.m_123342_()));
    }

    public IntBounds getCloudVertBounds(LevelAccessor world, BlockPos pos) {
        BiomeId biome = BiomeId.from((LevelAccessor)world, (BlockPos)pos);
        return IntBounds.of((Integer)this.getConcentrationAltitudeIn(biome)).extend(Integer.valueOf(this.getCloudHeightIn(biome)));
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
    }

    @Override
    public int emitFrom(BlockEntity tile, Set<BlockState> relatedBlocks, int amount) {
        Optional<Direction> direction;
        Level level = tile.m_58904_();
        if (level == null || amount <= 0 || level.m_5776_()) {
            return 0;
        }
        Counters.IntCounter counter = Counters.fromZeroTo((int)amount);
        BlockPos sourcePos = tile.m_58899_();
        WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((BlockEntity)tile, relatedBlocks);
        if (level.m_7702_(sourcePos) == null && (direction = this.getMotionFacing((LevelAccessor)level, sourcePos)).isPresent() && this.canPassThrough((LevelReader)level, sourcePos, direction.get(), direction.get())) {
            neighbors.getFound().add(sourcePos);
        }
        this.tryPumpThrough(() -> neighbors.getTopActivePumps(0), (LevelAccessor)level, counter);
        this.tryPumpThrough(() -> ((WorldSearch.TileNeighbors)neighbors).getSideActivePumps(), (LevelAccessor)level, counter);
        this.tryPumpThrough(() -> ((WorldSearch.TileNeighbors)neighbors).getBottomActivePumps(), (LevelAccessor)level, counter);
        this.tryPumpRandomAt(() -> neighbors.getTopPassableChimneys(0), (LevelAccessor)level, counter, (lev, pos) -> true);
        BiPredicate<LevelAccessor, BlockPos> condition = (lev, pos) -> lev.m_46859_(pos) && !neighbors.isMultiblockHollow(pos);
        this.tryPumpRandomAt(() -> ((WorldSearch.TileNeighbors)neighbors).getAboveBlocks(), (LevelAccessor)level, counter, condition);
        this.tryPumpRandomAt(() -> ((WorldSearch.TileNeighbors)neighbors).getFound(), (LevelAccessor)level, counter, condition);
        condition = (lev, pos) -> this.getMotionFacing((LevelAccessor)lev, (BlockPos)pos).map(dir -> this.canPassThrough((LevelReader)lev, (BlockPos)pos, (Direction)dir, (Direction)dir)).orElse(false);
        this.tryPumpRandomAt(() -> ((WorldSearch.TileNeighbors)neighbors).getAboveBlocks(), (LevelAccessor)level, counter, condition);
        this.tryPumpRandomAt(() -> ((WorldSearch.TileNeighbors)neighbors).getFound(), (LevelAccessor)level, counter, condition);
        return counter.getValue();
    }

    protected void tryPumpThrough(Supplier<List<BlockPos>> pumps, LevelAccessor level, Counters.IntCounter counter) {
        if (counter.canIncrement()) {
            int count = GameWorld.SmokeContainers.pumpPollutionThrough(pumps.get(), (LevelAccessor)level, (IPollutant)this, (int)counter.getDistToMaximum());
            counter.add(count);
        }
    }

    protected void tryPumpRandomAt(Supplier<List<BlockPos>> positions, LevelAccessor level, Counters.IntCounter counter, BiPredicate<LevelAccessor, BlockPos> condition) {
        if (counter.canIncrement()) {
            List<BlockPos> shuffled = positions.get();
            Collections.shuffle(shuffled);
            for (BlockPos pos : shuffled) {
                if (condition.test(level, pos)) {
                    int count = this.pumpEntitiesAt(level, pos, counter.getDistToMaximum());
                    counter.add(count);
                }
                if (!counter.atMax()) continue;
                return;
            }
        }
    }

    public boolean canPassThrough(LevelReader level, BlockPos pos, Direction input, Direction output) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof AbstractGas || this.isSamePollutant(state)) {
            return false;
        }
        if (block == Blocks.f_50016_ || block == Blocks.f_50083_) {
            return true;
        }
        if (block instanceof FenceBlock || block instanceof FenceGateBlock) {
            return true;
        }
        if (block instanceof IronBarsBlock && state.m_60767_() == Material.f_76279_) {
            return true;
        }
        if (block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.VENT) && input.m_122434_().m_122479_() && output.m_122434_().m_122479_()) {
            return true;
        }
        Material material = state.m_60767_();
        if (material == Material.f_76274_ || material == Material.f_76296_ || material == Material.f_76305_ || material == Material.f_76307_) {
            return true;
        }
        if (this.passableBlocks.contains(state)) {
            return true;
        }
        for (Direction direction : new Direction[]{input, output}) {
            if (!state.m_60783_((BlockGetter)level, pos, direction)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<ItemStack, IStorageItem> getProtectiveItems(LivingEntity living) {
        HashMap<ItemStack, IStorageItem> items = new HashMap<ItemStack, IStorageItem>();
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)living)) {
            IStorage.Content content;
            Respirators.Respirator respirator = AdPother.getInstance().respirators.get(stack).orElse(null);
            if (respirator == null || !respirator.isFunctional(stack) || (content = respirator.getContent(stack)).getFreeSpaceFor(this) <= 0) continue;
            items.put(stack, respirator);
        }
        return items;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.m_60713_((Block)this) || newState.m_60795_() || newState.m_60734_() instanceof LiquidBlock)) {
            BlockPos movePos;
            int amount = this.getCarriedPollutionAmount(state);
            List movePositions = GameWorld.Positions.getAroundCube((BlockPos)pos);
            Collections.shuffle(movePositions);
            int count = 0;
            Iterator iterator = movePositions.iterator();
            while (iterator.hasNext() && (count += this.pump((LevelAccessor)world, movePos = (BlockPos)iterator.next(), amount - count)) < amount) {
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    public Spread createSpread(final ServerLevel world, final BlockPos pos, final BlockState state) {
        return new Spread((Level)world, pos, state, this){

            @Override
            public Spread around(int minDensityDelta) {
                block1: {
                    Direction dir;
                    if (this.completed() || !AbstractGas.this.canSpreadAround() || this.getPollutant().getCarriedPollutionAmount(state) < minDensityDelta) break block1;
                    IWind wind = GameWorld.getWindAt((Level)world, (BlockPos)pos);
                    List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
                    wind.sortDirections(directions);
                    Iterator iterator = directions.iterator();
                    while (iterator.hasNext() && !this.in(dir = (Direction)iterator.next(), minDensityDelta).completed()) {
                    }
                }
                return this;
            }
        };
    }

    public boolean pushedBy(ServerLevel world, BlockPos pos, Player player, Direction face) {
        if (!GameWorld.isServerSide((LevelReader)world)) {
            return false;
        }
        Block block = world.m_8055_(pos).m_60734_();
        float probability = 0.2f;
        if (!CommonMath.Random.result((float)probability)) {
            return false;
        }
        AbstractGas pollutant = (AbstractGas)block;
        ArrayList<Direction> directions = new ArrayList<Direction>(){
            private static final long serialVersionUID = -3415775606148431593L;

            @Override
            public boolean add(Direction e) {
                if (this.contains(e)) {
                    return false;
                }
                return super.add(e);
            }
        };
        directions.add(face.m_122424_());
        Direction sourceDir = Direction.m_122382_((Entity)player)[0];
        Direction pushDir = sourceDir.m_122424_();
        directions.add(pushDir);
        Optional<Direction> motionFacing = pollutant.getMotionFacing((LevelAccessor)world, pos);
        motionFacing.ifPresent(directions::add);
        directions.addAll(GameWorld.Directions.of().all().shuffle().toList());
        if (motionFacing.isPresent()) {
            Direction opposite = motionFacing.get().m_122424_();
            directions.remove(opposite);
            directions.add(opposite);
        }
        directions.remove(sourceDir);
        directions.add(sourceDir);
        for (Direction dir : directions) {
            if (!pollutant.push((LevelAccessor)world, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected GasEntity createEntityPollutant(ServerLevel world, BlockPos pos, BlockState carriedState) {
        return new GasEntity((Level)world, pos, carriedState);
    }

    @Override
    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return true;
    }

    @Override
    protected boolean spread(ServerLevel world, BlockPos pos, BlockState state) {
        boolean spreaded = super.spread(world, pos, state);
        return spreaded;
    }

    protected BlockPos getFirstUnderlyingBlock(LevelReader world, BlockPos startPos) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)startPos.m_7495_());
        int minY = WorldData.altitudeBounds.getMin();
        for (int y = pos.m_123342_(); y >= minY; --y) {
            pos.m_142448_(y);
            if (!GameWorld.isAirBlock((LevelReader)world, (BlockPos)pos)) break;
        }
        return pos.m_7949_();
    }

    public void m_213898_(BlockState sourceState, ServerLevel level, BlockPos sourcePos, RandomSource random) {
        if (level.m_5776_() || !this.inAllowableDimension((Level)level)) {
            return;
        }
        BlockState newSourceState = this.affectUnderlyingBlock(level, sourcePos, sourceState);
        if (newSourceState != sourceState) {
            level.m_46597_(sourcePos, newSourceState);
            return;
        }
        if (this.pushedByWind((Level)level, sourcePos, sourceState)) {
            return;
        }
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        for (BlockPos checkpos : GameWorld.Positions.getAroundCube((BlockPos)pos)) {
            if (!WorldData.isIgnitionSource((Level)world, checkpos)) continue;
            if (!GasExplosion.in((Level)world).position(pos).tryExplode()) break;
            return;
        }
        super.m_213897_(state, world, pos, rand);
    }

    protected boolean pushedByWind(Level world, BlockPos sourcePos, BlockState sourceState) {
        if (!this.isAffectedByWindIn(BiomeId.from((LevelAccessor)world, (BlockPos)sourcePos))) {
            return false;
        }
        IWind wind = GameWorld.getWindAt((Level)world, (BlockPos)sourcePos);
        List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
        wind.sortDirections(directions);
        for (Direction direction : directions) {
            BlockPos pos;
            float strength = wind.getStrengthIn(direction);
            if (!(strength > 0.0f)) continue;
            float factor = Wind.STRENGTH_BOUNDS.interpolationFactor(Float.valueOf(strength));
            int maxDistance = CommonMath.Interpolation.up((float)factor, (IntBounds)IntBounds.between((Integer)0, (Integer)this.getPollutionCapacity()));
            BlockPos destPos = null;
            for (int offset = 1; offset <= maxDistance && GameWorld.isBlockLoaded((LevelReader)world, (BlockPos)(pos = sourcePos.m_5484_(direction, offset))) && GameWorld.isAirBlock((LevelReader)world, (BlockPos)pos); ++offset) {
                destPos = pos;
            }
            if (destPos == null || !this.pump((LevelAccessor)world, destPos)) continue;
            return this.spend((LevelAccessor)world, sourcePos);
        }
        return false;
    }

    public IPollutant.Type getPollutantType() {
        return IPollutant.Type.AIR;
    }

    public int getCloudHeightIn(BiomeId biome) {
        return (Integer)this.cloudHeight.get((Object)biome);
    }

    public int getLowerExplosiveLimit() {
        return this.lowerExplosiveLimit;
    }

    public boolean isAffectedByWindIn(BiomeId biome) {
        return (Boolean)this.affectedByWind.get((Object)biome);
    }

    public static class Properties<T extends Properties<T>>
    extends Pollutant.Properties<T> {
        public int absorbtionChance = 0;
        public int lowerExplosiveLimit = 0;
        public int cloudHeight = 16;
        public boolean affectedByWind = true;

        public static Properties<?> of(String name, MaterialColor color) {
            return new Properties<Properties>(Properties.class, name, Properties.coloredGas(color));
        }

        protected static Material coloredGas(MaterialColor color) {
            return new Material(color, false, false, false, false, false, true, PushReaction.PUSH_ONLY);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
            this.vanillaProps.m_60910_().m_60977_().m_60913_(-1.0f, 0.0f).m_60971_((s, w, p) -> false).m_60960_((s, w, p) -> true);
        }

        public T absorbtionChance(int percentage) {
            this.absorbtionChance = percentage;
            return (T)((Object)((Properties)this.self));
        }

        public T lowerExplosiveLimit(int limit) {
            this.lowerExplosiveLimit = limit;
            return (T)((Object)((Properties)this.self));
        }

        public T cloudHeight(int height) {
            this.cloudHeight = height;
            return (T)((Object)((Properties)this.self));
        }

        public T ignoreWind() {
            this.affectedByWind = false;
            return (T)((Object)((Properties)this.self));
        }
    }
}

