/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.BlockStateList;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.DimensionId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.config.FilterMaterialList;
import com.endertech.minecraft.mods.adpother.entities.AbstractCarrier;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import com.endertech.minecraft.mods.adpother.impacts.EnvironmentalImpacts;
import com.endertech.minecraft.mods.adpother.pollution.IFilterFrame;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Pollutant<E extends AbstractCarrier>
extends ForgeBlock
implements IPollutant,
IPostInit {
    public static final EnumProperty<Density> DENSITY = EnumProperty.m_61587_((String)"density", Density.class);
    public static final IntBounds INITIAL_AMOUNT_BOUNDS = new IntBounds(Integer.valueOf(0), Integer.valueOf(256));
    protected static final int MIN_HORIZ_SPREAD_DENSITY_DELTA = 2;
    private final List<MultiConfigProperty.BaseProperty<BiomeId, ?>> biomeProperties = new ArrayList();
    protected final Class<E> entityClass;
    protected final FilterMaterialList filterMaterials;
    private final MultiConfigProperty.IntProperty<BiomeId> criticalAmount;
    private final MultiConfigProperty.IntProperty<BiomeId> concentrationAltitude;
    private final MultiConfigProperty.FloatProperty<BiomeId> motionVelocity;
    private final MultiConfigProperty.FloatProperty<BiomeId> emissionRate;
    private final boolean canSpreadAround = true;
    private final boolean canSpreadOverLedge = true;
    private final String name;
    private final ColorARGB color;
    private final ChatFormatting textColor;
    private final CommonCollect.BlackWhiteList<DimensionId> dimensions;
    protected final BlockStateList passableBlocks;

    public Pollutant(UnitConfig config, Properties<?> props, Class<E> entityClass) {
        super(config, props);
        this.entityClass = entityClass;
        this.name = props.name;
        String category = props.name;
        this.filterMaterials = new FilterMaterialList(config, category);
        this.criticalAmount = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"criticalAmount", (int)props.criticalAmount, (IntBounds)GameBounds.POLLUTION.getIntBounds(), (String)"Defines the amount of pollution at which all negative effects will be maximized.");
        this.concentrationAltitude = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"concentrationAltitude", (int)props.concentrationAltitude, (IntBounds)WorldData.altitudeBounds.extend(Integer.valueOf(1)), (String)"Defines the altitude which pollutant blocks will concentrate at.");
        this.motionVelocity = MultiConfigProperty.FloatProperty.from((UnitConfig)config, (String)category, (String)"motionVelocity", (float)props.motionVelocity, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Defines motion velocity of the pollutant.");
        this.emissionRate = MultiConfigProperty.FloatProperty.from((UnitConfig)config, (String)category, (String)"emissionRate", (float)1.0f, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Defines emission rate for this pollutant.");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.criticalAmount, this.concentrationAltitude, this.motionVelocity, this.emissionRate});
        ColorARGB colorARGB = ColorARGB.from((int)props.material.m_76339_().f_76396_).maxOpaque();
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)category, (String)"color", (ColorARGB)colorARGB, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)\n Affects smog and sky colors.");
        this.textColor = Optional.ofNullable(ChatFormatting.m_126657_((String)UnitConfig.getStr((UnitConfig)config, (String)category, (String)"textColor", (String)props.textColor.m_126666_(), (String)"Defines the text color for the name of this pollutant."))).orElse(ChatFormatting.WHITE);
        List black = Dimensions.readFrom((UnitConfig)config, (String)category, (String)"dimensionBlackList", (String)"Defines a list of dimensions in which this pollutant will not be generated.", (String[])new String[0]);
        List white = Dimensions.readFrom((UnitConfig)config, (String)category, (String)"dimensionWhiteList", (String)"If this list is set, the pollutant will be generated ONLY in listed dimensions, others will be ignored.", (String[])new String[0]);
        this.dimensions = new CommonCollect.BlackWhiteList(black, white);
        this.passableBlocks = new BlockStateList(config, category, "passableBlocks", new String[]{"#minecraft:carpets", "#minecraft:trapdoors"}, "List of blocks which this pollutant can pass through.");
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(DENSITY, (Comparable)((Object)Density.LIGHT)));
    }

    public void onPostInit() {
        this.passableBlocks.loadData();
        this.filterMaterials.loadData();
        this.saveConfig();
    }

    public boolean inAllowableDimension(Level world) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)DimensionId.from((Level)world));
    }

    public String getSimpleName() {
        return this.name;
    }

    public Optional<Direction> getMotionFacing(LevelAccessor world, BlockPos pos) {
        int altitude = this.getConcentrationAltitudeIn(BiomeId.from((LevelAccessor)world, (BlockPos)pos));
        if (pos.m_123342_() == altitude) {
            return Optional.empty();
        }
        return Optional.of(pos.m_123342_() < altitude ? Direction.UP : Direction.DOWN);
    }

    public boolean push(LevelAccessor level, BlockPos pos, Direction facing) {
        return this.pump(level, pos.m_121945_(facing)) && this.spend(level, pos);
    }

    public boolean pump(LevelAccessor level, BlockPos pos) {
        return this.pump(level, pos, 1) == 1;
    }

    public int pump(LevelAccessor level, BlockPos pos, int amount) {
        int count;
        BlockState state = level.m_8055_(pos);
        for (count = 0; count < amount && this.canStateBePumped(state); ++count) {
            state = this.getPumpedState(state);
        }
        if (count > 0) {
            level.m_7731_(pos, state, 3);
        }
        return count;
    }

    public int spend(LevelAccessor level, BlockPos pos, int amount) {
        int count;
        BlockState state = level.m_8055_(pos);
        for (count = 0; count < amount && this.canStateBeSpreaded(state); ++count) {
            state = this.getSpreadedState(state);
        }
        if (count > 0) {
            level.m_7731_(pos, state, 3);
        }
        return count;
    }

    public boolean spend(LevelAccessor level, BlockPos pos) {
        return this.spend(level, pos, 1) == 1;
    }

    protected int pumpActiveFilters(LevelAccessor level, BlockPos pos, int amount) {
        BlockEntity tile;
        int count = 0;
        if (count >= amount || level.m_5776_()) {
            return count;
        }
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof IFilterFrame && (tile = level.m_7702_(pos)) != null) {
            ISmokeContainer container;
            IFilterFrame filter = (IFilterFrame)block;
            if ((count += filter.fill(tile, this, amount - count)) >= amount) {
                return count;
            }
            if (block instanceof ISmokeContainer && (container = (ISmokeContainer)block).isChimney() && container.isActive((BlockGetter)level, pos)) {
                count += this.pumpActiveFilters(level, pos.m_7494_(), amount - count);
            }
        }
        return count;
    }

    public int pumpEntitiesAt(LevelAccessor level, BlockPos pos, int amount) {
        AbstractCarrier entity;
        int count = 0;
        if (count >= amount || level.m_5776_()) {
            return count;
        }
        if ((count += this.pumpActiveFilters(level, pos, amount - count)) >= amount) {
            return count;
        }
        List<AbstractCarrier> foundCarriers = this.getPollutantCarriersAt((EntityGetter)level, pos);
        if (foundCarriers.isEmpty() && (entity = (AbstractCarrier)this.spawnEntity(level, pos).orElse(null)) != null && entity.m_6084_()) {
            if (++count >= amount) {
                return count;
            }
            foundCarriers.add(entity);
        }
        for (AbstractCarrier carrier : foundCarriers) {
            if (!carrier.carriesSameBlock(Optional.of(this))) continue;
            while (carrier.pump()) {
                if (++count < amount) continue;
                return count;
            }
        }
        return count;
    }

    public int spendEntitiesAt(LevelAccessor level, BlockPos pos, int amount) {
        int count = 0;
        if (count >= amount || level.m_5776_()) {
            return count;
        }
        for (AbstractCarrier carrier : this.getPollutantCarriersAt((EntityGetter)level, pos)) {
            if (!carrier.carriesSameBlock(Optional.of(this))) continue;
            while (carrier.spend()) {
                if (++count < amount) continue;
                return count;
            }
        }
        return count;
    }

    public void scheduleUpdate(Level world, BlockPos pos) {
        world.m_186460_(pos, (Block)this, this.getTickDelay(world, pos));
    }

    public void explodeBlock(Level world, BlockPos pos, float explosionSize) {
        if (world instanceof ServerLevel) {
            BlockState state = world.m_8055_(pos);
            boolean dropAsItem = !state.m_60804_((BlockGetter)world, pos);
            GameWorld.scheduleBlockExplosion((ServerLevel)((ServerLevel)world), (BlockPos)pos, (CommonTime.Interval)CommonTime.Interval.ZERO, (float)explosionSize, (boolean)true, (Explosion.BlockInteraction)Explosion.BlockInteraction.BREAK, (boolean)dropAsItem, null);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (this.getCarriedPollutionAmount(state) <= 0) {
            return;
        }
        if (!world.m_143340_(pos)) {
            return;
        }
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        boolean spreaded = false;
        Optional<Direction> motionFacing = this.getMotionFacing((LevelAccessor)world, pos);
        if (motionFacing.isPresent()) {
            Direction output;
            BlockPos nextPos = pos.m_121945_(motionFacing.get());
            BlockPos nextPos2 = pos.m_5484_(motionFacing.get(), 2);
            Direction input = motionFacing.get().m_122424_();
            if (this.canPassThrough((LevelReader)world, nextPos, input, output = motionFacing.get()) && this.canPassThrough((LevelReader)world, nextPos2, input, output)) {
                if (WorldData.getData((Level)world).getGasCarrierLimiter().canSpawnAt((Level)world, nextPos)) {
                    int count = this.pumpEntitiesAt((LevelAccessor)world, nextPos, this.getCarriedPollutionAmount(state));
                    spreaded = count > 0 && this.spend((LevelAccessor)world, pos, count) == count;
                } else {
                    this.scheduleUpdate((Level)world, pos);
                    return;
                }
            }
        }
        if (!spreaded) {
            world.m_46473_().m_6180_("pollutantSpreading");
            spreaded = this.spread(world, pos, state);
            world.m_46473_().m_7238_();
        }
        if (!spreaded) {
            for (Direction direction : GameWorld.Directions.of().all().shuffle().toArray()) {
                BlockState newState = this.tryAffectBlockAt(world, pos.m_121945_(direction), Optional.of(direction.m_122424_()), AbstractImpacts.ImpactType.CONTACT, state);
                if (newState == state) continue;
                world.m_46597_(pos, newState);
                state = newState;
                if (!GameWorld.isAirBlock((LevelReader)world, (BlockPos)pos)) {
                    this.scheduleUpdate((Level)world, pos);
                }
                return;
            }
        }
    }

    protected boolean spread(ServerLevel world, BlockPos pos, BlockState state) {
        Spread spread = this.createSpread(world, pos, state);
        spread.inMotionFacing().overLedge().around(2).apply();
        return spread.completed();
    }

    public Spread createSpread(ServerLevel world, BlockPos pos, BlockState state) {
        return Spread.from((Level)world, pos, state, this);
    }

    public boolean canStateBePumped(BlockState state) {
        return state.m_60795_() || this.isSamePollutant(state) && ((Density)((Object)state.m_61143_(DENSITY))).canAbsorb();
    }

    public boolean canStateBeSpreaded(BlockState state) {
        return this.getCarriedPollutionAmount(state) > 0;
    }

    public BlockState getPumpedState(BlockState state) {
        if (state.m_60795_()) {
            return this.m_49966_();
        }
        Density density = (Density)((Object)state.m_61143_(DENSITY));
        return (BlockState)state.m_61124_(DENSITY, (Comparable)((Object)density.getPumped()));
    }

    public BlockState getSpreadedState(BlockState state) {
        Density density = (Density)((Object)state.m_61143_(DENSITY));
        return density.canSpread() ? (BlockState)state.m_61124_(DENSITY, (Comparable)((Object)density.getSpreaded())) : Blocks.f_50016_.m_49966_();
    }

    public abstract int emitFrom(BlockEntity var1, Set<BlockState> var2, int var3);

    public int generateAt(Level level, BlockPos startPos, int amount, int maximumRadius) {
        int count = 0;
        int capacity = this.getPollutionCapacity();
        for (int maxRadius = 0; maxRadius <= maximumRadius && count < amount; ++maxRadius) {
            for (int vertOffset = 0; vertOffset <= maxRadius; ++vertOffset) {
                for (BlockPos planePos : new BlockPos[]{startPos.m_6630_(vertOffset), startPos.m_6625_(vertOffset)}) {
                    int rmax = maxRadius - vertOffset;
                    int rmin = rmax - capacity + 1;
                    if (rmin < 0) {
                        rmin = 0;
                    }
                    if (rmax < 0 || level.m_151570_(planePos)) continue;
                    for (int radius = rmin; radius <= rmax; ++radius) {
                        List posList = GameWorld.Positions.getAroundHoriz((BlockPos)planePos, (int)radius, (boolean)false);
                        Collections.shuffle(posList);
                        for (BlockPos pos : posList) {
                            if (level.m_8055_(pos).m_60767_() == Material.f_76309_) {
                                pos = pos.m_7494_();
                            }
                            count += this.pump((LevelAccessor)level, pos, amount - count);
                        }
                        if (count < amount) continue;
                        return count;
                    }
                }
            }
        }
        return count;
    }

    protected boolean setPollutantBlock(Level world, BlockPos pos) {
        return world.m_46597_(pos, this.m_49966_());
    }

    protected abstract E createEntityPollutant(ServerLevel var1, BlockPos var2, BlockState var3);

    protected Optional<E> spawnEntity(LevelAccessor world, BlockPos pos) {
        return this.spawnEntity(world, pos, this.m_49966_());
    }

    protected Optional<E> spawnEntity(LevelAccessor world, BlockPos pos, BlockState carriedState) {
        if (world instanceof ServerLevel) {
            E entity = this.createEntityPollutant((ServerLevel)world, pos, carriedState);
            if (world.m_7967_(entity)) {
                return Optional.of(entity);
            }
        } else {
            AdPother.getInstance().getLogger().error("Attempt to spawn pollutant on client!");
        }
        return Optional.empty();
    }

    public boolean isSamePollutant(BlockState state) {
        return state.m_60734_() == this;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DENSITY});
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return this.isSamePollutant(adjacentBlockState) && this.getCarriedPollutionAmount(state) == this.getCarriedPollutionAmount(adjacentBlockState);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world instanceof ServerLevel) {
            WorldData.getChunkPollution(world, pos).increaseBy((ServerLevel)world, pos, state, 1);
            this.scheduleUpdate(world, pos);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (world instanceof ServerLevel) {
            WorldData.getChunkPollution(world, pos).increaseBy((ServerLevel)world, pos, state, -1);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.scheduleUpdate(world, pos);
    }

    public int getTickDelay(Level world, BlockPos pos) {
        return CommonMath.Random.between((int)20, (int)120);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return state.m_61143_(DENSITY) != Density.HEAVY;
    }

    public int getCarriedPollutionAmount(BlockState state) {
        if (this.isSamePollutant(state)) {
            Density density = (Density)((Object)state.m_61143_(DENSITY));
            return density.ordinal() + 1;
        }
        return 0;
    }

    public int getPollutionCapacity() {
        return Density.values().length;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public boolean canAffectEntity(Entity entity, AbstractImpacts.ImpactType impact, Percentage pollution) {
        return AdPother.getInstance().impacts.getFor(entity).map(impacts -> impacts.canAffect(entity, this, impact, pollution)).orElse(false);
    }

    public boolean tryAffectEntity(Entity entity, AbstractImpacts.ImpactType impact, Percentage pollution) {
        return AdPother.getInstance().impacts.getFor(entity).map(impacts -> impacts.tryAffect(entity, this, impact, pollution) > 0).orElse(false);
    }

    public List<E> getPollutantCarriersAt(EntityGetter reader, BlockPos pos) {
        return reader.m_45976_(this.entityClass, FULL_BLOCK_AABB.m_82338_(pos));
    }

    public Map<ItemStack, IStorageItem> getProtectiveItems(LivingEntity living) {
        return Collections.emptyMap();
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    public int getCriticalAmountIn(BiomeId biome) {
        return (Integer)this.criticalAmount.get((Object)biome);
    }

    public int getConcentrationAltitudeIn(BiomeId biome) {
        return (Integer)this.concentrationAltitude.get((Object)biome);
    }

    public float getMotionVelocityIn(BiomeId biome) {
        return ((Float)this.motionVelocity.get((Object)biome)).floatValue();
    }

    public List<MultiConfigProperty.BaseProperty<BiomeId, ?>> getBiomeProperties() {
        return Collections.unmodifiableList(this.biomeProperties);
    }

    public float getEmissionRateIn(BiomeId biome) {
        return ((Float)this.emissionRate.get((Object)biome)).floatValue();
    }

    public FilterMaterialList getFilterMaterials() {
        return this.filterMaterials;
    }

    public boolean canSpreadOverLedge() {
        return true;
    }

    public boolean canSpreadAround() {
        return true;
    }

    @SafeVarargs
    protected final void addBiomeIdProperties(MultiConfigProperty.BaseProperty<BiomeId, ?> ... properties) {
        Collections.addAll(this.biomeProperties, properties);
    }

    public boolean canAffectBlock(LevelAccessor world, BlockPos pos, BlockState state, Optional<Direction> side, AbstractImpacts.ImpactType impact) {
        return ((EnvironmentalImpacts)AdPother.getInstance().impacts.environmentalImpacts.get()).canAffect(state, this, impact);
    }

    public final BlockState tryAffectBlockAt(ServerLevel world, BlockPos pos, Optional<Direction> side, AbstractImpacts.ImpactType type, BlockState sourceState) {
        if (!this.isSamePollutant(sourceState)) {
            return sourceState;
        }
        BlockState state = world.m_8055_(pos);
        if (this.tryFilterAt(world, pos, state, side)) {
            return this.getSpreadedState(sourceState);
        }
        if (!this.canAffectBlock((LevelAccessor)world, pos, state, side, type)) {
            return sourceState;
        }
        return this.affectBlockAt(world, pos, state, side, type, sourceState);
    }

    protected BlockState affectBlockAt(ServerLevel world, BlockPos pos, BlockState state, Optional<Direction> side, AbstractImpacts.ImpactType type, BlockState sourceState) {
        if (((EnvironmentalImpacts)AdPother.getInstance().impacts.environmentalImpacts.get()).tryAffect(world, pos, state, this, type)) {
            return this.getSpreadedState(sourceState);
        }
        return sourceState;
    }

    protected boolean tryFilterAt(ServerLevel world, BlockPos pos, BlockState state, Optional<Direction> side) {
        Block block = state.m_60734_();
        if (block instanceof IFilterFrame) {
            if (side.isPresent() && state.m_60783_((BlockGetter)world, pos, side.get())) {
                return false;
            }
            IFilterFrame filter = (IFilterFrame)block;
            BlockEntity tile = world.m_7702_(pos);
            if (tile != null) {
                return filter.fill(tile, this, 1) > 0;
            }
        }
        return false;
    }

    public Percentage getPercentageAtChunk(ServerLevel world, BlockPos pos) {
        BiomeId biome = BiomeId.from((LevelAccessor)world, (BlockPos)pos);
        PollutionInfo info = WorldData.getChunkPollution((Level)world, pos).getOrCreateInfoFor(this);
        return info.getPercentageIn(biome);
    }

    public boolean isUnderRainOrStorm(LevelAccessor world, BlockPos pos) {
        if (world.m_6106_().m_6533_() || world.m_6106_().m_6534_()) {
            BlockPos checkPos = pos.m_7494_();
            ChunkPos chunkPos = new ChunkPos(checkPos);
            if (world.m_7726_().m_5563_(chunkPos.f_45578_, chunkPos.f_45579_)) {
                int height = world.m_6924_(Heightmap.Types.MOTION_BLOCKING, checkPos.m_123341_(), checkPos.m_123343_());
                return height <= checkPos.m_123342_();
            }
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        public ChatFormatting textColor = ChatFormatting.WHITE;
        public int criticalAmount = 0;
        public int concentrationAltitude = 0;
        public float motionVelocity = 0.0f;
        public Percentage acidRainThreshold = Percentage.ZERO;

        public static Properties<?> of(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
            this.vanillaProps.m_60977_();
        }

        public T textColor(ChatFormatting color) {
            this.textColor = color;
            return (T)((Object)((Properties)this.self));
        }

        public T criticalAmount(int amount) {
            this.criticalAmount = amount;
            return (T)((Object)((Properties)this.self));
        }

        public T concentrationAltitude(int altitude) {
            this.concentrationAltitude = altitude;
            return (T)((Object)((Properties)this.self));
        }

        public T motionVelocity(float velocity) {
            this.motionVelocity = velocity;
            return (T)((Object)((Properties)this.self));
        }

        public T acidRainThreshold(Percentage threshold) {
            this.acidRainThreshold = threshold;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static enum Density implements IForgeEnum
    {
        LIGHT,
        MEDIUM,
        HEAVY;


        public boolean canSpread() {
            return this.ordinal() > 0;
        }

        public boolean canAbsorb() {
            return this.ordinal() < Density.values().length - 1;
        }

        public Density getSpreaded() {
            return Density.values()[this.ordinal() - 1];
        }

        public Density getPumped() {
            return Density.values()[this.ordinal() + 1];
        }

        public String toString() {
            return this.getName();
        }
    }
}

