/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.events.RandomTickEvent;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.init.Fluids;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.AnimalFeeding;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.LavaTouchingWater;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WorldEvents {
    public static boolean loggingFuelConsumption = false;
    public static boolean loggingFoodConsumption = false;
    public static ForgeConfigSpec.ConfigValue<Boolean> furnaceEmissions;
    public static ForgeConfigSpec.ConfigValue<Boolean> burntBlockEmissions;
    public static ForgeConfigSpec.ConfigValue<Double> burntItemEmissionRate;

    @SubscribeEvent
    public static void onWorldLoaded(LevelEvent.Load event) {
    }

    @SubscribeEvent
    public static void onWorldUnloaded(LevelEvent.Unload event) {
        WorldData.removeDataFor(event.getLevel());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Level world = event.level;
        if (GameWorld.isServerSide((LevelReader)world)) {
            WorldData data = WorldData.getData(world);
            data.tick();
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            Entity entity = event.getEntity();
            WorldData data = WorldData.getData((Level)world);
            data.addIfGasEntity(world, entity);
            data.addIfDroppedTorch(world, entity);
            data.addIfEmitter(world, entity);
        }
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        WorldData data = WorldData.getData(level);
        data.removePollutionInfoFor(entity);
        if (GameWorld.isServerSide((LevelReader)level)) {
            data.removeIfGasEntity(entity);
            data.removePeriodicEmissionFor(entity);
            data.removeIfDroppedTorch(entity);
        }
    }

    @SubscribeEvent
    public static void onBlockChange(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            BlockEntity tile = level.m_7702_(pos);
            BlockState state = event.getState();
            if (tile != null) {
                WorldData.getData((Level)level).addIfEmitter(level, pos, state, tile);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRandomTick(RandomTickEvent.Block event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = (BlockState)event.getState();
        AdPother mod = AdPother.getInstance();
        if ((Double)Torch.rate.get() > 0.0) {
            mod.torches.get(state).ifPresent(torch -> torch.emitAt(world, pos));
        }
        mod.emitters.get((LevelReader)world, pos).ifPresent(emitter -> {
            if (emitter.getType().isBlock() && emitter.isActive((LevelReader)world, pos)) {
                emitter.emitAt(world, pos);
            }
        });
    }

    @SubscribeEvent
    public static void onFluidRandomTick(RandomTickEvent.Fluid event) {
        Fluids.ToxicFluids.findBy((FluidState)event.getState()).ifPresent(fluid -> fluid.affectSoilFrom(event.getLevel(), event.getPos()));
    }

    public static final void onBlockBroken(Level world, BlockPos pos, BlockState state) {
        AdPother.getInstance().breakables.get(state).ifPresent(breakable -> breakable.emitAt(world, pos));
    }

    public static final void onFoodConsumed(ItemLike food, int amount, Entity entity) {
        WorldEvents.onFoodConsumed(new ItemStack(food, 1), amount, entity);
    }

    public static final void onFoodConsumed(ItemStack food, int amount, Entity entity) {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            if (!entity.m_9236_().m_5776_()) {
                WorldEvents.logConsumedFood(ForgeItem.getRegistryName((Item)food.m_41720_()).toString(), amount, ForgeEntity.getRegistryName((Entity)entity).toString());
                ((AnimalFeeding)((Object)AdPother.getInstance().sources.animalFeeding.get())).emitFrom(animal, food, amount);
            }
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, BlockEntity tile) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack, stack.getAmount(), tile);
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, int amount, BlockEntity tile) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack.getFluid(), amount, tile);
        }
    }

    public static final void onFuelBurned(@Nullable Fluid fluid, int amount, BlockEntity tile) {
        if (fluid != null) {
            Optional<Fuel> fuel = WorldEvents.asFuel(fluid);
            WorldEvents.logConsumedFuel(ForgeBlock.getRegistryName((Fluid)fluid), fuel, amount, tile);
            if (fuel.isPresent()) {
                WorldEvents.onFuelBurned(fuel.get(), amount, tile);
            }
        }
    }

    private static Optional<Fuel> asFuel(@Nullable Fluid fluid) {
        return fluid != null ? AdPother.getInstance().fuels.get(fluid) : Optional.empty();
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, Entity entity, Alignment alignment) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack, stack.getAmount(), entity, alignment);
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, int amount, Entity entity, Alignment alignment) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack.getFluid(), amount, entity, alignment);
        }
    }

    public static final void onFuelBurned(@Nullable Fluid fluid, int amount, Entity entity, Alignment alignment) {
        if (fluid != null) {
            Optional<Fuel> fuel = WorldEvents.asFuel(fluid);
            WorldEvents.logConsumedFuel(ForgeBlock.getRegistryName((Fluid)fluid), fuel, amount, ForgeEntity.getRegistryName((Entity)entity));
            if (fuel.isPresent()) {
                WorldEvents.onFuelBurned(fuel.get(), amount, entity, alignment);
            }
        }
    }

    private static Optional<Fuel> asFuel(ItemStack stack) {
        return AdPother.getInstance().fuels.get(stack);
    }

    public static final void onFuelBurned(ItemStack stack, int amount, BlockEntity tile) {
        Optional<Fuel> fuel = WorldEvents.asFuel(stack);
        WorldEvents.logConsumedFuel(ForgeItem.getRegistryName((Item)stack.m_41720_()), fuel, amount, tile);
        if (fuel.isPresent()) {
            WorldEvents.onFuelBurned(fuel.get(), amount, tile);
        }
    }

    private static void logConsumedFuel(ResourceLocation consumable, Optional<Fuel> fuel, int amount, BlockEntity tile) {
        WorldEvents.logConsumedFuel(consumable, fuel, amount, ForgeTile.getRegistryName((BlockEntity)tile).orElse(new ResourceLocation("unregistered_shit")));
    }

    private static void logConsumedFuel(ResourceLocation consumable, Optional<Fuel> fuel, int amount, ResourceLocation consumer) {
        if (loggingFuelConsumption) {
            AdPother.getInstance().getLogger().info(consumer + " consumed " + amount + "x " + consumable + " (" + fuel.map(f -> f.getRelatedId().toString()).orElse("no fuel") + ")");
        }
    }

    private static void logConsumedFood(String consumable, int amount, String consumer) {
        if (loggingFoodConsumption) {
            AdPother.getInstance().getLogger().info(consumer + " consumed " + amount + "x " + consumable);
        }
    }

    private static void logNoEmitter(String consumer) {
        if (loggingFuelConsumption) {
            AdPother.getInstance().getLogger().info("Emitter not found for " + consumer + " (no config or incorrect ID)");
        }
    }

    public static final void onFuelBurned(ItemStack stack, int amount, Entity entity, Alignment alignment) {
        Optional<Fuel> fuel = WorldEvents.asFuel(stack);
        WorldEvents.logConsumedFuel(ForgeItem.getRegistryName((Item)stack.m_41720_()), fuel, amount, ForgeEntity.getRegistryName((Entity)entity));
        if (fuel.isPresent()) {
            WorldEvents.onFuelBurned(fuel.get(), amount, entity, alignment);
        }
    }

    public static final void onFuelBurned(Fuel fuel, int amount, BlockEntity tile) {
        Level level = tile.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos pos = tile.m_58899_();
            Emitter emitter = AdPother.getInstance().emitters.get((LevelReader)level2, pos).orElse(null);
            if (emitter != null) {
                ChunkPollution pollution = WorldData.getChunkPollution((Level)level2, pos);
                pollution.increaseBy(emitter, IEmitter.Type.TILE, level2, pos, fuel, amount);
            } else {
                WorldEvents.logNoEmitter(ForgeTile.getRegistryName((BlockEntity)tile).map(ResourceLocation::toString).orElse("null"));
            }
        }
    }

    public static final void onFuelBurned(Fuel fuel, int amount, Entity entity, Alignment alignment) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Emitter emitter = AdPother.getInstance().emitters.get(entity).orElse(null);
            if (emitter != null) {
                BlockPos pos = new BlockPos(alignment.getPositionVec(entity));
                ChunkPollution pollution = WorldData.getChunkPollution((Level)level2, pos);
                pollution.increaseBy(emitter, IEmitter.Type.ENTITY, level2, pos, fuel, amount);
            } else {
                WorldEvents.logNoEmitter(ForgeEntity.getRegistryName((Entity)entity).toString());
            }
        }
    }

    @SubscribeEvent
    public static void onLavaTouchedWater(BlockEvent.FluidPlaceBlockEvent event) {
        BlockPos blockpos;
        Predicate<BlockPos> isWaterOrLava;
        LevelAccessor level = event.getLevel();
        if (level instanceof ServerLevel && (isWaterOrLava = pos -> {
            FluidState state = level.m_6425_(pos);
            return state.m_205070_(FluidTags.f_13131_) || state.m_205070_(FluidTags.f_13132_);
        }).test(blockpos = event.getPos()) && isWaterOrLava.test(event.getLiquidPos())) {
            ((LavaTouchingWater)((Object)AdPother.getInstance().sources.lavaTouchingWater.get())).emitAt((Level)((ServerLevel)level), blockpos.m_7494_());
        }
    }

    public static final void onBlockExploded(Level world, BlockPos pos, BlockState state, Explosion explosion) {
        if (!GameWorld.isServerSide((LevelReader)world)) {
            return;
        }
        ((com.endertech.minecraft.mods.adpother.sources.Explosion)((Object)AdPother.getInstance().sources.explosion.get())).emitAt(world, pos);
        WorldEvents.onBlockBroken(world, pos, state);
        if (state.isFlammable((BlockGetter)world, pos, Direction.UP)) {
            WorldEvents.onBlockBurned(state, world, pos);
        }
    }

    public static final void onFurnaceFuelBurned(ItemStack stack, int amount, BlockEntity tile) {
        if (!((Boolean)furnaceEmissions.get()).booleanValue()) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof BucketItem) {
            Fluid fluid = ((BucketItem)item).getFluid();
            WorldEvents.onFuelBurned(fluid, 1000 * amount, tile);
        } else {
            WorldEvents.onFuelBurned(stack, amount, tile);
        }
    }

    public static final void onBlockBurned(BlockState state, Level world, BlockPos pos) {
        if (((Boolean)burntBlockEmissions.get()).booleanValue() && GameWorld.isServerSide((LevelReader)world)) {
            AdPother.getInstance().fuels.get(state).ifPresent(fuel -> fuel.emitAt(world, pos));
        }
    }

    public static final void onItemBurned(ItemStack stack, Level world, BlockPos pos) {
        Optional<Fuel> fuel;
        if ((Double)burntItemEmissionRate.get() > 0.0 && GameWorld.isServerSide((LevelReader)world) && (fuel = WorldEvents.asFuel(stack)).isPresent()) {
            fuel.get().emitAt(world, pos, (float)stack.m_41613_() * ((Double)burntItemEmissionRate.get()).floatValue());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Alignment {
        TOP{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_20191_().m_82399_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            }
        }
        ,
        CENTER{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_20191_().m_82399_();
            }
        }
        ,
        BOTTOM{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_20191_().m_82399_().m_82492_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            }
        }
        ,
        FRONT{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_20191_().m_82399_().m_82549_(entity.m_20154_().m_82490_((double)(entity.m_20206_() / 2.0f)));
            }
        }
        ,
        BACK{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.m_20191_().m_82399_().m_82546_(entity.m_20154_().m_82490_((double)(entity.m_20205_() / 2.0f)));
            }
        };


        public abstract Vec3 getPositionVec(Entity var1);
    }
}

