/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.RegistryObjectsInit;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class Fluids
extends RegistryObjectsInit<Fluid> {
    public final RegistryObject<PollutedWater.StillFluid> pollutedWaterStill = this.register("polluted_water_still", () -> new PollutedWater.StillFluid(this.createProps()));
    public final RegistryObject<PollutedWater.FlowingFluid> pollutedWaterFlowing = this.register("polluted_water_flowing", () -> new PollutedWater.FlowingFluid(this.createProps()));

    public Fluids(AbstractForgeMod mod) {
        super(mod, ForgeRegistries.FLUIDS);
    }

    private ForgeFlowingFluid.Properties createProps() {
        AdPother instance = AdPother.getInstance();
        return new ForgeFlowingFluid.Properties(instance.fluidTypes.pollutedWaterType, instance.fluids.pollutedWaterStill, instance.fluids.pollutedWaterFlowing).block(instance.blocks.pollutedWater).bucket(instance.items.pollutedWaterBucket);
    }

    public static abstract class WaterChain
    extends WorldSearch.BlockChain {
        protected final int maxRadius;

        protected WaterChain(LevelAccessor world, BlockPos startPos, int maxRadius) {
            super(world, startPos, Math.round((float)Math.PI * (float)maxRadius * (float)maxRadius));
            this.maxRadius = maxRadius;
        }

        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().horizontals().shuffle().toList();
        }

        protected boolean isWithinMaxRadius(BlockPos pos) {
            return this.startPos.m_123331_((Vec3i)pos) <= (double)(this.maxRadius * this.maxRadius);
        }

        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            if (!this.isWithinMaxRadius(pos)) {
                return false;
            }
            BlockState state = this.world.m_8055_(pos);
            Material material = state.m_60767_();
            return material == Material.f_76305_;
        }
    }

    static class SoilChain
    extends WorldSearch.BlockChain {
        private boolean affected = false;
        private final BlockPos top;

        public static SoilChain from(Level world, BlockPos startPos, int maxLength, BlockPos topPos) {
            SoilChain chain = new SoilChain(world, startPos, maxLength, topPos);
            chain.build();
            return chain;
        }

        protected SoilChain(Level world, BlockPos startPos, int maxLength, BlockPos topPos) {
            super((LevelAccessor)world, startPos, maxLength);
            this.top = topPos;
        }

        public boolean isAffected() {
            return this.affected;
        }

        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().all().shuffle().toList();
        }

        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            if (pos.m_123342_() > this.top.m_123342_()) {
                return false;
            }
            BlockState state = this.world.m_8055_(pos);
            Material material = state.m_60767_();
            if (material == Material.f_76317_) {
                return true;
            }
            return this.isValidBlock(pos);
        }

        protected boolean isValidBlock(BlockPos pos) {
            if (pos.m_123342_() > this.top.m_123342_()) {
                return false;
            }
            BlockState state = this.world.m_8055_(pos);
            Block block = state.m_60734_();
            Material material = state.m_60767_();
            if (material == Material.f_76314_ || material == Material.f_76315_) {
                return true;
            }
            return block instanceof IPlantable;
        }

        protected boolean onValidFound(BlockPos pos) {
            BlockState state = this.world.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof GrassBlock || block instanceof FarmBlock) {
                this.affected = this.world.m_7731_(pos, Blocks.f_50599_.m_49966_(), 3);
            } else if (state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_152549_)) {
                this.affected = this.world.m_7731_(pos, Blocks.f_50546_.m_49966_(), 3);
            } else if (block instanceof IPlantable) {
                this.affected = this.world.m_7471_(pos, false);
            }
            return !this.affected;
        }
    }

    public static enum ToxicFluids {
        canola,
        coal,
        creosote,
        creotheum,
        crude,
        diesel,
        ender,
        ethanol,
        fire_water,
        fuel,
        gasoline,
        glycerin,
        hootch,
        kerosene,
        lubricant,
        methanol,
        napalm,
        naphtha,
        oil,
        petrol,
        petrotheum,
        plantoil,
        polluted_water,
        pyrotheum,
        redstone,
        resin;

        private static final Map<Fluid, Optional<ToxicFluids>> CACHED_FLUIDS;

        private static Optional<ToxicFluids> findBy(String name) {
            for (ToxicFluids fluid : ToxicFluids.values()) {
                if (!name.contains(fluid.name())) continue;
                return Optional.of(fluid);
            }
            return Optional.empty();
        }

        public static Optional<ToxicFluids> findBy(FluidState state) {
            if (state.m_76178_()) {
                return Optional.empty();
            }
            return CACHED_FLUIDS.computeIfAbsent(state.m_76152_(), fluid -> ToxicFluids.findBy(ForgeBlock.getRegistryName((Fluid)fluid).m_135815_()));
        }

        public boolean affectSoilFrom(Level world, BlockPos startPos) {
            WorldSearch.Column column = WorldSearch.Column.from((LevelAccessor)world, (BlockPos)startPos);
            boolean affected = false;
            for (BlockPos pos : column.getChain()) {
                int pressure;
                int length;
                SoilChain chain;
                if (pos.m_123342_() > startPos.m_123342_() || !(chain = SoilChain.from(world, pos, length = (pressure = column.getTop().m_123342_() - pos.m_123342_()) + 2 + 1, column.getTop())).isAffected()) continue;
                affected = true;
            }
            return affected;
        }

        static {
            CACHED_FLUIDS = new ConcurrentHashMap<Fluid, Optional<ToxicFluids>>();
        }
    }
}

