function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
		'coremods/core_functions.js')

	var target = {
		'type': 'METHOD',
		'class': 'de/maxhenkel/car/entity/car/base/EntityCarFuelBase',
		'methodName': 'removeFuel',
		'methodDesc': '(I)V'
	}

	var getFluid = {
		'class': 'de/maxhenkel/car/entity/car/base/EntityCarFuelBase',
		'methodName': 'getFluid',
		'methodDesc': '()Lnet/minecraft/world/level/material/Fluid;'
	}

	var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName': 'onFuelBurned',
		'methodDesc': '(Lnet/minecraft/world/level/material/Fluid;ILnet/minecraft/world/entity/Entity;Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;)V'
	}

	var alignment = {
		'class': 'com/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment',
		'fieldName': 'BACK',
		'fieldDesc': 'Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;'
	}

	var instructions = [
	    insnLoadThis("car"),
		insnInvokeVirtual(getFluid),
		insnPushValue(20, "fuel amount"), // x20 multiplier because the default consumption is too low
		insnLoadThis("car"),
		insnGetStatic(alignment),
		insnCallHandler(handler)
	];

	return {
		'coremod': {
			'target': target,
			'transformer': function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}