/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.tiles.ForgeTileWithInventory;
import com.endertech.minecraft.forge.tiles.TileInventory;
import com.endertech.minecraft.forge.units.ITickableUnit;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.chains.WaterChain;
import com.endertech.minecraft.mods.adpother.entities.PurifiedAir;
import com.endertech.minecraft.mods.adpother.pollution.IFilterFrame;
import com.endertech.minecraft.mods.adpother.pollution.IPurifier;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class FilterFrame
extends ForgeBlock
implements ITiledBlock<BlockTile>,
IFilterFrame<BlockTile>,
ISmokeContainer,
IWaterLoggable {
    public static final EnumProperty<Condition> SATURATION = EnumProperty.m_61587_((String)"condition", Condition.class);
    public static final float WALL_THICKNESS = 0.125f;
    protected static final VoxelShape HOLE = FilterFrame.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape FILTER = FilterFrame.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE_EMPTY = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)HOLE, (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape SHAPE_FILLED = Shapes.m_83110_((VoxelShape)SHAPE_EMPTY, (VoxelShape)FILTER);
    protected final int slotLimit;
    protected final ForgeEnergy.StorageProps energyProps;
    protected final AirPurifier airPurifier;
    protected final WaterPurifier waterPurifier;

    public FilterFrame(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = props.name;
        this.slotLimit = props.slotLimit;
        this.energyProps = ForgeEnergy.StorageProps.create((UnitConfig)config, (String)category, (boolean)false, (int)(props.slotLimit * 100), (int)50);
        this.airPurifier = new AirPurifier(config, category, props.airPurifierEffectiveRadius, props.airPurifierMaxRadius);
        this.waterPurifier = new WaterPurifier(config, category, props.waterPurifierMaxRadius, props.waterPurifierEfficiency);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SATURATION, (Comparable)((Object)Condition.CLEAN))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public Class<BlockTile> getTileClass() {
        return BlockTile.class;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SATURATION, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)true);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return IWaterLoggable.getStateForPlacement((BlockPlaceContext)context, (BlockState)this.m_49966_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return IWaterLoggable.updateFluidPostPlacement((LevelAccessor)worldIn, (BlockPos)currentPos, (BlockState)stateIn);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.hasFilterMaterialInstalled(world, pos) ? SHAPE_FILLED : SHAPE_EMPTY;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return !this.hasFilterMaterialInstalled((BlockGetter)world, pos);
    }

    public boolean hasFilterMaterialInstalled(BlockGetter world, BlockPos pos) {
        return this.getTile(world, pos).map(tile -> !tile.getFilterMaterial().m_41619_()).orElse(false);
    }

    public BlockTile createTile(BlockPos pos, BlockState state) {
        return new BlockTile(pos, state);
    }

    @Override
    public int fill(BlockTile storage, Pollutant<?> pollutant, int amount) {
        if (amount <= 0) {
            return 0;
        }
        if (!storage.isActive()) {
            return 0;
        }
        IStorage.Content content = this.getContent(storage);
        ItemStack filterMaterial = storage.getFilterMaterial();
        int fullnessOld = content.getFullnessWith(pollutant);
        int count = content.fillWith(pollutant, amount);
        int fullnessNew = content.getFullnessWith(pollutant);
        int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
        ForgeEnergy.Storage energyStorage = storage.energyStorage;
        int materialUsed = materialCapacity != 0 ? fullnessNew / materialCapacity - fullnessOld / materialCapacity : 0;
        int energyUsed = energyStorage.getConsumption() * count;
        energyStorage.extractEnergy(energyUsed, false);
        storage.partialFullness = fullnessNew;
        TileInventory inventory = storage.getTileInventory();
        inventory.extractItem(0, materialUsed, false);
        ItemStack byproduct = pollutant.getFilterMaterials().getByproductFor(filterMaterial, materialUsed);
        inventory.insertItem(1, byproduct, false);
        this._handleChanges(content, (Object)storage);
        if (count > 0 && storage.m_58904_() != null) {
            new PollutantFilteredMsg(pollutant, storage.m_58899_()).sendTo(storage.m_58904_());
        }
        return count;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Optional tile = this.getTile((BlockGetter)world, pos);
        if (GameWorld.isServerSide((LevelReader)world) && tile.isPresent()) {
            ((BlockTile)((Object)tile.get())).energyStorage.set(this.energyProps);
            ((BlockTile)((Object)tile.get())).syncWithClients();
        }
    }

    public AirPurifier getAirPurifier() {
        return this.airPurifier;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            this.getTile((BlockGetter)level, pos).ifPresent(tile -> {
                FilterFrame.m_49840_((Level)level, (BlockPos)pos, (ItemStack)tile.getFilterMaterial());
                FilterFrame.m_49840_((Level)level, (BlockPos)pos, (ItemStack)tile.getByproduct());
                this.updateNeighbours(level, pos, state);
            });
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void updateNeighbours(Level level, BlockPos pos, BlockState state) {
        level.m_46672_(pos, (Block)this);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public IStorage.Content getContent(BlockTile tile) {
        return tile.content;
    }

    @Override
    public void onContentChanged(IStorage.Content content, BlockTile tile) {
        Level level = tile.m_58904_();
        if (level != null && GameWorld.isServerSide((LevelReader)level)) {
            level.m_186460_(tile.m_58899_(), (Block)this, 1);
        }
    }

    protected void spawnParticles(Level level, BlockPos pos, ColorARGB color) {
        DustParticleOptions options = new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)color.getARGB())), 1.0f);
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) continue;
            Function<Direction.Axis, Double> delta = axis -> direction.m_122434_() == axis ? 0.5 + 0.5625 * (double)direction.m_122436_().m_123304_(axis) : level.m_213780_().m_188500_();
            level.m_7106_((ParticleOptions)options, (double)pos.m_123341_() + delta.apply(Direction.Axis.X), (double)pos.m_123342_() + delta.apply(Direction.Axis.Y), (double)pos.m_123343_() + delta.apply(Direction.Axis.Z), 0.0, 0.0, 0.0);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockTile tile = this.getTile((BlockGetter)level, pos).orElse(null);
        if (tile != null && tile.lastFillingTime != null && tile.lastFilteredPollutant != null && CommonTime.Interval.passedFrom((CommonTime.Stamp)tile.lastFillingTime).lessThan(CommonTime.Interval.seconds((double)1.0))) {
            this.spawnParticles(level, pos, tile.lastFilteredPollutant.getColor());
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockTile storage = this.getTile((BlockGetter)level, pos).orElse(null);
        if (storage == null) {
            return;
        }
        IStorage.Content content = this.getContent(storage);
        ItemStack filterMaterial = storage.getFilterMaterial();
        List<Pollutant<?>> targetPollutants = storage.getTargetPollutants();
        for (Pollutant<?> pollutant2 : targetPollutants) {
            ItemStack byproduct;
            int capacity = this.getInitialCapacity(storage);
            int materialCapacity = pollutant2.getFilterMaterials().getCapacityFor(filterMaterial);
            int fullness = Math.max(storage.partialFullness, content.getFullnessWith(pollutant2));
            if (materialCapacity != 0) {
                storage.partialFullness = fullness %= materialCapacity;
            }
            if ((byproduct = storage.getByproduct()).m_41656_(pollutant2.getFilterMaterials().getByproductFor(filterMaterial, 1))) {
                fullness += materialCapacity * byproduct.m_41613_();
            } else if (!byproduct.m_41619_()) {
                fullness = capacity;
            }
            content.installFiltersFor(capacity, pollutant2);
            content.setFullnessWith(pollutant2, fullness);
        }
        AdPother.getInstance().pollutants.streamAll().forEach(pollutant -> {
            if (!targetPollutants.contains(pollutant)) {
                content.removeFiltersFor((Pollutant<?>)((Object)pollutant));
            }
        });
        storage.getTileInventory().setStackInSlot(2, new ItemStack((ItemLike)CommonCollect.getRandomElementFrom(targetPollutants).orElse(null)));
        this.dropByProductToBottomHopper(storage.getTileInventory());
        this.updateBlockState((Level)level, pos, state, content.getHighestFullnessPercentage());
        this.updateNeighbours((Level)level, pos, state);
        storage.renderMaterial = storage.getFilterMaterial();
        storage.isActive();
        content.changed = false;
        storage.syncWithClients();
    }

    protected boolean dropByProductToBottomHopper(TileInventory tileInventory) {
        ItemStack extractItem;
        Level world = tileInventory.getTile().m_58904_();
        Hopper hopper = this.getBottomHopper(world, tileInventory.getTile().m_58899_()).orElse(null);
        if (hopper != null && !(extractItem = tileInventory.extractItem(1, 1, true)).m_41619_()) {
            for (int j = 0; j < hopper.m_6643_(); ++j) {
                ItemStack destStack = hopper.m_8020_(j);
                if (!hopper.m_7013_(j, extractItem) || !destStack.m_41619_() && (destStack.m_41613_() >= destStack.m_41741_() || destStack.m_41613_() >= hopper.m_6893_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                extractItem = tileInventory.extractItem(1, 1, false);
                if (destStack.m_41619_()) {
                    hopper.m_6836_(j, extractItem);
                } else {
                    destStack.m_41769_(1);
                    hopper.m_6836_(j, destStack);
                }
                hopper.m_6596_();
                return true;
            }
        }
        return false;
    }

    private boolean isChimneyOrPump(LevelReader world, BlockPos pos) {
        return GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)pos) || GameWorld.SmokeContainers.isPump((LevelReader)world, (BlockPos)pos);
    }

    protected Optional<Hopper> getBottomHopper(Level world, BlockPos startPos) {
        BlockPos pos = GameWorld.Positions.getLastInLine((LevelReader)world, (BlockPos)startPos, this::isChimneyOrPump, (Direction)Direction.DOWN).m_7495_();
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof Hopper ? Optional.of((Hopper)tile) : Optional.empty();
    }

    protected void updateBlockState(Level world, BlockPos pos, BlockState state, Percentage fullness) {
        BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
        if (fullness.getGrade() == Percentage.Grade.HIGH) {
            newState = (BlockState)this.m_49966_().m_61124_(SATURATION, (Comparable)((Object)Condition.DIRTY));
        }
        if (state != newState) {
            world.m_46597_(pos, newState);
        }
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        LevelReader reader;
        if (direction == Direction.UP && level instanceof LevelReader && GameWorld.SmokeContainers.isPump((LevelReader)(reader = (LevelReader)level), (BlockPos)pos.m_7495_()) && this.getTile(level, pos).map(BlockTile::isActive).orElse(false).booleanValue()) {
            return GameBounds.REDSTONE_POWER.getIntBounds().getMax();
        }
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.m_6378_(state, level, pos, direction);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockTile tile = this.getTile((BlockGetter)level, pos).orElse(null);
        if (tile != null && tile.isActive()) {
            Percentage percentage = this.getContent(tile).getHighestFullnessPercentage();
            float factor = percentage.toFraction();
            int signal = GameBounds.REDSTONE_POWER.getIntBounds().interpolateDown(factor);
            return Math.max(1, signal);
        }
        return 0;
    }

    @Override
    public int getInitialCapacity(BlockTile storage) {
        int capacity = 0;
        ItemStack filterMaterial = storage.getFilterMaterial();
        for (Pollutant<?> pollutant : storage.getTargetPollutants()) {
            int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
            capacity = Math.max(capacity, materialCapacity * storage.getTileInventory().getSlotLimit(0));
        }
        return capacity;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            this.getTile((BlockGetter)world, pos).ifPresent(tile -> tile.openGuiScreenFor((ServerPlayer)player));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public ColorARGB getColor() {
        return ColorARGB.DEFAULT;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.CHIMNEY;
    }

    public boolean isActive(BlockGetter level, BlockPos pos) {
        LevelReader reader;
        BlockState state = level.m_8055_(pos);
        if (!(!IWaterLoggable.isWaterlogged((BlockState)state) || level instanceof LevelReader && GameWorld.SmokeContainers.isPump((LevelReader)(reader = (LevelReader)level), (BlockPos)pos.m_7495_()))) {
            return false;
        }
        return this.getTile(level, pos).map(BlockTile::isActive).orElse(false);
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        public int airPurifierEffectiveRadius = 1;
        public int airPurifierMaxRadius = 1;
        public int waterPurifierMaxRadius = 1;
        public Percentage waterPurifierEfficiency = Percentage.value((float)12.0f);
        public int slotLimit = 16;

        public static Properties<?> of(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
            this.vanillaProps.m_60913_(1.5f, 30.0f).m_60977_().m_60955_();
        }

        public T airPurifier(int effectiveRadius, int maxRadius) {
            this.airPurifierEffectiveRadius = effectiveRadius;
            this.airPurifierMaxRadius = maxRadius;
            return (T)((Object)((Properties)this.self));
        }

        public T waterPurifier(int maxRadius, Percentage efficiency) {
            this.waterPurifierMaxRadius = maxRadius;
            this.waterPurifierEfficiency = efficiency;
            return (T)((Object)((Properties)this.self));
        }

        public T slotLimit(int slotLimit) {
            this.slotLimit = slotLimit;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class AirPurifier
    implements IPurifier {
        public static final int MAX_RADIUS = 32;
        public final int effectiveRadius;
        public final int maximumRadius;

        public AirPurifier(UnitConfig config, String headCategory, int effectiveRadius, int maximumRadius) {
            String category = Names.dotted().join(new String[]{headCategory, "AirPurifier"});
            this.effectiveRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"effectiveRadius", (int)effectiveRadius, (IntBounds)IntBounds.between((Integer)0, (Integer)32), (String)"Defines the radius of the area in which the purified air created by this purifier has the maximum effect");
            this.maximumRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maximumRadius", (int)maximumRadius, (IntBounds)IntBounds.between((Integer)0, (Integer)32), (String)"Defines the maximum radius of the purified air effect.\nThe effect will fade between effectiveRadius and maximumRadius");
        }

        @Override
        public BlockPos getOutputPos(LevelReader world, BlockPos filterPos) {
            while (GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)(filterPos = filterPos.m_7494_()))) {
            }
            return filterPos;
        }

        @Override
        public BlockPos getPumpPos(LevelReader world, BlockPos filterPos) {
            BlockPos pumpPos = filterPos;
            while (GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)(pumpPos = pumpPos.m_7495_()))) {
            }
            return pumpPos;
        }

        @Override
        public boolean hasProperInput(LevelReader world, BlockPos pumpPos) {
            return !this.isBlockedFromAllSides(world, pumpPos, GameWorld.Directions.CLOCKWISE_HORIZONTALS);
        }

        protected boolean isBlockedFromAllSides(LevelReader world, BlockPos centerPos, Direction ... sides) {
            for (Direction side : sides) {
                if (this.isSideBlocked(world, centerPos, side)) continue;
                return false;
            }
            return true;
        }

        protected boolean isSideBlocked(LevelReader world, BlockPos pos, Direction side) {
            if (world.m_8055_(pos).m_60783_((BlockGetter)world, pos, side)) {
                return true;
            }
            BlockPos nextpos = pos.m_121945_(side);
            if (world.m_8055_(nextpos).m_60783_((BlockGetter)world, nextpos, side.m_122424_())) {
                return true;
            }
            float height = world.m_6425_(nextpos).m_76155_((BlockGetter)world, nextpos);
            return (double)height >= 0.7;
        }

        @Override
        public boolean hasProperOutput(LevelReader world, BlockPos outputPos) {
            while (!world.m_151570_(outputPos)) {
                BlockState state = world.m_8055_(outputPos);
                if (state.m_60795_()) {
                    return true;
                }
                if (state.m_60783_((BlockGetter)world, outputPos, Direction.DOWN)) {
                    return false;
                }
                if (this.isBlockedFromAllSides(world, outputPos, GameWorld.Directions.of().horizontals().up().toArray())) {
                    return false;
                }
                outputPos = outputPos.m_7494_();
            }
            return false;
        }
    }

    public static class WaterPurifier
    implements IPurifier {
        public static final CommonTime.Interval DEFAULT_UPDATE_INTERVAL = CommonTime.Interval.seconds((double)10.0);
        public static final int MAX_RADIUS = 16;
        public final int maximumRadius;
        public final Percentage efficiency;
        public CommonTime.Interval updateInterval;

        public WaterPurifier(UnitConfig config, String headCategory, int maximumRadius, Percentage efficiency) {
            this(config, headCategory, maximumRadius, efficiency, DEFAULT_UPDATE_INTERVAL);
        }

        public WaterPurifier(UnitConfig config, String headCategory, int maximumRadius, Percentage efficiency, CommonTime.Interval updateInterval) {
            String category = Names.dotted().join(new String[]{headCategory, "WaterPurifier"});
            this.maximumRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maximumRadius", (int)maximumRadius, (IntBounds)IntBounds.between((Integer)0, (Integer)16), (String)"Defines the maximum cleaning radius of the purifier (in blocks).");
            this.efficiency = UnitConfig.getPercentage((UnitConfig)config, (String)category, (String)"efficiency", (Percentage)efficiency, (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"Defines the efficiency of the purifier (in percent).\nThe lower the efficiency, the more filter material will be used up and the longer the cleaning process will take.");
            this.updateInterval = CommonTime.Interval.seconds((double)UnitConfig.getInt((UnitConfig)config, (String)category, (String)"updateInterval", (int)((int)updateInterval.inSeconds()), (IntBounds)IntBounds.between((Integer)1, (Integer)120), (String)"Defines the update interval (in seconds).\nThe smaller the interval, the higher the cleaning speed."));
        }

        @Override
        public BlockPos getOutputPos(LevelReader world, BlockPos filterPos) {
            return filterPos.m_7494_();
        }

        @Override
        public BlockPos getPumpPos(LevelReader world, BlockPos filterPos) {
            BlockPos pos = filterPos.m_7495_();
            if (GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)pos)) {
                pos = pos.m_7495_();
            }
            return pos;
        }

        @Override
        public boolean hasProperInput(LevelReader world, BlockPos pumpPos) {
            return GameWorld.Positions.getAroundHoriz((BlockPos)pumpPos, (boolean)false, (BlockPos[])new BlockPos[0]).stream().anyMatch(pos -> world.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_));
        }

        @Override
        public boolean hasProperOutput(LevelReader world, BlockPos outputPos) {
            return GameWorld.isAirBlock((LevelReader)world, (BlockPos)outputPos);
        }

        public Optional<BlockPos> findPollutedWater(LevelAccessor world, BlockPos filterPos, final List<Pollutant<?>> targetPollutants) {
            WaterChain chain = new WaterChain(world, this.getPumpPos((LevelReader)world, filterPos), this.maximumRadius){

                protected boolean onValidFound(BlockPos pos) {
                    return false;
                }

                protected boolean isValidBlock(BlockPos pos) {
                    return this.isWithinMaxRadius(pos) && PollutedWater.isSource((BlockGetter)this.world, pos) && PollutedWater.findPollutant((BlockGetter)this.world, pos, targetPollutants).isPresent();
                }
            };
            chain.build();
            return chain.getFound().stream().findFirst();
        }
    }

    public static enum Condition implements IForgeEnum
    {
        CLEAN,
        DIRTY;

    }

    public static class BlockTile
    extends ForgeTileWithInventory
    implements ITickableUnit {
        protected ItemStack renderMaterial = ItemStack.f_41583_;
        protected boolean active = false;
        protected boolean purifyingAir = false;
        protected boolean purifyingWater = false;
        @Nullable
        protected CommonTime.Stamp lastFillingTime = null;
        @Nullable
        protected Pollutant<?> lastFilteredPollutant = null;
        protected int partialFullness = 0;
        protected final IStorage.Content content = new IStorage.Content(0);
        protected final TileInventory inventory = new Inventory((BlockEntity)this, 3);
        protected final ContainerData dataAccess;
        protected final LazyOptional<CombinedInvWrapper> combinedHolder = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.inputHolder.orElse(null), (IItemHandlerModifiable)this.outputHolder.orElse(null)}));
        protected final ForgeEnergy.Storage energyStorage = ForgeEnergy.Storage.empty();
        protected final LazyOptional<ForgeEnergy.Storage> energyStorageHolder = LazyOptional.of(() -> this.energyStorage);
        private final GameTime updateInterval = GameTime.ticks((long)1L);
        protected final Lazy<GameTime> airPurifierUpdateInterval = Lazy.of(GameTime::second);
        protected final Lazy<GameTime> waterPurifierUpdateInterval = Lazy.of(() -> GameTime.time((CommonTime.Interval)this.getFilter().map(filter -> filter.waterPurifier.updateInterval).orElse(WaterPurifier.DEFAULT_UPDATE_INTERVAL)));

        public BlockTile(BlockPos pos, BlockState state) {
            super((BlockEntityType)AdPother.getInstance().tiles.filterFrame.get(), pos, state);
            this.dataAccess = new ContainerData(){

                public int m_6413_(int pIndex) {
                    switch (pIndex) {
                        case 0: {
                            Pollutant pollutant;
                            int materialCapacity;
                            Block block = Block.m_49814_((Item)this.getTileInventory().getStackInSlot(2).m_41720_());
                            if (block instanceof Pollutant && (materialCapacity = (pollutant = (Pollutant)block).getFilterMaterials().getCapacityFor(this.getFilterMaterial())) > 0) {
                                int fullness = content.getFullnessWith(pollutant) % materialCapacity;
                                return (int)Percentage.from((int)fullness, (int)materialCapacity).getValue();
                            }
                            return 0;
                        }
                    }
                    return 0;
                }

                public void m_8050_(int pIndex, int pValue) {
                }

                public int m_6499_() {
                    return 1;
                }
            };
        }

        @Nullable
        public Level getWorldLevel() {
            return this.m_58904_();
        }

        public boolean exists() {
            return !this.m_58901_();
        }

        public GameTime getUpdateInterval() {
            return this.updateInterval;
        }

        public void onUpdate() {
            if (this.m_58904_() != null) {
                if (GameWorld.isServerSide((LevelReader)this.m_58904_())) {
                    this.serverTick();
                } else {
                    this.clientTick();
                }
            }
        }

        public TileInventory getTileInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"container.adpother.filter_frame");
        }

        protected RangedWrapper createInput(final TileInventory inventory) {
            return new RangedWrapper((IItemHandlerModifiable)inventory, 0, 1){

                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (slot == 0 && MaterialSlot.isItemValid(inventory, stack)) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }

                @NotNull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return ItemStack.f_41583_;
                }
            };
        }

        protected RangedWrapper createOutput(TileInventory inventory) {
            return new RangedWrapper((IItemHandlerModifiable)inventory, 1, 2){

                @NotNull
                public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                    return stack;
                }
            };
        }

        protected AbstractContainerMenu createContainer(int id, Player player, net.minecraft.world.entity.player.Inventory playerInventory, TileInventory tileInventory) {
            return new Container(id, playerInventory, tileInventory, this.dataAccess);
        }

        protected void serverTick() {
            IPurifier purifier;
            boolean needSync = false;
            if (this.f_58857_ != null && ((GameTime)this.airPurifierUpdateInterval.get()).pastIn(this.f_58857_)) {
                purifier = this.getAirPurifier().orElse(null);
                if (purifier != null && purifier.isActive((LevelReader)this.f_58857_, this.f_58858_)) {
                    if (!this.purifyingAir) {
                        this.purifyingAir = true;
                        needSync = true;
                    }
                    BlockPos outputPos = ((AirPurifier)purifier).getOutputPos((LevelReader)this.f_58857_, this.f_58858_);
                    List<PurifiedAir> entities = PurifiedAir.getAllAt(this.f_58857_, outputPos);
                    for (Pollutant<?> pollutant : this.getTargetPollutants()) {
                        boolean exists = false;
                        for (PurifiedAir entity : entities) {
                            if (!entity.getPollutant().filter(p -> p == pollutant).isPresent()) continue;
                            exists = true;
                            break;
                        }
                        if (exists) continue;
                        this.f_58857_.m_7967_((Entity)new PurifiedAir(this.f_58857_, outputPos, pollutant, this.f_58858_));
                    }
                } else if (this.purifyingAir) {
                    this.purifyingAir = false;
                    needSync = true;
                }
            }
            if (this.f_58857_ != null && ((GameTime)this.waterPurifierUpdateInterval.get()).pastIn(this.f_58857_)) {
                purifier = this.getWaterPurifier().orElse(null);
                if (purifier != null && purifier.isActive((LevelReader)this.f_58857_, this.f_58858_)) {
                    Optional<BlockPos> waterPos;
                    boolean filled;
                    BlockPos abovePos;
                    BlockState aboveState;
                    if (!this.purifyingWater) {
                        this.purifyingWater = true;
                        needSync = true;
                    }
                    if ((aboveState = this.f_58857_.m_8055_(abovePos = ((WaterPurifier)purifier).getPumpPos((LevelReader)this.f_58857_, this.f_58858_).m_7494_())).m_61138_((Property)IWaterLoggable.WATERLOGGED) && !((Boolean)aboveState.m_61143_((Property)IWaterLoggable.WATERLOGGED)).booleanValue()) {
                        this.f_58857_.m_46597_(abovePos, (BlockState)aboveState.m_61124_((Property)IWaterLoggable.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                    }
                    FilterFrame filter = this.getFilter().orElse(null);
                    List<Pollutant<?>> targetPollutants = this.getTargetPollutants();
                    if (filter != null && !targetPollutants.isEmpty() && (filled = (waterPos = ((WaterPurifier)purifier).findPollutedWater((LevelAccessor)this.f_58857_, this.f_58858_, targetPollutants)).flatMap(pos -> PollutedWater.findPollutant((BlockGetter)this.f_58857_, pos, targetPollutants)).map(waterPollutant -> filter.fill(this, (Pollutant<?>)((Object)waterPollutant), 1) > 0).orElse(false).booleanValue()) && ((WaterPurifier)purifier).efficiency.takeChance()) {
                        this.f_58857_.m_46597_(waterPos.get(), Blocks.f_49990_.m_49966_());
                    }
                } else if (this.purifyingWater) {
                    this.purifyingWater = false;
                    needSync = true;
                }
            }
            if (needSync) {
                this.syncWithClients();
            }
        }

        protected void clientTick() {
            if (this.purifyingAir && GameTime.seconds((int)3).pastIn(this.f_58857_)) {
                this.getAirPurifier().ifPresent(purifier -> purifier.spawnParticle(this.f_58857_, this.f_58858_, ParticleTypes.f_123796_));
            }
            if (this.purifyingWater && GameTime.seconds((float)0.5f).pastIn(this.f_58857_)) {
                this.getWaterPurifier().ifPresent(purifier -> purifier.spawnParticle(this.f_58857_, this.f_58858_, ParticleTypes.f_123804_));
            }
        }

        public ItemStack getFilterMaterial() {
            return this.getTileInventory().getStackInSlot(0);
        }

        public ItemStack getRenderMaterial() {
            return this.renderMaterial;
        }

        public ItemStack getByproduct() {
            return this.getTileInventory().getStackInSlot(1);
        }

        public boolean isValidFilterMaterial(ItemStack stack) {
            return AdPother.getInstance().pollutants.streamAll().anyMatch(pollutant -> pollutant.getFilterMaterials().contains(stack));
        }

        public boolean isActive() {
            if (this.m_58904_() == null) {
                return false;
            }
            if (GameWorld.isServerSide((LevelReader)this.m_58904_())) {
                boolean newValue = false;
                if (this.content.hasFunctionalFilters() && (!this.energyStorage.isEnabled() || this.energyStorage.hasEnoughEnergy())) {
                    for (Pollutant<?> pollutant : this.getTargetPollutants()) {
                        if (this.content.getFreeSpaceFor(pollutant) <= 0) continue;
                        newValue = true;
                    }
                }
                if (this.active != newValue) {
                    this.active = newValue;
                }
            }
            return this.active;
        }

        public List<Pollutant<?>> getTargetPollutants() {
            ItemStack material = this.getFilterMaterial();
            if (material.m_41619_()) {
                return Collections.emptyList();
            }
            return AdPother.getInstance().pollutants.streamAll().filter(pollutant -> pollutant.getFilterMaterials().contains(material)).collect(Collectors.toList());
        }

        protected Optional<AirPurifier> getAirPurifier() {
            return this.getFilter().map(filter -> filter.airPurifier);
        }

        protected Optional<WaterPurifier> getWaterPurifier() {
            return this.getFilter().map(filter -> filter.waterPurifier);
        }

        protected Optional<FilterFrame> getFilter() {
            Block block = this.m_58900_().m_60734_();
            return block instanceof FilterFrame ? Optional.of((FilterFrame)block) : Optional.empty();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (side != null && cap == ForgeCapabilities.ITEM_HANDLER) {
                return switch (side) {
                    case Direction.UP -> this.inputHolder.cast();
                    case Direction.DOWN -> this.outputHolder.cast();
                    default -> this.combinedHolder.cast();
                };
            }
            if (cap == ForgeCapabilities.ENERGY && this.energyStorage.isEnabled()) {
                return this.energyStorageHolder.cast();
            }
            return super.getCapability(cap, side);
        }

        public void readSharedData(CompoundTag compound) {
            this.active = compound.m_128471_("active");
            this.purifyingAir = compound.m_128471_("purifyingAir");
            this.purifyingWater = compound.m_128471_("purifyingWater");
            this.content.readFromNBT(compound);
            this.renderMaterial = ItemStack.m_41712_((CompoundTag)compound.m_128469_("RenderMaterial"));
            this.energyStorage.readFrom(compound);
            this.partialFullness = compound.m_128451_("partialFullness");
        }

        public CompoundTag writeSharedData(CompoundTag compound) {
            compound.m_128379_("active", this.active);
            compound.m_128379_("purifyingAir", this.purifyingAir);
            compound.m_128379_("purifyingWater", this.purifyingWater);
            this.content.writeToNBT(compound);
            compound.m_128365_("RenderMaterial", (Tag)TagHelper.serialize((INBTSerializable)this.renderMaterial));
            this.energyStorage.writeTo(compound);
            compound.m_128405_("partialFullness", this.partialFullness);
            return compound;
        }
    }

    static class MaterialSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 0;

        public MaterialSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 0, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return MaterialSlot.isItemValid(this.tileInventory, stack);
        }

        public static boolean isItemValid(TileInventory tileInventory, ItemStack stack) {
            if (tileInventory.getTile() instanceof BlockTile) {
                return ((BlockTile)tileInventory.getTile()).isValidFilterMaterial(stack);
            }
            return false;
        }
    }

    static class ByproductSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 1;

        public ByproductSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 1, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }

    public static class PollutantFilteredMsg
    extends ForgeNetMsg<PollutantFilteredMsg> {
        public int pollutantId;
        public BlockPos pos;

        public PollutantFilteredMsg() {
        }

        public PollutantFilteredMsg(Pollutant<?> pollutant, BlockPos pos) {
            this.pollutantId = Block.m_49956_((BlockState)pollutant.m_49966_());
            this.pos = pos;
        }

        public PollutantFilteredMsg create() {
            return new PollutantFilteredMsg();
        }

        public void handle(Level level, Player player) {
            Block block = Block.m_49803_((int)this.pollutantId).m_60734_();
            if (block instanceof Pollutant) {
                Pollutant pollutant = (Pollutant)block;
                block = level.m_8055_(this.pos).m_60734_();
                if (block instanceof FilterFrame) {
                    FilterFrame filterFrame = (FilterFrame)block;
                    filterFrame.getTile((BlockGetter)level, this.pos).ifPresent(tile -> {
                        tile.lastFillingTime = CommonTime.Stamp.now();
                        tile.lastFilteredPollutant = pollutant;
                    });
                }
            }
        }

        public void sendTo(Level level) {
            AdPother.getInstance().getConnection().sendToAllObservingChunk((Object)this, level.m_46745_(this.pos));
        }
    }

    static class PollutantSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 2;

        public PollutantSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 2, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }

    public static class Container
    extends TileInventory.AbstractContainer {
        private final ContainerData data;

        public Container(int id, net.minecraft.world.entity.player.Inventory playerInventory, TileInventory tileInventory, ContainerData data) {
            super((MenuType)AdPother.getInstance().containers.filterFrame.get(), id, playerInventory, tileInventory);
            this.data = data;
            this.m_38897_((Slot)new MaterialSlot(tileInventory, 56, 17));
            this.m_38897_((Slot)new ByproductSlot(tileInventory, 116, 35));
            this.m_38897_((Slot)new PollutantSlot(tileInventory, 56, 53));
            this.addPlayerSlots(8, 84);
            this.m_38884_(data);
        }

        public Percentage getByproductProgress() {
            return Percentage.value((float)this.data.m_6413_(0));
        }

        public static class Factory
        implements IContainerFactory<Container> {
            public Container create(int windowId, net.minecraft.world.entity.player.Inventory playerInventory, FriendlyByteBuf data) {
                Level world = playerInventory.f_35978_.f_19853_;
                BlockPos pos = data.m_130135_();
                BlockEntity te = world.m_7702_(pos);
                if (te instanceof BlockTile) {
                    BlockTile tile = (BlockTile)te;
                    return new Container(windowId, playerInventory, tile.getTileInventory(), tile.dataAccess);
                }
                return null;
            }
        }
    }

    public static class BlockItem
    extends net.minecraft.world.item.BlockItem
    implements IStorageItem {
        public BlockItem(ForgeBlock block, Item.Properties props) {
            super((Block)block, props);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, Level world, List<Component> lines, TooltipFlag flag) {
            IStorageItem.super.appendHoverText(stack, world, lines, flag);
            super.m_7373_(stack, world, lines, flag);
        }

        @Override
        public int getInitialCapacity(ItemStack storage) {
            return 0;
        }
    }

    public static class Inventory
    extends TileInventory {
        public Inventory(BlockEntity tile, int size) {
            super(tile, size);
        }

        public int getSlotLimit(int slot) {
            Block block = this.tile.m_58900_().m_60734_();
            return block instanceof FilterFrame ? ((FilterFrame)block).slotLimit : 0;
        }

        protected void onContentsChanged(int slot) {
            if (slot != 2 && this.tile.m_58904_() != null) {
                this.tile.m_58904_().m_186460_(this.tile.m_58899_(), this.tile.m_58900_().m_60734_(), 1);
            }
            super.onContentsChanged(slot);
        }
    }
}

