/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.mods.adpother.AdPother;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;

public class DynamicTrees {
    private static Optional<DynamicTrees> instance = null;
    protected final Class<?> classTreeHelper = Class.forName("com.ferreusveritas.dynamictrees.api.TreeHelper");
    protected final Class<?> classTreePart = Class.forName("com.ferreusveritas.dynamictrees.api.treedata.TreePart");
    protected final Class<?> classDynamicLeavesBlock = Class.forName("com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock");
    protected final Class<?> classSafeChunkBounds = Class.forName("com.ferreusveritas.dynamictrees.util.SafeChunkBounds");
    protected final Method findRootNode = this.classTreeHelper.getMethod("findRootNode", Level.class, BlockPos.class);
    protected final Method growPulse = this.classTreeHelper.getMethod("growPulse", Level.class, BlockPos.class);
    protected final Method getBranch = this.classTreeHelper.getMethod("getBranch", BlockState.class);
    protected final Method getLeaves = this.classTreeHelper.getMethod("getLeaves", BlockState.class);
    protected final Method leaves$age = this.classDynamicLeavesBlock.getMethod("age", LevelAccessor.class, BlockPos.class, BlockState.class, RandomSource.class, this.classSafeChunkBounds);
    protected final Field bounds$ANY = this.classSafeChunkBounds.getField("ANY");

    public static Optional<DynamicTrees> getInstance() {
        if (instance == null) {
            if (ModList.get().isLoaded("dynamictrees")) {
                try {
                    instance = Optional.of(new DynamicTrees());
                    return instance;
                }
                catch (Exception e) {
                    DynamicTrees.logError(e);
                }
            }
            instance = Optional.empty();
        }
        return instance;
    }

    protected static void logError(Exception e) {
        AdPother.getInstance().getLogger().error(e.toString());
    }

    private DynamicTrees() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
    }

    public void tryGrow(ServerLevel level, BlockPos startPos, BlockState state) {
        try {
            if (!this.classTreePart.isInstance(state.m_60734_())) {
                return;
            }
            BlockPos branchPos = this.findBranchUnderLeaves(level, startPos).orElse(null);
            if (branchPos != null) {
                BlockPos rootPos = (BlockPos)this.findRootNode.invoke(null, level, branchPos);
                if (rootPos != BlockPos.f_121853_) {
                    this.growPulse.invoke(null, level, rootPos);
                }
            } else {
                Object leaves = this.getLeaves.invoke(null, state);
                if (leaves != null) {
                    this.leaves$age.invoke(leaves, level, startPos, state, level.f_46441_, this.bounds$ANY.get(null));
                }
            }
        }
        catch (Exception e) {
            DynamicTrees.logError(e);
        }
    }

    public Optional<BlockPos> findBranchUnderLeaves(ServerLevel level, BlockPos startPos) {
        try {
            int offset = 0;
            while (true) {
                BlockPos pos = startPos.m_5484_(Direction.DOWN, offset);
                BlockState state = level.m_8055_(pos);
                if (this.getBranch.invoke(null, state) != null) {
                    return Optional.of(pos);
                }
                if (this.getLeaves.invoke(null, state) != null) {
                    ++offset;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DynamicTrees.logError(e);
        }
        return Optional.empty();
    }
}

