/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.compat.DynamicTrees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;

public class BlockImpactList
extends AbstractParsableList {
    protected final BlockStatesMap<List<AbstractAction>> actions = new BlockStatesMap();
    private final String comment;

    public BlockImpactList(UnitConfig config, String category, String key, String comment) {
        super(config, category, key, new String[0]);
        this.comment = comment;
    }

    public List<AbstractAction> getActionsFor(BlockState state) {
        return Optional.ofNullable((List)this.actions.get((Object)state)).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    protected String getComment() {
        return this.comment;
    }

    protected void parseConfigValues() {
        this.actions.clear();
        for (String string : this.configValues) {
            List split = this.split(string, "->");
            if (split.size() == 2) {
                split.add(0, "0%");
            }
            try {
                if (split.size() != 3) {
                    throw new Exception();
                }
                Percentage threshold = Percentage.parse((String)((String)split.get(0)));
                UnitId blockId = UnitId.from((String)((String)split.get(1)));
                if (blockId.isEmpty()) {
                    throw new Exception();
                }
                String arg3 = (String)split.get(2);
                if (arg3.equals(arg3.toUpperCase(Locale.ROOT))) {
                    ActionType action = ActionType.valueOf(arg3);
                    this.addAction(blockId, action.create(threshold, Optional.empty()));
                    continue;
                }
                UnitId replacementId = UnitId.from((String)arg3);
                if (replacementId.isEmpty()) {
                    throw new Exception();
                }
                BlockState replacement = replacementId.getFirstMatchedState();
                if (replacement == null) continue;
                this.addAction(blockId, ActionType.REPLACE.create(threshold, Optional.of(replacement)));
            }
            catch (Exception e) {
                this.logParsingError(string);
            }
        }
    }

    protected void addAction(UnitId blockId, AbstractAction action) {
        BlockStatesSet set = blockId.getAllMatchedBlockStates();
        if (set == null) {
            return;
        }
        Consumer<List> addAndSort = list -> {
            list.add(action);
            list.sort((v1, v2) -> v2.threshold.compareTo(v1.threshold));
        };
        set.getBlocksWithAllStates().stream().map(block -> this.actions.getBlocksWithAllStates().computeIfAbsent(block, b -> new ArrayList())).forEach(addAndSort);
        set.stream().map(state -> (List)this.actions.computeIfAbsent(state, s -> new ArrayList())).forEach(addAndSort);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ActionType {
        BONEMEAL(ChatFormatting.GREEN){

            @Override
            public AbstractAction create(Percentage threshold, Optional<Object> data) {
                return new AbstractAction(this, threshold){

                    @Override
                    public boolean perform(ServerLevel level, BlockPos pos, BlockState state) {
                        BonemealableBlock growable;
                        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)new ChunkPos(pos), (boolean)true, (ChunkPos[])new ChunkPos[0])) {
                            if (level.m_7726_().m_5563_(chunkPos.f_45578_, chunkPos.f_45579_)) continue;
                            return false;
                        }
                        Block block = state.m_60734_();
                        if (block instanceof LeavesBlock) {
                            BlockState leaves = state;
                            DynamicTrees.getInstance().ifPresent(tree -> tree.tryGrow(level, pos, leaves));
                            return true;
                        }
                        if (!(block instanceof BonemealableBlock)) {
                            return false;
                        }
                        if (!ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                            return false;
                        }
                        state = level.m_8055_(pos);
                        block = state.m_60734_();
                        if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).m_7370_((BlockGetter)level, pos, state, level.f_46443_)) {
                            try {
                                growable.m_214148_(level, level.f_46441_, pos, state);
                            }
                            catch (Exception e) {
                                AdPother.getInstance().getLogger().error("Unable to bonemeal " + state + " because of " + e);
                                return false;
                            }
                            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                            return true;
                        }
                        return false;
                    }
                };
            }
        }
        ,
        KILL(ChatFormatting.RED){

            @Override
            public AbstractAction create(Percentage threshold, Optional<Object> data) {
                return new AbstractAction(this, threshold){

                    @Override
                    public boolean perform(ServerLevel level, BlockPos pos, BlockState state) {
                        return level.m_7471_(pos, false);
                    }
                };
            }
        }
        ,
        REPLACE(ChatFormatting.YELLOW){

            @Override
            public AbstractAction create(Percentage threshold, final Optional<Object> data) {
                return new AbstractAction(this, threshold){

                    @Override
                    public boolean perform(ServerLevel level, BlockPos pos, BlockState state) {
                        Object t;
                        if (data.isPresent() && (t = data.get()) instanceof BlockState) {
                            BlockState replacement = (BlockState)t;
                            return level.m_46597_(pos, replacement);
                        }
                        return false;
                    }
                };
            }
        }
        ,
        POLLUTE(ChatFormatting.DARK_AQUA){

            @Override
            public AbstractAction create(Percentage threshold, Optional<Object> data) {
                return new AbstractAction(this, threshold){

                    @Override
                    public boolean perform(ServerLevel level, BlockPos pos, BlockState state) {
                        return ((PollutedWater)((Object)AdPother.getInstance().blocks.pollutedWater.get())).tryPollute(level, pos, state);
                    }
                };
            }
        };

        public final ChatFormatting textColor;

        public abstract AbstractAction create(Percentage var1, Optional<Object> var2);

        private ActionType(ChatFormatting textColor) {
            this.textColor = textColor;
        }
    }

    public static abstract class AbstractAction {
        public final ActionType type;
        public final Percentage threshold;

        public AbstractAction(ActionType type, Percentage threshold) {
            this.type = type;
            this.threshold = threshold;
        }

        public abstract boolean perform(ServerLevel var1, BlockPos var2, BlockState var3);
    }
}

