/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class Spread {
    public static final int ANY_DENSITY_DELTA = Integer.MIN_VALUE;
    private final Pollutant<?> pollutant;
    private final Level level;
    private final BlockPos sourcePos;
    @Nullable
    private BlockPos targetPos;
    private BlockState sourceState;
    @Nullable
    private BlockState targetState;
    private boolean sourceChanged = false;
    private boolean targetChanged = false;
    private final Optional<Direction> motionFacing;

    public static Spread from(Level world, BlockPos pos, BlockState state, Pollutant<?> pollutant) {
        return new Spread(world, pos, state, pollutant);
    }

    protected Spread(Level level, BlockPos pos, BlockState state, Pollutant<?> pollutant) {
        this.pollutant = pollutant;
        this.level = level;
        this.sourcePos = pos;
        this.sourceState = state;
        this.motionFacing = pollutant.getMotionFacing((LevelAccessor)level, pos);
    }

    @Nullable
    public BlockState getTargetState() {
        return this.targetState;
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    protected void setTargetPos(BlockPos targetPos) {
        this.targetPos = targetPos;
    }

    protected void setTarget(BlockState target) {
        if (this.targetState != target) {
            this.targetState = target;
            this.targetChanged = true;
        }
    }

    public BlockState getSourceState() {
        return this.sourceState;
    }

    public void setSource(BlockState source) {
        if (this.sourceState != source) {
            this.sourceState = source;
            this.sourceChanged = true;
        }
    }

    public boolean sourceChanged() {
        return this.sourceChanged;
    }

    public boolean targetChanged() {
        return this.targetChanged;
    }

    public Pollutant<?> getPollutant() {
        return this.pollutant;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getSourcePos() {
        return this.sourcePos;
    }

    public Spread around(int minDensityDelta) {
        if (!this.completed() && this.pollutant.canSpreadAround() && this.pollutant.getCarriedPollutionAmount(this.getSourceState()) >= minDensityDelta) {
            for (Direction facing : GameWorld.Directions.of().horizontals().shuffle().toArray()) {
                if (this.in(facing, minDensityDelta).completed()) break;
            }
        }
        return this;
    }

    public Spread in(Optional<Direction> direction, int minDensityDelta) {
        return !this.completed() && direction.isPresent() ? this.in(direction.get(), minDensityDelta) : this;
    }

    public Spread in(Direction direction, int minDensityDelta) {
        if (this.completed() || this.level.m_8055_(this.sourcePos).m_60783_((BlockGetter)this.level, this.sourcePos, direction)) {
            return this;
        }
        BlockPos destPos = this.sourcePos.m_121945_(direction);
        if (this.to(destPos, minDensityDelta).completed()) {
            return this;
        }
        if (this.pollutant.canPassThrough((LevelReader)this.level, destPos, direction.m_122424_(), direction)) {
            return this.to(destPos.m_121945_(direction), minDensityDelta);
        }
        return this;
    }

    public Spread inMotionFacing() {
        return this.in(this.motionFacing, 0);
    }

    public Spread to(BlockPos targetPos, int minDensityDelta) {
        if (!this.completed() && this.getLevel().m_46739_(targetPos)) {
            int pollutionDelta;
            BlockState sourceState = this.getSourceState();
            BlockState targetState = this.level.m_8055_(targetPos);
            while (this.pollutant.canStateBeSpreaded(sourceState) && this.pollutant.canStateBePumped(targetState) && (pollutionDelta = this.pollutant.getCarriedPollutionAmount(sourceState) - this.pollutant.getCarriedPollutionAmount(targetState)) >= minDensityDelta) {
                sourceState = this.pollutant.getSpreadedState(sourceState);
                this.setSource(sourceState);
                this.setTargetPos(targetPos);
                targetState = this.pollutant.getPumpedState(targetState);
                this.setTarget(targetState);
            }
        }
        return this;
    }

    public Spread overLedge() {
        if (!this.completed() && this.pollutant.canSpreadOverLedge() && this.motionFacing.isPresent()) {
            int minDelta;
            BlockPos ledgePos = this.sourcePos.m_121945_(this.motionFacing.get());
            int n = minDelta = this.pollutant.isSamePollutant(this.level.m_8055_(ledgePos)) ? 0 : -1;
            if (this.getLevel().m_46739_(ledgePos)) {
                for (Direction facing : GameWorld.Directions.of().horizontals().shuffle().toArray()) {
                    BlockPos targetPos;
                    BlockPos checkPos = this.sourcePos.m_121945_(facing);
                    if (!this.level.m_8055_(this.sourcePos).m_60783_((BlockGetter)this.level, this.sourcePos, facing) && this.pollutant.canPassThrough((LevelReader)this.level, checkPos, facing.m_122424_(), this.motionFacing.get()) && this.to(targetPos = ledgePos.m_121945_(facing), minDelta).completed()) break;
                }
            }
        }
        return this;
    }

    public boolean isValid() {
        return this.completed() && this.getTargetPos() != null && this.getTargetState() != null && !this.level.f_46443_;
    }

    public boolean completed() {
        return this.sourceChanged && this.targetChanged;
    }

    protected void apply(BlockPos pos, BlockState state) {
        this.level.m_46597_(pos, state);
        if (!state.m_60795_()) {
            this.pollutant.scheduleUpdate(this.level, pos);
        }
    }

    public void applyTarget() {
        if (this.isValid()) {
            this.apply(this.getTargetPos(), this.getTargetState());
        }
    }

    public void applySource() {
        if (this.isValid()) {
            this.apply(this.getSourcePos(), this.getSourceState());
        }
    }

    public void apply() {
        this.applySource();
        this.applyTarget();
    }
}

