function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'dev/momostudios/coldsweat/common/blockentity/BoilerBlockEntity',
		'methodName' : 'tick',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)V'
	}

	var node = {
		'class' : 'dev/momostudios/coldsweat/common/blockentity/BoilerBlockEntity',
		'methodName' : 'setFuel',
		'methodDesc' : '(I)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onLavaFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/level/block/entity/BlockEntity;I)V'
	}

	var instructions = [ 
		insnLoadThis("boiler"),
		insnPushValue(1, "amount"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}