function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'slimeknights/tconstruct/smeltery/block/entity/module/FuelModule',
		'methodName' : 'trySolidFuel',    
		'methodDesc' : '(Lnet/minecraftforge/items/IItemHandler;Z)I'
	}

	var node = {
		'class' : 'net/minecraftforge/items/IItemHandler',
		'methodName' : 'extractItem', 
		'methodDesc' : '(IIZ)Lnet/minecraft/world/item/ItemStack;'
	}
	
	var parent = {
		'class' : 'slimeknights/tconstruct/smeltery/block/entity/module/FuelModule',
		'fieldName' : 'parent',
		'fieldDesc' : 'Lslimeknights/mantle/block/entity/MantleBlockEntity;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnDup("fuel stack"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("fuel module"),
		insnGetField(parent),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}