/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class DataCollector {
    protected final AbstractForgeMod mod;
    protected final GatherDataEvent event;
    public final String modId;
    public final DataGenerator generator;
    public final PackOutput output;
    public final CompletableFuture<HolderLookup.Provider> lookupProvider;
    public final ExistingFileHelper fileHelper;

    public DataCollector(AbstractForgeMod mod, GatherDataEvent event) {
        this.mod = mod;
        this.event = event;
        this.modId = mod.getId();
        this.generator = event.getGenerator();
        this.output = event.getGenerator().getPackOutput();
        this.lookupProvider = event.getLookupProvider();
        this.fileHelper = event.getExistingFileHelper();
    }

    protected <T extends DataProvider> void addProvider(boolean run, T provider) {
        this.event.getGenerator().addProvider(run, provider);
    }

    public DataCollector addBlockAndItemTags(BlockTagsProviderFactory<?> blockTagsFactory, ItemTagsProviderFactory<?> itemTagsFactory) {
        if (this.event.includeServer()) {
            Object blockTagsProvider = blockTagsFactory.create(this.output, this.lookupProvider, this.modId, this.fileHelper);
            this.addProvider(true, (DataProvider)blockTagsProvider);
            this.addProvider(true, (DataProvider)itemTagsFactory.create(this.output, this.lookupProvider, blockTagsProvider.m_274426_(), this.modId, this.fileHelper));
        }
        return this;
    }

    public DataCollector addLootTables(DataProvider.Factory<? extends LootTableProvider> providerFactory) {
        if (this.event.includeServer()) {
            this.addProvider(true, (LootTableProvider)providerFactory.m_253034_(this.output));
        }
        return this;
    }

    public DataCollector addRecipes(DataProvider.Factory<? extends RecipeProvider> providerFactory) {
        if (this.event.includeServer()) {
            this.addProvider(true, (RecipeProvider)providerFactory.m_253034_(this.output));
        }
        return this;
    }

    public DataCollector addBlockStates(ClientDataProviderFactory<? extends BlockStateProvider> providerFactory) {
        if (this.event.includeClient()) {
            this.addProvider(true, providerFactory.create(this.output, this.modId, this.fileHelper));
        }
        return this;
    }

    public DataCollector addItemModels(ClientDataProviderFactory<? extends ItemModelProvider> providerFactory) {
        if (this.event.includeClient()) {
            this.addProvider(true, providerFactory.create(this.output, this.modId, this.fileHelper));
        }
        return this;
    }

    public DataCollector addLanguageUS(LanguageProviderFactory<?> providerFactory) {
        if (this.event.includeClient()) {
            this.addProvider(true, (DataProvider)providerFactory.create(this.output, this.modId, "en_us"));
        }
        return this;
    }

    @FunctionalInterface
    public static interface BlockTagsProviderFactory<T extends BlockTagsProvider> {
        public T create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, String var3, @Nullable ExistingFileHelper var4);
    }

    @FunctionalInterface
    public static interface ItemTagsProviderFactory<T extends ItemTagsProvider> {
        public T create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, CompletableFuture<TagsProvider.TagLookup<Block>> var3, String var4, @Nullable ExistingFileHelper var5);
    }

    @FunctionalInterface
    public static interface ClientDataProviderFactory<T extends DataProvider> {
        public T create(PackOutput var1, String var2, @Nullable ExistingFileHelper var3);
    }

    @FunctionalInterface
    public static interface LanguageProviderFactory<T extends LanguageProvider> {
        public T create(PackOutput var1, String var2, String var3);
    }
}

