/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateCarrier
extends ForgeEntity {
    protected static final String CARRIED_STATE_TAG = "carried_state";
    private static final EntityDataAccessor<Optional<BlockState>> CARRIED_BLOCK_STATE = SynchedEntityData.m_135353_(BlockStateCarrier.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);

    public BlockStateCarrier(EntityType<?> type, Level world, BlockPos pos, BlockState carriedState) {
        super(type, world);
        Vect3d centeredPos = BlockStateCarrier.getCenteredPosTo(pos);
        this.setAllPositions(centeredPos);
        this.setCarriedBlockState(Optional.ofNullable(carriedState));
    }

    public BlockStateCarrier(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CARRIED_BLOCK_STATE, Optional.empty());
    }

    public Optional<BlockState> getCarriedBlockState() {
        return (Optional)this.m_20088_().m_135370_(CARRIED_BLOCK_STATE);
    }

    protected void setCarriedBlockState(Optional<BlockState> newState) {
        this.m_20088_().m_135381_(CARRIED_BLOCK_STATE, newState);
    }

    public boolean carriesSameBlock(Optional<? extends Block> block) {
        return this.getCarriedBlockState().map(state -> state.m_60734_()).equals(block);
    }

    protected void m_7380_(CompoundTag compound) {
        this.getCarriedBlockState().ifPresent(state -> compound.m_128365_(CARRIED_STATE_TAG, (Tag)NbtUtils.m_129202_((BlockState)state)));
    }

    protected void m_7378_(CompoundTag compound) {
        BlockState state = NbtUtils.m_247651_((HolderGetter)this.f_19853_.m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_(CARRIED_STATE_TAG));
        this.m_20088_().m_135381_(CARRIED_BLOCK_STATE, Optional.of(state));
    }
}

