/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FilterMaterialList
extends AbstractParsableList {
    protected final Map<Item, MaterialData> materials = new ConcurrentHashMap<Item, MaterialData>();

    public FilterMaterialList(UnitConfig config, String category) {
        super(config, category, "filterMaterials", new String[0]);
    }

    public Set<Item> getMaterials() {
        return Collections.unmodifiableSet(this.materials.keySet());
    }

    protected Optional<MaterialData> getData(ItemStack stack) {
        return Optional.ofNullable(this.materials.get(stack.m_41720_()));
    }

    public boolean contains(ItemStack stack) {
        return this.getData(stack).isPresent();
    }

    public ItemStack getByproductFor(ItemStack stack, int amount) {
        return this.getData(stack).map(data -> new ItemStack((ItemLike)data.byproduct, amount)).orElse(ItemStack.f_41583_);
    }

    public int getCapacityFor(ItemStack stack) {
        return this.getData(stack).map(data -> data.capacity).orElse(0);
    }

    protected String getComment() {
        return "List of materials which can be used to filter this pollutant.\nFormat: materialID, capacity, byproductID\n<materialID> - the id of the material that will be used to filter this pollutant,\n<capacity> - how many pollutant blocks each piece of material can filter,\n<byproduct> - the byproduct of the used filter material.";
    }

    protected void parseConfigValues() {
        this.materials.clear();
        for (String string : this.configValues) {
            boolean error;
            List split = this.splitArgs(string);
            if (split.size() == 2) {
                split.add("minecraft:air");
            }
            boolean bl = error = split.size() < 3;
            if (!error) {
                UnitId materialId = UnitId.from((String)((String)split.get(0)));
                UnitId byproductId = UnitId.from((String)((String)split.get(2)));
                error = materialId.isEmpty();
                if (!error) {
                    Collection allMatched;
                    Integer capacity = null;
                    Item byproduct = null;
                    try {
                        capacity = Integer.parseInt((String)split.get(1));
                        if (capacity <= 0) {
                            error = true;
                        }
                        byproduct = Optional.ofNullable(byproductId.getFirstMatchedItem()).orElse(Items.f_41852_);
                    }
                    catch (Exception e) {
                        error = true;
                    }
                    if (!error && (allMatched = materialId.getAllMatchedItems()) != null && byproduct != null) {
                        for (Item item : allMatched) {
                            this.materials.put(item, new MaterialData(capacity, byproduct));
                        }
                    }
                }
            }
            if (!error) continue;
            this.logParsingError(string);
        }
    }

    protected class MaterialData {
        public final int capacity;
        public final Item byproduct;

        public MaterialData(int capacity, Item byproduct) {
            this.capacity = capacity;
            this.byproduct = byproduct;
        }
    }
}

