function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'shadows/fastfurnace/tile/TileFastFurnace',
		'methodName' : resolveName('func_73660_a'), // tick   
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : resolveName('m_41774_'), // shrink 
		'methodDesc' : '(I)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnPushValue(1, "fuel amount"),
		insnLoadThis("furnace tile"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, [].concat(instructionsDupValue2("fuel stack"), instructions));
				return method;
			}
		}
	}
}