function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'mekanism/generators/common/tile/TileEntityHeatGenerator',
		'methodName' : 'onUpdateServer',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'mekanism/generators/common/slot/FluidFuelInventorySlot',
		'methodName' : 'fillOrBurn',
		'methodDesc' : '()V'
	}
	
	var getFuelStack = {
		'class' : 'mekanism/generators/common/slot/FluidFuelInventorySlot',
		'methodName' : 'getStack',
		'methodDesc' : '()Lnet/minecraft/world/item/ItemStack;'
	}

	var getFluidTank = {
		'class' : 'mekanism/generators/common/slot/FluidFuelInventorySlot',
		'methodName' : 'getFluidTank',
		'methodDesc' : '()Lmekanism/api/fluid/IExtendedFluidTank;'
	}

	var getNeeded = {
		'class' : 'mekanism/api/fluid/IExtendedFluidTank',
		'methodName' : 'getNeeded',
		'methodDesc' : '()I'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var labelEnd = newLabel();
	
	var instructions = [ 
		insnDup("dup fuel slot"),
		insnInvokeVirtual(getFluidTank),
		insnInvokeInterface(getNeeded),
		insnIfLE_JumpTo(labelEnd),
		
		insnDup("dup fuel slot"),
		insnInvokeVirtual(getFuelStack),
		insnPushInt(1, "fuel amount"),
		insnLoadThis("heat generator tile"), 
		insnCallHandler(handler),
		
		labelEnd
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions, true);
				return method;
			}
		}
	}
}