function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/entity/item/ItemEntity',
		'methodName' : resolveName('m_6469_'), // hurt
		'methodDesc' : '(Lnet/minecraft/world/damagesource/DamageSource;F)Z'
	}

	var node = {
		'class' : 'net/minecraft/world/entity/item/ItemEntity',
		'methodName' : resolveName('m_146870_'), // discard
		'methodDesc' : '()V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Minecraft',
		'methodName' : 'handleItemEntityDamage',
		'methodDesc' : '(Lnet/minecraft/world/entity/item/ItemEntity;Lnet/minecraft/world/damagesource/DamageSource;)V'
	}

	var instructions = [ 
		insnDup("item entity"), 
		insnLoadObj(1, "source"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}