/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.units.UnitId;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStatesSet
extends AbstractSet<BlockState> {
    protected static final Object DUMMY = new Object();
    protected final Map<Block, Object> blocksWithAllStates = new ConcurrentHashMap<Block, Object>();
    protected final Map<Block, Map<BlockState, Object>> blockStatesMap = new ConcurrentHashMap<Block, Map<BlockState, Object>>();
    protected boolean sizeChanged = false;
    protected int size = 0;

    public static BlockStatesSet parseFrom(String[] strArray) {
        BlockStatesSet set = new BlockStatesSet();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            UnitId id = UnitId.from(str);
            set.add(id);
        }
        return set;
    }

    public Collection<Block> getBlocksWithAllStates() {
        return this.blocksWithAllStates.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.blocksWithAllStates.isEmpty() && this.blockStatesMap.isEmpty();
    }

    public boolean hasAllStates(Block block) {
        return this.blocksWithAllStates.containsKey(block);
    }

    public Optional<BlockState> getFirstFor(Block block) {
        Iterator<BlockState> iter;
        Iterator<Block> iter2 = this.blocksWithAllStates.keySet().iterator();
        if (iter2.hasNext()) {
            return Optional.of(iter2.next().m_49966_());
        }
        Map<BlockState, Object> states = this.blockStatesMap.get(block);
        if (states != null && (iter = states.keySet().iterator()).hasNext()) {
            return Optional.of(iter.next());
        }
        return Optional.empty();
    }

    @Override
    public boolean add(BlockState state) {
        boolean modified = false;
        Map<BlockState, Object> states = this.blockStatesMap.get(state.m_60734_());
        if (states != null) {
            modified = states.put(state, DUMMY) == null;
        } else {
            boolean bl = modified = this.createNewStateMapFor(state.m_60734_()).put(state, DUMMY) == null;
        }
        if (modified) {
            this.sizeChanged = true;
        }
        return modified;
    }

    @Override
    public boolean add(UnitId id) {
        BlockStatesSet set = id.getAllMatchedBlockStates();
        if (set != null) {
            return this.addAll(set);
        }
        return false;
    }

    public boolean addAllFor(Block block) {
        return this.blocksWithAllStates.put(block, DUMMY) == null;
    }

    @Override
    public boolean addAll(Collection<? extends BlockState> c) {
        if (c instanceof BlockStatesSet) {
            ((BlockStatesSet)c).getBlocksWithAllStates().forEach(block -> this.blocksWithAllStates.put((Block)block, DUMMY));
        }
        return super.addAll(c);
    }

    protected Map<BlockState, Object> createNewStateMapFor(Block block) {
        ConcurrentHashMap<BlockState, Object> states = new ConcurrentHashMap<BlockState, Object>();
        this.blockStatesMap.put(block, states);
        return states;
    }

    @Override
    public void clear() {
        this.blocksWithAllStates.clear();
        this.blockStatesMap.clear();
        this.sizeChanged = true;
    }

    @Override
    public int size() {
        if (this.sizeChanged) {
            this.size = 0;
            for (BlockState blockState : this) {
                ++this.size;
            }
            this.sizeChanged = false;
        }
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Block) {
            return this.blocksWithAllStates.containsKey(o);
        }
        if (o instanceof BlockState) {
            Block block = ((BlockState)o).m_60734_();
            if (this.blocksWithAllStates.containsKey(block)) {
                return true;
            }
            Map<BlockState, Object> map = this.blockStatesMap.get(block);
            return map != null && map.containsKey(o);
        }
        return false;
    }

    @Override
    public Iterator<BlockState> iterator() {
        return new StatesIterator();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Block) {
            return this.blocksWithAllStates.remove(o) != null;
        }
        if (o instanceof BlockState) {
            boolean modified = false;
            BlockState state = (BlockState)o;
            Map<BlockState, Object> states = this.blockStatesMap.get(state.m_60734_());
            if (states != null) {
                boolean bl = modified = states.remove(state) != null;
                if (states.isEmpty()) {
                    this.blockStatesMap.remove(state.m_60734_());
                }
            }
            if (modified) {
                this.sizeChanged = true;
            }
            return modified;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.removeIf(c::contains);
        result = this.blocksWithAllStates.keySet().removeIf(c::contains) || result;
        return result;
    }

    protected class StatesIterator
    implements Iterator<BlockState> {
        protected final Iterator<Map<BlockState, Object>> outter;
        protected Iterator<BlockState> inner;

        protected StatesIterator() {
            this.outter = BlockStatesSet.this.blockStatesMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.inner != null && this.inner.hasNext()) {
                return true;
            }
            while (this.outter.hasNext()) {
                this.inner = this.outter.next().keySet().iterator();
                if (!this.inner.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public BlockState next() {
            return this.inner.next();
        }

        @Override
        public void remove() {
            this.inner.remove();
            BlockStatesSet.this.sizeChanged = true;
        }
    }
}

