function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/simibubi/create/content/contraptions/components/actors/BlockBreakingKineticTileEntity',
		'methodName' : 'onBlockBroken', 
		'methodDesc' : '(Lnet/minecraft/world/level/block/state/BlockState;)V'
	}

	var node = {
		'class' : 'net/minecraft/world/level/Level',
		'methodName' : resolveName('m_6425_'), // getFluidState
		'methodDesc' : '(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onBlockBroken',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V'
	}

	var instructions = [ 
		insnDup2("level, pos"),
		insnLoadObj(1, "state"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}